/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.ASN1;
import org.jruby.ext.openssl.OpenSSLImpl;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.impl.ASN1Registry;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class X509Extensions {
    public static void createX509Ext(Ruby runtime, RubyModule mX509) {
        RubyClass cX509ExtFactory = mX509.defineClassUnder("ExtensionFactory", runtime.getObject(), ExtensionFactory.ALLOCATOR);
        RubyClass openSSLError = runtime.getModule("OpenSSL").getClass("OpenSSLError");
        mX509.defineClassUnder("ExtensionError", openSSLError, openSSLError.getAllocator());
        cX509ExtFactory.attr_reader(runtime.getCurrentContext(), new IRubyObject[]{runtime.newString("issuer_certificate"), runtime.newString("subject_certificate"), runtime.newString("subject_request"), runtime.newString("crl"), runtime.newString("config")});
        cX509ExtFactory.defineAnnotatedMethods(ExtensionFactory.class);
        RubyClass cX509Ext = mX509.defineClassUnder("Extension", runtime.getObject(), Extension.ALLOCATOR);
        cX509Ext.defineAnnotatedMethods(Extension.class);
    }

    private static byte[] getSHA1Digest(Ruby runtime, byte[] bytes2) {
        try {
            return MessageDigest.getInstance("SHA-1").digest(bytes2);
        }
        catch (GeneralSecurityException gse) {
            throw X509Extensions.newX509ExtError(runtime, gse.getMessage());
        }
    }

    private static RaiseException newX509ExtError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::X509::ExtensionError", message2);
    }

    public static class Extension
    extends RubyObject {
        private static final long serialVersionUID = -1160318458085651926L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new Extension(runtime, klass);
            }
        };
        private DERObjectIdentifier oid;
        private Object value;
        private boolean critical;

        public Extension(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        void setRealOid(DERObjectIdentifier oid2) {
            this.oid = oid2;
        }

        void setRealValue(Object value2) {
            this.value = value2;
        }

        void setRealCritical(boolean critical2) {
            this.critical = critical2;
        }

        DERObjectIdentifier getRealOid() {
            return this.oid;
        }

        Object getRealValue() {
            return this.value;
        }

        byte[] getRealValueBytes() throws IOException {
            if (this.value instanceof RubyString) {
                return ((RubyString)this.value).convertToString().getBytes();
            }
            if (this.value instanceof String) {
                return ByteList.plain((String)this.value);
            }
            if (this.value instanceof DEROctetString) {
                return ((DEROctetString)this.value).getOctets();
            }
            if (this.value instanceof DEREncodable) {
                return ((ASN1Encodable)this.value).getEncoded();
            }
            return ((ASN1.ASN1Data)this.value).toASN1().getDEREncoded();
        }

        boolean getRealCritical() {
            return this.critical;
        }

        DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
            DERObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return val1;
            }
            DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
            return val2;
        }

        @JRubyMethod(name={"initialize"}, rest=true)
        public IRubyObject _initialize(IRubyObject[] args2) {
            byte[] octets = null;
            if (args2.length == 1) {
                try {
                    ASN1InputStream is = new ASN1InputStream(OpenSSLImpl.to_der_if_possible(args2[0]).convertToString().getBytes());
                    DERObject obj = is.readObject();
                    ASN1Sequence seq = (ASN1Sequence)obj;
                    this.setRealOid((DERObjectIdentifier)seq.getObjectAt(0));
                    this.setRealCritical(((DERBoolean)seq.getObjectAt(1)).isTrue());
                    octets = ((DEROctetString)seq.getObjectAt(2)).getOctets();
                }
                catch (IOException ioe) {
                    throw X509Extensions.newX509ExtError(this.getRuntime(), ioe.getMessage());
                }
            } else if (args2.length > 1) {
                this.setRealOid(this.getObjectIdentifier(args2[0].toString()));
                this.setRealValue(args2[1]);
            }
            if (args2.length > 2) {
                this.setRealCritical(args2[2].isTrue());
            }
            if (args2.length > 0 && octets != null) {
                this.setRealValue(new String(ByteList.plain(octets)));
            }
            return this;
        }

        @JRubyMethod(name={"oid="})
        public IRubyObject set_oid(IRubyObject arg2) {
            System.err.println("WARNING: calling ext#oid=");
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"value="})
        public IRubyObject set_value(IRubyObject arg2) {
            System.err.println("WARNING: calling ext#value=");
            return this.getRuntime().getNil();
        }

        @JRubyMethod(name={"critical="})
        public IRubyObject set_critical(IRubyObject arg2) {
            System.err.println("WARNING: calling ext#critical=");
            return this.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject oid() {
            String val = ASN1.getSymLookup(this.getRuntime()).get(this.oid);
            if (null == val) {
                val = this.oid.toString();
            }
            return this.getRuntime().newString(val);
        }

        @JRubyMethod
        public IRubyObject value() {
            Ruby runtime = this.getRuntime();
            try {
                if (this.getRealOid().equals(new DERObjectIdentifier("2.5.29.19"))) {
                    ASN1Sequence seq2 = (ASN1Sequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                    String c = "";
                    String path2 = "";
                    if (seq2.size() > 0) {
                        c = "CA:" + (((DERBoolean)seq2.getObjectAt(0)).isTrue() ? "TRUE" : "FALSE");
                    }
                    if (seq2.size() > 1) {
                        path2 = ", pathlen:" + seq2.getObjectAt(1).toString();
                    }
                    return runtime.newString(c + path2);
                }
                if (this.getRealOid().equals(new DERObjectIdentifier("2.5.29.15"))) {
                    byte[] bx = this.getRealValueBytes();
                    byte[] bs = new byte[bx.length - 2];
                    System.arraycopy(bx, 2, bs, 0, bs.length);
                    byte b1 = 0;
                    byte b2 = bs[0];
                    if (bs.length > 1) {
                        b1 = bs[1];
                    }
                    StringBuffer sbe = new StringBuffer();
                    String sep = "";
                    if ((b2 & 0xFFFFFF80) != 0) {
                        sbe.append(sep).append("Decipher Only");
                        sep = ", ";
                    }
                    if ((b1 & 0xFFFFFF80) != 0) {
                        sbe.append(sep).append("Digital Signature");
                        sep = ", ";
                    }
                    if ((b1 & 0x40) != 0) {
                        sbe.append(sep).append("Non Repudiation");
                        sep = ", ";
                    }
                    if ((b1 & 0x20) != 0) {
                        sbe.append(sep).append("Key Encipherment");
                        sep = ", ";
                    }
                    if ((b1 & 0x10) != 0) {
                        sbe.append(sep).append("Data Encipherment");
                        sep = ", ";
                    }
                    if ((b1 & 8) != 0) {
                        sbe.append(sep).append("Key Agreement");
                        sep = ", ";
                    }
                    if ((b1 & 4) != 0) {
                        sbe.append(sep).append("Key Cert Sign");
                        sep = ", ";
                    }
                    if ((b1 & 2) != 0) {
                        sbe.append(sep).append("cRLSign");
                        sep = ", ";
                    }
                    if ((b1 & 1) != 0) {
                        sbe.append(sep).append("Encipher Only");
                    }
                    return runtime.newString(sbe.toString());
                }
                if (this.getRealOid().equals(new DERObjectIdentifier("2.16.840.1.113730.1.1"))) {
                    byte[] bx = this.getRealValueBytes();
                    byte b = bx[0];
                    StringBuffer sbe = new StringBuffer();
                    String sep = "";
                    if ((b & 0xFFFFFF80) != 0) {
                        sbe.append(sep).append("SSL Client");
                        sep = ", ";
                    }
                    if ((b & 0x40) != 0) {
                        sbe.append(sep).append("SSL Servern");
                        sep = ", ";
                    }
                    if ((b & 0x20) != 0) {
                        sbe.append(sep).append("S/MIME");
                        sep = ", ";
                    }
                    if ((b & 0x10) != 0) {
                        sbe.append(sep).append("Object Signing");
                        sep = ", ";
                    }
                    if ((b & 8) != 0) {
                        sbe.append(sep).append("Unused");
                        sep = ", ";
                    }
                    if ((b & 4) != 0) {
                        sbe.append(sep).append("SSL CA");
                        sep = ", ";
                    }
                    if ((b & 2) != 0) {
                        sbe.append(sep).append("S/MIME CA");
                        sep = ", ";
                    }
                    if ((b & 1) != 0) {
                        sbe.append(sep).append("Object Signing CA");
                    }
                    return runtime.newString(sbe.toString());
                }
                if (this.getRealOid().equals(new DERObjectIdentifier("2.5.29.14"))) {
                    byte[] b1 = this.getRealValueBytes();
                    byte[] b2 = new byte[b1.length - 2];
                    System.arraycopy(b1, 2, b2, 0, b2.length);
                    return runtime.newString(Utils.toHex(b2, ':'));
                }
                if (this.getRealOid().equals(new DERObjectIdentifier("2.5.29.35"))) {
                    DERSequence seq = (DERSequence)new ASN1InputStream(this.getRealValueBytes()).readObject();
                    StringBuffer out1 = new StringBuffer();
                    if (seq.size() > 0) {
                        out1.append("keyid:");
                        DERObject keyid = seq.getObjectAt(0).getDERObject();
                        if (keyid instanceof DEROctetString) {
                            out1.append(Utils.toHex(((DEROctetString)keyid).getOctets(), ':'));
                        } else {
                            out1.append(Utils.toHex(keyid.getDEREncoded(), ':'));
                        }
                    }
                    return runtime.newString(out1.toString());
                }
                if (this.getRealOid().equals(new DERObjectIdentifier("2.5.29.21"))) {
                    switch (RubyNumeric.fix2int(((IRubyObject)this.value).callMethod(runtime.getCurrentContext(), "value"))) {
                        case 0: {
                            return runtime.newString("Unspecified");
                        }
                        case 1: {
                            return runtime.newString("Key Compromise");
                        }
                        case 2: {
                            return runtime.newString("CA Compromise");
                        }
                        case 3: {
                            return runtime.newString("Affiliation Changed");
                        }
                        case 4: {
                            return runtime.newString("Superseded");
                        }
                        case 5: {
                            return runtime.newString("Cessation Of Operation");
                        }
                        case 6: {
                            return runtime.newString("Certificate Hold");
                        }
                        case 8: {
                            return runtime.newString("Remove From CRL");
                        }
                        case 9: {
                            return runtime.newString("Privilege Withdrawn");
                        }
                    }
                    return runtime.newString("Unspecified");
                }
                if (this.getRealOid().equals(new DERObjectIdentifier("2.5.29.17"))) {
                    try {
                        DERObject seq = new ASN1InputStream(this.getRealValueBytes()).readObject();
                        GeneralName[] n1 = null;
                        n1 = seq instanceof DERUnknownTag ? new GeneralName[]{GeneralName.getInstance(seq)} : (seq instanceof DERTaggedObject ? new GeneralName[]{GeneralName.getInstance(seq)} : GeneralNames.getInstance(seq).getNames());
                        StringBuffer sbe = new StringBuffer();
                        String sep = "";
                        for (int i2 = 0; i2 < n1.length; ++i2) {
                            sbe.append(sep);
                            if (n1[i2].getTagNo() == 2) {
                                sbe.append("DNS:");
                                sbe.append(((DERString)((Object)n1[i2].getName())).getString());
                            } else if (n1[i2].getTagNo() == 7) {
                                sbe.append("IP Address:");
                                byte[] bs = ((DEROctetString)n1[i2].getName()).getOctets();
                                String sep2 = "";
                                for (int j = 0; j < bs.length; ++j) {
                                    sbe.append(sep2);
                                    sbe.append(bs[j] & 0xFF);
                                    sep2 = ".";
                                }
                            } else {
                                sbe.append(n1[i2].toString());
                            }
                            sep = ", ";
                        }
                        return runtime.newString(sbe.toString());
                    }
                    catch (Exception e) {
                        return runtime.newString(this.getRealValue().toString());
                    }
                }
                try {
                    return ASN1.decode(runtime.getClassFromPath("OpenSSL::ASN1"), RubyString.newString(runtime, this.getRealValueBytes())).callMethod(runtime.getCurrentContext(), "value").callMethod(runtime.getCurrentContext(), "to_s");
                }
                catch (Exception e) {
                    return runtime.newString(this.getRealValue().toString());
                }
            }
            catch (IOException ioe) {
                throw X509Extensions.newX509ExtError(runtime, ioe.getMessage());
            }
        }

        @JRubyMethod(name={"critical?"})
        public IRubyObject critical_p() {
            return this.critical ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public IRubyObject to_der() {
            ASN1EncodableVector all = new ASN1EncodableVector();
            try {
                all.add(this.getRealOid());
                all.add(this.getRealCritical() ? DERBoolean.TRUE : DERBoolean.FALSE);
                all.add(new DEROctetString(this.getRealValueBytes()));
                return RubyString.newString(this.getRuntime(), new DERSequence(all).getDEREncoded());
            }
            catch (IOException ioe) {
                throw X509Extensions.newX509ExtError(this.getRuntime(), ioe.getMessage());
            }
        }
    }

    public static class ExtensionFactory
    extends RubyObject {
        private static final long serialVersionUID = 3180447029639456500L;
        public static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime, RubyClass klass) {
                return new ExtensionFactory(runtime, klass);
            }
        };

        public ExtensionFactory(Ruby runtime, RubyClass type2) {
            super(runtime, type2);
        }

        @JRubyMethod(rest=true, frame=true)
        public IRubyObject initialize(IRubyObject[] args2, Block unusedBlock) {
            Arity.checkArgumentCount(this.getRuntime(), args2, 0, 4);
            if (args2.length > 0 && !args2[0].isNil()) {
                this.set_issuer_cert(args2[0]);
            }
            if (args2.length > 1 && !args2[1].isNil()) {
                this.set_subject_cert(args2[1]);
            }
            if (args2.length > 2 && !args2[2].isNil()) {
                this.set_subject_req(args2[2]);
            }
            if (args2.length > 3 && !args2[3].isNil()) {
                this.set_crl(args2[3]);
            }
            return this;
        }

        @JRubyMethod(name={"issuer_certificate="})
        public IRubyObject set_issuer_cert(IRubyObject arg2) {
            this.setInstanceVariable("@issuer_certificate", arg2);
            return arg2;
        }

        @JRubyMethod(name={"subject_certificate="})
        public IRubyObject set_subject_cert(IRubyObject arg2) {
            this.setInstanceVariable("@subject_certificate", arg2);
            return arg2;
        }

        @JRubyMethod(name={"subject_request="})
        public IRubyObject set_subject_req(IRubyObject arg2) {
            this.setInstanceVariable("@subject_request", arg2);
            return arg2;
        }

        @JRubyMethod(name={"crl="})
        public IRubyObject set_crl(IRubyObject arg2) {
            this.setInstanceVariable("@crl", arg2);
            return arg2;
        }

        @JRubyMethod(name={"config="})
        public IRubyObject set_config(IRubyObject arg2) {
            this.setInstanceVariable("@config", arg2);
            return arg2;
        }

        private DERObjectIdentifier getObjectIdentifier(String nameOrOid) {
            DERObjectIdentifier val1 = ASN1.getOIDLookup(this.getRuntime()).get(nameOrOid.toLowerCase());
            if (null != val1) {
                return val1;
            }
            DERObjectIdentifier val2 = new DERObjectIdentifier(nameOrOid);
            return val2;
        }

        private static boolean isHexDigit(char c) {
            return '0' <= c && c <= '9' || 'A' <= c && c <= 'F' || 'a' <= c && c <= 'f';
        }

        private boolean isHexString(String str) {
            for (int i2 = 0; i2 < str.length(); ++i2) {
                if (ExtensionFactory.isHexDigit(str.charAt(i2))) continue;
                return false;
            }
            return true;
        }

        @JRubyMethod(rest=true)
        public IRubyObject create_ext(IRubyObject[] args2) {
            IRubyObject critical2 = this.getRuntime().getFalse();
            if (Arity.checkArgumentCount(this.getRuntime(), args2, 2, 3) == 3 && !args2[2].isNil()) {
                critical2 = args2[2];
            }
            String oid2 = args2[0].toString();
            String valuex = args2[1].toString();
            Object value2 = valuex;
            DERObjectIdentifier r_oid = null;
            try {
                r_oid = this.getObjectIdentifier(oid2);
            }
            catch (IllegalArgumentException e) {
                r_oid = null;
            }
            if (null == r_oid) {
                throw X509Extensions.newX509ExtError(this.getRuntime(), "unknown OID `" + oid2 + "'");
            }
            ThreadContext tc = this.getRuntime().getCurrentContext();
            Extension ext2 = (Extension)Utils.newRubyInstance(this.getRuntime(), "OpenSSL::X509::Extension");
            if (valuex.startsWith("critical,")) {
                critical2 = this.getRuntime().getTrue();
                valuex = valuex.substring(9).trim();
            }
            if (r_oid.equals(new DERObjectIdentifier("2.5.29.14"))) {
                if ("hash".equalsIgnoreCase(valuex)) {
                    IRubyObject pkey = this.getInstanceVariable("@subject_certificate").callMethod(tc, "public_key");
                    IRubyObject val = null;
                    val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", this.getRuntime().newFixnum(1)).callMethod(tc, "value");
                    byte[] b = X509Extensions.getSHA1Digest(this.getRuntime(), val.convertToString().getBytes());
                    value2 = new String(ByteList.plain(new DEROctetString(b).getDEREncoded()));
                } else if (valuex.length() == 20 || !this.isHexString(valuex)) {
                    value2 = new String(ByteList.plain(new DEROctetString(ByteList.plain(valuex)).getDEREncoded()));
                } else {
                    StringBuffer nstr = new StringBuffer();
                    for (int i2 = 0; i2 < valuex.length(); i2 += 2) {
                        if (i2 + 1 >= valuex.length()) {
                            throw X509Extensions.newX509ExtError(this.getRuntime(), oid2 + " = " + value2 + ": odd number of digits");
                        }
                        char c1 = valuex.charAt(i2);
                        char c2 = valuex.charAt(i2 + 1);
                        if (ExtensionFactory.isHexDigit(c1) && ExtensionFactory.isHexDigit(c2)) {
                            nstr.append(Character.toUpperCase(c1)).append(Character.toUpperCase(c2));
                        } else {
                            throw X509Extensions.newX509ExtError(this.getRuntime(), oid2 + " = " + value2 + ": illegal hex digit");
                        }
                        while (i2 + 2 < valuex.length() && valuex.charAt(i2 + 2) == ':') {
                            ++i2;
                        }
                    }
                    String v = nstr.toString();
                    byte[] arr = new byte[v.length() / 2];
                    for (int i3 = 0; i3 < v.length(); i3 += 2) {
                        arr[i3 / 2] = (byte)Integer.parseInt(v.substring(i3, i3 + 2), 16);
                    }
                    value2 = new String(ByteList.plain(new DEROctetString(arr).getDEREncoded()));
                }
            } else if (r_oid.equals(new DERObjectIdentifier("2.5.29.35"))) {
                String ourV = valuex;
                ASN1EncodableVector asnv = new ASN1EncodableVector();
                if (ourV.startsWith("keyid:always")) {
                    ourV = ourV.substring("keyid:always".length());
                    IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(tc, "public_key");
                    IRubyObject val = null;
                    val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", this.getRuntime().newFixnum(1)).callMethod(tc, "value");
                    byte[] b = X509Extensions.getSHA1Digest(this.getRuntime(), val.convertToString().getBytes());
                    asnv.add(new DEROctetString(b));
                } else if (ourV.startsWith("keyid")) {
                    ourV = ourV.substring("keyid".length());
                    IRubyObject pkey = this.getInstanceVariable("@issuer_certificate").callMethod(tc, "public_key");
                    IRubyObject val = null;
                    val = pkey instanceof PKeyRSA ? pkey.callMethod(tc, "to_der") : ASN1.decode(this.getRuntime().getClassFromPath("OpenSSL::ASN1"), pkey.callMethod(tc, "to_der")).callMethod(tc, "value").callMethod(tc, "[]", this.getRuntime().newFixnum(1)).callMethod(tc, "value");
                    byte[] b = X509Extensions.getSHA1Digest(this.getRuntime(), val.convertToString().getBytes());
                    asnv.add(new DEROctetString(b));
                }
                value2 = new String(ByteList.plain(new DERSequence(asnv).getDEREncoded()));
            } else if (r_oid.equals(new DERObjectIdentifier("2.5.29.18"))) {
                if (valuex.startsWith("issuer:copy")) {
                    RubyArray exts = (RubyArray)this.getInstanceVariable("@issuer_certificate").callMethod(tc, "extensions");
                    for (IRubyObject obj : exts.toJavaArray()) {
                        Extension exta = (Extension)obj;
                        if (!exta.getRealOid().equals(new DERObjectIdentifier("2.5.29.17"))) continue;
                        value2 = exta.getRealValue();
                        break;
                    }
                }
            } else if (r_oid.equals(new DERObjectIdentifier("2.5.29.19"))) {
                int i4;
                String[] spl = valuex.split(",");
                for (int i5 = 0; i5 < spl.length; ++i5) {
                    spl[i5] = spl[i5].trim();
                }
                ASN1EncodableVector asnv = new ASN1EncodableVector();
                for (i4 = 0; i4 < spl.length; ++i4) {
                    if (spl[i4].length() <= 3 || !spl[i4].substring(0, 3).equalsIgnoreCase("CA:")) continue;
                    asnv.add(new DERBoolean("TRUE".equalsIgnoreCase(spl[i4].substring(3).trim())));
                }
                for (i4 = 0; i4 < spl.length; ++i4) {
                    if (spl[i4].length() <= 8 || !spl[i4].substring(0, 8).equalsIgnoreCase("pathlen:")) continue;
                    asnv.add(new DERInteger(Integer.parseInt(spl[i4].substring(8).trim())));
                }
                value2 = new String(ByteList.plain(new DERSequence(asnv).getDEREncoded()));
            } else if (r_oid.equals(new DERObjectIdentifier("2.5.29.15"))) {
                int i6;
                byte[] inp = null;
                try {
                    String[] exx = valuex.split(":");
                    if (exx != null) {
                        inp = new byte[exx.length];
                        for (i6 = 0; i6 < exx.length; ++i6) {
                            inp[i6] = (byte)Integer.parseInt(exx[i6], 16);
                        }
                    }
                }
                catch (Exception e) {
                    inp = null;
                }
                if (null == inp && valuex.length() < 3) {
                    inp = ByteList.plain(valuex);
                }
                if (inp == null) {
                    int i7;
                    byte v1 = 0;
                    byte v2 = 0;
                    String[] spl = valuex.split(",");
                    for (i7 = 0; i7 < spl.length; ++i7) {
                        spl[i7] = spl[i7].trim();
                    }
                    for (i7 = 0; i7 < spl.length; ++i7) {
                        if ("decipherOnly".equals(spl[i7].trim()) || "Decipher Only".equals(spl[i7].trim())) {
                            v2 = (byte)(v2 | 0xFFFFFF80);
                            continue;
                        }
                        if ("digitalSignature".equals(spl[i7].trim()) || "Digital Signature".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 0xFFFFFF80);
                            continue;
                        }
                        if ("nonRepudiation".equals(spl[i7].trim()) || "Non Repudiation".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 0x40);
                            continue;
                        }
                        if ("keyEncipherment".equals(spl[i7].trim()) || "Key Encipherment".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 0x20);
                            continue;
                        }
                        if ("dataEncipherment".equals(spl[i7].trim()) || "Data Encipherment".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 0x10);
                            continue;
                        }
                        if ("keyAgreement".equals(spl[i7].trim()) || "Key Agreement".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 8);
                            continue;
                        }
                        if ("keyCertSign".equals(spl[i7].trim()) || "Key Cert Sign".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 4);
                            continue;
                        }
                        if ("cRLSign".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 2);
                            continue;
                        }
                        if ("encipherOnly".equals(spl[i7].trim()) || "Encipher Only".equals(spl[i7].trim())) {
                            v1 = (byte)(v1 | 1);
                            continue;
                        }
                        throw X509Extensions.newX509ExtError(this.getRuntime(), oid2 + " = " + valuex + ": unknown bit string argument");
                    }
                    inp = v2 != 0 ? new byte[]{v1, v2} : new byte[]{v1};
                }
                int unused2 = 0;
                for (i6 = inp.length - 1; i6 > -1; --i6) {
                    if (inp[i6] == 0) {
                        unused2 += 8;
                        continue;
                    }
                    byte a2 = inp[i6];
                    int x = 8;
                    while (a2 != 0) {
                        a2 = (byte)(a2 << 1);
                        --x;
                    }
                    unused2 += x;
                    break;
                }
                value2 = new String(ByteList.plain(new DERBitString(inp, unused2).getDEREncoded()));
            } else if (r_oid.equals(new DERObjectIdentifier("2.16.840.1.113730.1.1"))) {
                byte v = 0;
                if (valuex.length() < 3) {
                    byte[] inp = ByteList.plain(valuex);
                    v = inp[0];
                } else {
                    int i8;
                    String[] spl = valuex.split(",");
                    for (i8 = 0; i8 < spl.length; ++i8) {
                        spl[i8] = spl[i8].trim();
                    }
                    for (i8 = 0; i8 < spl.length; ++i8) {
                        if ("SSL Client".equals(spl[i8]) || "client".equals(spl[i8])) {
                            v = (byte)(v | 0xFFFFFF80);
                            continue;
                        }
                        if ("SSL Server".equals(spl[i8]) || "server".equals(spl[i8])) {
                            v = (byte)(v | 0x40);
                            continue;
                        }
                        if ("S/MIME".equals(spl[i8]) || "email".equals(spl[i8])) {
                            v = (byte)(v | 0x20);
                            continue;
                        }
                        if ("Object Signing".equals(spl[i8]) || "objsign".equals(spl[i8])) {
                            v = (byte)(v | 0x10);
                            continue;
                        }
                        if ("Unused".equals(spl[i8]) || "reserved".equals(spl[i8])) {
                            v = (byte)(v | 8);
                            continue;
                        }
                        if ("SSL CA".equals(spl[i8]) || "sslCA".equals(spl[i8])) {
                            v = (byte)(v | 4);
                            continue;
                        }
                        if ("S/MIME CA".equals(spl[i8]) || "emailCA".equals(spl[i8])) {
                            v = (byte)(v | 2);
                            continue;
                        }
                        if ("Object Signing CA".equals(spl[i8]) || "objCA".equals(spl[i8])) {
                            v = (byte)(v | 1);
                            continue;
                        }
                        throw X509Extensions.newX509ExtError(this.getRuntime(), oid2 + " = " + valuex + ": unknown bit string argument");
                    }
                }
                int unused3 = 0;
                if (v == 0) {
                    unused3 += 8;
                } else {
                    byte a2 = v;
                    int x = 8;
                    while (a2 != 0) {
                        a2 = (byte)(a2 << 1);
                        --x;
                    }
                    unused3 += x;
                }
                value2 = new DERBitString(new byte[]{v}, unused3);
            } else if (r_oid.equals(new DERObjectIdentifier("2.5.29.17"))) {
                if (valuex.startsWith("DNS:")) {
                    value2 = new String(ByteList.plain(new GeneralNames(new GeneralName(2, new DERIA5String(valuex.substring(4)))).getDEREncoded()));
                } else if (valuex.startsWith("IP:")) {
                    String[] numbers = valuex.substring(3).split("\\.");
                    byte[] bs = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                    value2 = new String(ByteList.plain(new GeneralNames(new GeneralName(7, new DEROctetString(bs))).getDEREncoded()));
                } else if (valuex.startsWith("IP Address:")) {
                    String[] numbers = valuex.substring(11).split("\\.");
                    byte[] bs = new byte[]{(byte)(Integer.parseInt(numbers[0]) & 0xFF), (byte)(Integer.parseInt(numbers[1]) & 0xFF), (byte)(Integer.parseInt(numbers[2]) & 0xFF), (byte)(Integer.parseInt(numbers[3]) & 0xFF)};
                    value2 = new String(ByteList.plain(new GeneralNames(new GeneralName(7, new DEROctetString(bs))).getDEREncoded()));
                }
            } else if (r_oid.equals(new DERObjectIdentifier("2.5.29.37"))) {
                String[] spl = valuex.split(", ?");
                ASN1EncodableVector vector = new ASN1EncodableVector();
                for (String name2 : spl) {
                    vector.add(ASN1Registry.sym2oid(name2));
                }
                value2 = new DERSequence(vector);
            } else {
                value2 = new DEROctetString(new DEROctetString(ByteList.plain(valuex)).getDEREncoded());
            }
            ext2.setRealOid(r_oid);
            ext2.setRealValue(value2);
            ext2.setRealCritical(critical2.isTrue());
            return ext2;
        }
    }
}

