/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyException;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.ASTInterpreter;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.unsafe.UnsafeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RescueNode
extends Node {
    private final Node bodyNode;
    private final RescueBodyNode rescueNode;
    private final Node elseNode;

    public RescueNode(ISourcePosition position, Node bodyNode, RescueBodyNode rescueNode, Node elseNode) {
        super(position);
        this.bodyNode = bodyNode;
        this.rescueNode = rescueNode;
        this.elseNode = elseNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.RESCUENODE;
    }

    @Override
    public Object accept(NodeVisitor iVisitor) {
        return iVisitor.visitRescueNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getElseNode() {
        return this.elseNode;
    }

    public RescueBodyNode getRescueNode() {
        return this.rescueNode;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.rescueNode, this.bodyNode, this.elseNode);
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        return this.interpretWithJavaExceptions(runtime, context, self, aBlock);
    }

    /*
     * Exception decompiling
     */
    private IRubyObject interpretWithJavaExceptions(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private IRubyObject handleException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, RaiseException raiseJump) {
        RubyException raisedException = raiseJump.getException();
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isExceptionHandled(raisedException, exceptions, context).isTrue()) continue;
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        throw raiseJump;
    }

    private IRubyObject handleJavaException(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock, Throwable throwable) {
        for (RescueBodyNode cRescueNode = this.rescueNode; cRescueNode != null; cRescueNode = cRescueNode.getOptRescueNode()) {
            IRubyObject exceptionObj;
            IRubyObject[] exceptions = this.getExceptions(cRescueNode, runtime, context, self, aBlock);
            if (!RuntimeHelpers.isJavaExceptionHandled(throwable, exceptions, context).isTrue()) continue;
            if (exceptions.length == 1 && exceptions[0] == runtime.getNativeException()) {
                exceptionObj = new NativeException(runtime, runtime.getNativeException(), throwable);
                ((NativeException)exceptionObj).prepareIntegratedBacktrace(context, throwable.getStackTrace());
            } else {
                exceptionObj = JavaUtil.convertJavaToUsableRubyObject(runtime, throwable);
            }
            runtime.getGlobalVariables().set("$!", exceptionObj);
            return cRescueNode.interpret(runtime, context, self, aBlock);
        }
        UnsafeFactory.getUnsafe().throwException(throwable);
        throw new RuntimeException("Unsafe.throwException failed");
    }

    private IRubyObject executeBody(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        if (this.bodyNode == null) {
            return runtime.getNil();
        }
        return this.bodyNode.interpret(runtime, context, self, aBlock);
    }

    private IRubyObject[] getExceptions(RescueBodyNode cRescueNode, Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        Node exceptionNodes = cRescueNode.getExceptionNodes();
        IRubyObject[] exceptions = exceptionNodes == null ? new IRubyObject[]{runtime.getStandardError()} : ASTInterpreter.setupArgs(runtime, context, exceptionNodes, self, aBlock);
        return exceptions;
    }
}

