/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.profile.Invocation;
import org.jruby.runtime.profile.MethodData;
import org.jruby.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractProfilePrinter {
    private static final String PROFILER_START_HASH_METHOD = "JRuby::Profiler.start";
    private static final String PROFILER_STOP_HASH_METHOD = "JRuby::Profiler.stop";

    public void printProfile(PrintStream out) {
    }

    public void printProfile(RubyIO out) {
        this.printProfile(new PrintStream(out.getOutStream()));
    }

    protected void pad(PrintStream out, int size2, String body) {
        this.pad(out, size2, body, true);
    }

    protected void pad(PrintStream out, int size2, String body, boolean front) {
        int i2;
        if (front) {
            for (i2 = 0; i2 < size2 - body.length(); ++i2) {
                out.print(' ');
            }
        }
        out.print(body);
        if (!front) {
            for (i2 = 0; i2 < size2 - body.length(); ++i2) {
                out.print(' ');
            }
        }
    }

    protected String nanoString(long nanoTime) {
        DecimalFormat formatter = new DecimalFormat("##0.00");
        return formatter.format((double)nanoTime / 1.0E9);
    }

    public boolean isProfilerInvocation(Invocation inv) {
        return this.isThisProfilerInvocation(inv.getMethodSerialNumber()) || inv.getParent() != null && this.isProfilerInvocation(inv.getParent());
    }

    public boolean isThisProfilerInvocation(int serial2) {
        String start2 = PROFILER_START_HASH_METHOD;
        String stop2 = PROFILER_STOP_HASH_METHOD;
        String name2 = this.methodName(serial2);
        return name2.hashCode() == PROFILER_START_HASH_METHOD.hashCode() && name2.equals(PROFILER_START_HASH_METHOD) || name2.hashCode() == PROFILER_STOP_HASH_METHOD.hashCode() && name2.equals(PROFILER_STOP_HASH_METHOD);
    }

    public String methodName(int serial2) {
        return AbstractProfilePrinter.getMethodName(serial2);
    }

    public static String getMethodName(int serial2) {
        String displayName;
        if (serial2 == 0) {
            return "(top)";
        }
        Ruby runtime = Ruby.getGlobalRuntime();
        String[] profiledNames = runtime.profiledNames;
        DynamicMethod[] profiledMethods = runtime.profiledMethods;
        if (serial2 < profiledNames.length) {
            String name2 = profiledNames[serial2];
            DynamicMethod method2 = profiledMethods[serial2];
            displayName = AbstractProfilePrinter.moduleHashMethod(method2.getImplementationClass(), name2);
        } else {
            displayName = "<unknown>";
        }
        return displayName;
    }

    protected static String moduleHashMethod(RubyModule module, String name2) {
        if (module instanceof MetaClass) {
            IRubyObject obj = ((MetaClass)module).getAttached();
            if (obj instanceof RubyModule) {
                return ((RubyModule)obj).getName() + "." + name2;
            }
            if (obj instanceof RubyObject) {
                return ((RubyObject)obj).getType().getName() + "(singleton)#" + name2;
            }
            return "unknown#" + name2;
        }
        if (module.isSingleton()) {
            return ((RubyClass)module).getRealClass().getName() + "(singleton)#" + name2;
        }
        if (module instanceof RubyClass) {
            return module.getName() + "#" + name2;
        }
        return module.getName() + "." + name2;
    }

    protected Map<Integer, MethodData> methodData(Invocation top) {
        HashMap<Integer, MethodData> methods2 = new HashMap<Integer, MethodData>();
        MethodData data2 = new MethodData(0);
        methods2.put(0, data2);
        data2.invocations.add(top);
        this.methodData1(methods2, top);
        return methods2;
    }

    private void methodData1(Map<Integer, MethodData> methods2, Invocation inv) {
        for (IntHashMap.Entry entry : inv.getChildren().entrySet()) {
            Invocation child = (Invocation)entry.getValue();
            int serial2 = child.getMethodSerialNumber();
            MethodData data2 = methods2.get(serial2);
            if (data2 == null) {
                data2 = new MethodData(serial2);
                methods2.put(serial2, data2);
            }
            data2.invocations.add(child);
            this.methodData1(methods2, child);
        }
    }
}

