/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Splat
extends Operand {
    private final Operand array;

    public Splat(Operand array) {
        this.array = array;
    }

    @Override
    public boolean hasKnownValue() {
        return false;
    }

    public String toString() {
        return "*" + this.array;
    }

    public Operand getArray() {
        return this.array;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newArray = this.array.getSimplifiedOperand(valueMap, force);
        return newArray == this.array ? this : new Splat(newArray);
    }

    @Override
    public Operand fetchCompileTimeArrayElement(int argIndex, boolean getSubArray) {
        return this.array.fetchCompileTimeArrayElement(argIndex, getSubArray);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.array.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return this.hasKnownValue() ? this : new Splat(this.array.cloneForInlining(ii));
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        IRubyObject arrayVal = (IRubyObject)this.array.retrieve(context, self, currDynScope, temp);
        return context.getRuntime().is1_9() ? RuntimeHelpers.splatValue19(arrayVal) : RuntimeHelpers.splatValue(arrayVal);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Splat(this);
    }
}

