/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.runtime.ThreadContext;

public class BooleanLiteral
extends ImmutableLiteral {
    private final boolean truthy;

    public BooleanLiteral(boolean truthy) {
        this.truthy = truthy;
    }

    public Object createCacheObject(ThreadContext context) {
        return context.getRuntime().newBoolean(this.isTrue());
    }

    public boolean isTrue() {
        return this.truthy;
    }

    public boolean isFalse() {
        return !this.truthy;
    }

    public String toString() {
        return this.isTrue() ? "true" : "false";
    }

    public void visit(IRVisitor visitor) {
        visitor.BooleanLiteral(this);
    }
}

