/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions.calladapter;

import org.jruby.RubyMethod;
import org.jruby.RubyProc;
import org.jruby.ir.instructions.calladapter.CallAdapter;
import org.jruby.ir.operands.Operand;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public abstract class ClosureCallAdapter
extends CallAdapter {
    private Operand closure;

    public ClosureCallAdapter(CallSite callSite, Operand closure) {
        super(callSite);
        this.closure = closure;
    }

    protected Block prepareBlock(ThreadContext context, IRubyObject self, DynamicScope currDynScope, Object[] temp) {
        Block block;
        if (this.closure == null) {
            return Block.NULL_BLOCK;
        }
        Object value2 = this.closure.retrieve(context, self, currDynScope, temp);
        if (value2 instanceof Block) {
            block = (Block)value2;
        } else if (value2 instanceof RubyProc) {
            block = ((RubyProc)value2).getBlock();
        } else if (value2 instanceof RubyMethod) {
            block = ((RubyProc)((RubyMethod)value2).to_proc(context, null)).getBlock();
        } else if (value2 instanceof IRubyObject && ((IRubyObject)value2).isNil()) {
            block = Block.NULL_BLOCK;
        } else if (value2 instanceof IRubyObject) {
            block = ((RubyProc)TypeConverter.convertToType((IRubyObject)value2, context.getRuntime().getProc(), "to_proc", true)).getBlock();
        } else {
            throw new RuntimeException("Unhandled case in CallInstr:prepareBlock.  Got block arg: " + value2);
        }
        return block;
    }
}

