/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefineMetaClassInstr
extends Instr
implements ResultInstr {
    private IRModuleBody metaClassBody;
    private Operand object;
    private Variable result;

    public DefineMetaClassInstr(Variable result2, Operand object, IRModuleBody metaClassBody) {
        super(Operation.DEF_META_CLASS);
        assert (result2 != null) : "DefineMetaClassInstr result is null";
        this.metaClassBody = metaClassBody;
        this.object = object;
        this.result = result2;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.object};
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.object = this.object.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.metaClassBody.getName() + ", " + this.object + ", " + this.metaClassBody.getFileName() + ")";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new DefineMetaClassInstr(ii.getRenamedVariable(this.result), this.object.cloneForInlining(ii), this.metaClassBody);
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        Ruby runtime = context.getRuntime();
        IRubyObject obj = (IRubyObject)this.object.retrieve(context, self, currDynScope, temp);
        RubyClass singletonClass = RuntimeHelpers.getSingletonClass(runtime, obj);
        this.metaClassBody.getStaticScope().setModule(singletonClass);
        return new InterpretedIRMethod(this.metaClassBody, Visibility.PUBLIC, singletonClass);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.DefineMetaClassInstr(this);
    }

    public IRModuleBody getMetaClassBody() {
        return this.metaClassBody;
    }

    public Operand getObject() {
        return this.object;
    }
}

