/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.timeout;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.RegexpOptions;

public class Timeout
implements Library {
    private static ScheduledExecutorService timeoutExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory());

    public void load(Ruby runtime, boolean wrap2) throws IOException {
        RubyModule timeout2 = runtime.defineModule("Timeout");
        RubyClass superclass2 = runtime.is1_9() ? runtime.getRuntimeError() : runtime.getInterrupt();
        RubyClass timeoutError = runtime.defineClassUnder("Error", superclass2, superclass2.getAllocator(), timeout2);
        runtime.defineClassUnder("ExitException", runtime.getException(), runtime.getException().getAllocator(), timeout2);
        RubyClass anonEx = runtime.defineClassUnder("AnonymousException", runtime.getException(), runtime.getException().getAllocator(), timeout2);
        anonEx.setBaseName(null);
        timeout2.defineConstant("THIS_FILE", RubyRegexp.newRegexp(runtime, "timeout\\.rb", new RegexpOptions()));
        timeout2.defineConstant("CALLER_OFFSET", RubyFixnum.newFixnum(runtime, 0L));
        timeout2.defineAnnotatedMethods(Timeout.class);
        runtime.getObject().defineConstant("TimeoutError", timeoutError);
        runtime.getObject().defineAnnotatedMethods(TimeoutToplevel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject timeout2, IRubyObject seconds, Block block) {
        IRubyObject iRubyObject;
        if (seconds.isNil() || RuntimeHelpers.invoke(context, seconds, "zero?").isTrue()) {
            return block.yieldSpecific(context);
        }
        Ruby runtime = context.getRuntime();
        if (runtime.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        Runnable timeoutRunnable = Timeout.prepareRunnable(currentThread, runtime, latch);
        ScheduledFuture<?> timeoutFuture = null;
        try {
            timeoutFuture = timeoutExecutor.schedule(timeoutRunnable, (long)(seconds.convertToFloat().getDoubleValue() * 1000000.0), TimeUnit.MICROSECONDS);
            iRubyObject = block.yield(context, seconds);
        }
        catch (Throwable throwable) {
            try {
                Timeout.killTimeoutThread(context, timeoutFuture, latch);
                throw throwable;
            }
            catch (RaiseException re) {
                if (re.getException().getMetaClass() == runtime.getClassFromPath("Timeout::AnonymousException")) {
                    return Timeout.raiseTimeoutError(context, re);
                }
                throw re;
            }
        }
        Timeout.killTimeoutThread(context, timeoutFuture, latch);
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(module=true)
    public static IRubyObject timeout(ThreadContext context, IRubyObject timeout2, IRubyObject seconds, IRubyObject exceptionType, Block block) {
        IRubyObject iRubyObject;
        if (seconds.isNil() || RuntimeHelpers.invoke(context, seconds, "zero?").isTrue()) {
            return block.yieldSpecific(context);
        }
        Ruby runtime = context.getRuntime();
        if (runtime.getThreadService().getCritical()) {
            return Timeout.raiseBecauseCritical(context);
        }
        IRubyObject exception2 = exceptionType.isNil() ? runtime.getClassFromPath("Timeout::AnonymousException") : exceptionType;
        RubyThread currentThread = context.getThread();
        AtomicBoolean latch = new AtomicBoolean(false);
        Runnable timeoutRunnable = Timeout.prepareRunnableWithException(currentThread, exception2, runtime, latch);
        ScheduledFuture<?> timeoutFuture = null;
        try {
            timeoutFuture = timeoutExecutor.schedule(timeoutRunnable, (long)(seconds.convertToFloat().getDoubleValue() * 1000000.0), TimeUnit.MICROSECONDS);
            iRubyObject = block.yield(context, seconds);
        }
        catch (Throwable throwable) {
            try {
                Timeout.killTimeoutThread(context, timeoutFuture, latch);
                throw throwable;
            }
            catch (RaiseException re) {
                if (re.getException().getMetaClass() == exception2 && exceptionType.isNil()) {
                    return Timeout.raiseTimeoutError(context, re);
                }
                throw re;
            }
        }
        Timeout.killTimeoutThread(context, timeoutFuture, latch);
        return iRubyObject;
    }

    private static Runnable prepareRunnable(final RubyThread currentThread, final Ruby runtime, final AtomicBoolean latch) {
        Runnable timeoutRunnable = new Runnable(){

            public void run() {
                if (latch.compareAndSet(false, true)) {
                    Timeout.raiseInThread(runtime, currentThread, runtime.getClassFromPath("Timeout::AnonymousException"));
                }
            }
        };
        return timeoutRunnable;
    }

    private static Runnable prepareRunnableWithException(final RubyThread currentThread, final IRubyObject exception2, final Ruby runtime, final AtomicBoolean latch) {
        Runnable timeoutRunnable = new Runnable(){

            public void run() {
                if (latch.compareAndSet(false, true)) {
                    Timeout.raiseInThread(runtime, currentThread, exception2);
                }
            }
        };
        return timeoutRunnable;
    }

    private static void killTimeoutThread(ThreadContext context, Future timeoutFuture, AtomicBoolean latch) {
        if (latch.compareAndSet(false, true)) {
            timeoutFuture.cancel(false);
            if (timeoutExecutor instanceof ScheduledThreadPoolExecutor && timeoutFuture instanceof Runnable) {
                ((ScheduledThreadPoolExecutor)timeoutExecutor).remove((Runnable)((Object)timeoutFuture));
            }
        } else {
            try {
                timeoutFuture.get();
            }
            catch (ExecutionException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            context.pollThreadEvents();
        }
    }

    private static void raiseInThread(Ruby runtime, RubyThread currentThread, IRubyObject exception2) {
        if (currentThread.alive_p().isTrue()) {
            currentThread.internalRaise(new IRubyObject[]{exception2, runtime.newString("execution expired")});
        }
    }

    private static IRubyObject raiseBecauseCritical(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        return RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{runtime.getThreadError(), runtime.newString("timeout within critical section")}, Block.NULL_BLOCK);
    }

    private static IRubyObject raiseTimeoutError(ThreadContext context, RaiseException re) {
        Ruby runtime = context.getRuntime();
        return RubyKernel.raise(context, runtime.getKernel(), new IRubyObject[]{runtime.getClassFromPath("Timeout::Error"), re.getException().callMethod(context, "message"), re.getException().callMethod(context, "backtrace")}, Block.NULL_BLOCK);
    }

    public static class TimeoutToplevel {
        @JRubyMethod(required=1, optional=1, visibility=Visibility.PRIVATE)
        public static IRubyObject timeout(ThreadContext context, IRubyObject self, IRubyObject[] args2, Block block) {
            RubyModule timeout2 = context.getRuntime().getModule("Timeout");
            switch (args2.length) {
                case 1: {
                    return Timeout.timeout(context, timeout2, args2[0], block);
                }
                case 2: {
                    return Timeout.timeout(context, timeout2, args2[0], args2[1], block);
                }
            }
            Arity.raiseArgumentError(context.getRuntime(), args2.length, 1, 2);
            return context.getRuntime().getNil();
        }
    }
}

