/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectAdapter;
import org.jruby.RubyString;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.SSL;
import org.jruby.ext.openssl.SSLContext;
import org.jruby.ext.openssl.Utils;
import org.jruby.ext.openssl.X509Cert;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class SSLSocket
extends RubyObject {
    private static final long serialVersionUID = -2276327900350542644L;
    private static ObjectAllocator SSLSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new SSLSocket(runtime, klass);
        }
    };
    private static RubyObjectAdapter api = JavaEmbedUtils.newObjectAdapter();
    private SSLContext rubyCtx;
    private SSLEngine engine;
    private RubyIO io = null;
    private ByteBuffer peerAppData;
    private ByteBuffer peerNetData;
    private ByteBuffer netData;
    private ByteBuffer dummy;
    private boolean initialHandshake = false;
    private SSLEngineResult.HandshakeStatus hsStatus;
    private SSLEngineResult.Status status = null;
    int verifyResult = 0;

    public static void createSSLSocket(Ruby runtime, RubyModule mSSL) {
        ThreadContext context = runtime.getCurrentContext();
        RubyClass cSSLSocket = mSSL.defineClassUnder("SSLSocket", runtime.getObject(), SSLSOCKET_ALLOCATOR);
        cSSLSocket.addReadWriteAttribute(context, "io");
        cSSLSocket.addReadWriteAttribute(context, "context");
        cSSLSocket.addReadWriteAttribute(context, "sync_close");
        cSSLSocket.defineAlias("to_io", "io");
        cSSLSocket.defineAnnotatedMethods(SSLSocket.class);
    }

    public SSLSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    public static RaiseException newSSLError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::SSL::SSLError", message2, false);
    }

    @JRubyMethod(name={"initialize"}, rest=true, frame=true)
    public IRubyObject _initialize(IRubyObject[] args2, Block unused2) {
        if (Arity.checkArgumentCount(this.getRuntime(), args2, 1, 2) == 1) {
            RubyClass sslContext = Utils.getClassFromPath(this.getRuntime(), "OpenSSL::SSL::SSLContext");
            this.rubyCtx = (SSLContext)api.callMethod(sslContext, "new");
        } else {
            this.rubyCtx = (SSLContext)args2[1];
        }
        Utils.checkKind(this.getRuntime(), args2[0], "IO");
        this.io = (RubyIO)args2[0];
        api.callMethod((IRubyObject)this, "io=", this.io);
        api.callMethod((IRubyObject)this.io, "sync=", this.getRuntime().getTrue());
        api.callMethod((IRubyObject)this, "context=", this.rubyCtx);
        api.callMethod((IRubyObject)this, "sync_close=", this.getRuntime().getFalse());
        this.rubyCtx.setup();
        return api.callSuper(this, args2);
    }

    private void ossl_ssl_setup() throws NoSuchAlgorithmException, KeyManagementException, IOException {
        if (null == this.engine) {
            Socket socket2 = this.getSocketChannel().socket();
            String peerHost = socket2.getInetAddress().getHostName();
            int peerPort = socket2.getPort();
            this.engine = this.rubyCtx.createSSLEngine(peerHost, peerPort);
            SSLSession session = this.engine.getSession();
            this.peerNetData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerAppData = ByteBuffer.allocate(session.getApplicationBufferSize());
            this.netData = ByteBuffer.allocate(session.getPacketBufferSize());
            this.peerNetData.limit(0);
            this.peerAppData.limit(0);
            this.netData.limit(0);
            this.dummy = ByteBuffer.allocate(0);
        }
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        if (!this.rubyCtx.isProtocolForClient()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            this.ossl_ssl_setup();
            this.engine.setUseClientMode(true);
            this.engine.beginHandshake();
            this.hsStatus = this.engine.getHandshakeStatus();
            this.initialHandshake = true;
            this.doHandshake();
        }
        catch (SSLHandshakeException e) {
            this.forceClose();
            Throwable v = e;
            while (v.getCause() != null && v instanceof SSLHandshakeException) {
                v = v.getCause();
            }
            throw SSL.newSSLError(runtime, v);
        }
        catch (NoSuchAlgorithmException ex) {
            this.forceClose();
            throw SSL.newSSLError(runtime, ex);
        }
        catch (KeyManagementException ex) {
            this.forceClose();
            throw SSL.newSSLError(runtime, ex);
        }
        catch (IOException ex) {
            this.forceClose();
            throw SSL.newSSLError(runtime, ex);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        Ruby runtime = context.getRuntime();
        if (!this.rubyCtx.isProtocolForServer()) {
            throw SSLSocket.newSSLError(runtime, "called a function you should not call");
        }
        try {
            int vfy = 0;
            this.ossl_ssl_setup();
            this.engine.setUseClientMode(false);
            if (!this.rubyCtx.isNil() && !this.rubyCtx.callMethod(context, "verify_mode").isNil()) {
                vfy = RubyNumeric.fix2int(this.rubyCtx.callMethod(context, "verify_mode"));
                if (vfy == 0) {
                    this.engine.setNeedClientAuth(false);
                    this.engine.setWantClientAuth(false);
                }
                if ((vfy & 1) != 0) {
                    this.engine.setWantClientAuth(true);
                }
                if ((vfy & 2) != 0) {
                    this.engine.setNeedClientAuth(true);
                }
            }
            this.engine.beginHandshake();
            this.hsStatus = this.engine.getHandshakeStatus();
            this.initialHandshake = true;
            this.doHandshake();
        }
        catch (SSLHandshakeException e) {
            throw SSL.newSSLError(runtime, e);
        }
        catch (NoSuchAlgorithmException ex) {
            throw SSL.newSSLError(runtime, ex);
        }
        catch (KeyManagementException ex) {
            throw SSL.newSSLError(runtime, ex);
        }
        catch (IOException ex) {
            throw SSL.newSSLError(runtime, ex);
        }
        return this;
    }

    @JRubyMethod
    public IRubyObject verify_result() {
        if (this.engine == null) {
            this.getRuntime().getWarnings().warn("SSL session is not started yet.");
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.verifyResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSelect(int operations) throws IOException {
        if (!(this.io.getChannel() instanceof SelectableChannel)) {
            return;
        }
        Ruby runtime = this.getRuntime();
        RubyThread thread2 = runtime.getCurrentContext().getThread();
        SelectableChannel selectable = (SelectableChannel)this.io.getChannel();
        boolean oldBlocking = selectable.isBlocking();
        selectable.configureBlocking(false);
        try {
            this.io.addBlockingThread(thread2);
            thread2.select(selectable, this.io, operations);
            thread2.pollThreadEvents();
            Object var7_6 = null;
            this.io.removeBlockingThread(thread2);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.io.removeBlockingThread(thread2);
            selectable.configureBlocking(oldBlocking);
            throw throwable;
        }
        selectable.configureBlocking(oldBlocking);
    }

    private void doHandshake() throws IOException {
        while (true) {
            this.waitSelect(5);
            if (this.hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
                if (this.initialHandshake) {
                    this.finishInitialHandshake();
                }
                return;
            }
            if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.doTasks();
                continue;
            }
            if (this.hsStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                if (this.readAndUnwrap() == -1 && this.hsStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
                    throw new SSLHandshakeException("Socket closed");
                }
                if (!this.initialHandshake || this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                this.waitSelect(1);
                continue;
            }
            if (this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            if (this.netData.hasRemaining()) {
                while (this.flushData()) {
                }
            }
            this.netData.clear();
            SSLEngineResult res = this.engine.wrap(this.dummy, this.netData);
            this.hsStatus = res.getHandshakeStatus();
            this.netData.flip();
            this.flushData();
        }
        assert (false) : "doHandshake() should never reach the NOT_HANDSHAKING state";
    }

    private void doTasks() {
        Runnable task;
        while ((task = this.engine.getDelegatedTask()) != null) {
            task.run();
        }
        this.hsStatus = this.engine.getHandshakeStatus();
        this.verifyResult = this.rubyCtx.getLastVerifyResult();
    }

    private boolean flushData() throws IOException {
        try {
            this.writeToChannel(this.netData);
        }
        catch (IOException ioe) {
            this.netData.position(this.netData.limit());
            throw ioe;
        }
        return !this.netData.hasRemaining();
    }

    private int writeToChannel(ByteBuffer buffer) throws IOException {
        int totalWritten = 0;
        while (buffer.hasRemaining()) {
            totalWritten += this.getSocketChannel().write(buffer);
        }
        return totalWritten;
    }

    private void finishInitialHandshake() {
        this.initialHandshake = false;
    }

    public int write(ByteBuffer src) throws SSLException, IOException {
        if (this.initialHandshake) {
            throw new IOException("Writing not possible during handshake");
        }
        if (this.netData.hasRemaining()) {
            throw new IOException("Another thread may be writing");
        }
        this.netData.clear();
        SSLEngineResult res = this.engine.wrap(src, this.netData);
        this.netData.flip();
        this.flushData();
        return res.bytesConsumed();
    }

    public int read(ByteBuffer dst) throws IOException {
        int appBytesProduced;
        if (this.initialHandshake) {
            return 0;
        }
        if (this.engine.isInboundDone()) {
            return -1;
        }
        if (!(this.peerAppData.hasRemaining() || (appBytesProduced = this.readAndUnwrap()) != -1 && appBytesProduced != 0)) {
            return appBytesProduced;
        }
        int limit2 = Math.min(this.peerAppData.remaining(), dst.remaining());
        this.peerAppData.get(dst.array(), dst.arrayOffset(), limit2);
        dst.position(dst.arrayOffset() + limit2);
        return limit2;
    }

    private int readAndUnwrap() throws IOException {
        SSLEngineResult res;
        int bytesRead = this.getSocketChannel().read(this.peerNetData);
        if (!(bytesRead != -1 || this.peerNetData.hasRemaining() && this.status != SSLEngineResult.Status.BUFFER_UNDERFLOW)) {
            this.closeInbound();
            return -1;
        }
        this.peerAppData.clear();
        this.peerNetData.flip();
        while ((res = this.engine.unwrap(this.peerNetData, this.peerAppData)).getStatus() == SSLEngineResult.Status.OK && res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_UNWRAP && res.bytesProduced() == 0) {
        }
        if (res.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED) {
            this.finishInitialHandshake();
        }
        if (this.peerAppData.position() == 0 && res.getStatus() == SSLEngineResult.Status.OK && this.peerNetData.hasRemaining()) {
            res = this.engine.unwrap(this.peerNetData, this.peerAppData);
        }
        this.status = res.getStatus();
        this.hsStatus = res.getHandshakeStatus();
        if (bytesRead == -1 && !this.peerNetData.hasRemaining()) {
            this.closeInbound();
        }
        if (this.status == SSLEngineResult.Status.CLOSED) {
            this.doShutdown();
            return -1;
        }
        this.peerNetData.compact();
        this.peerAppData.flip();
        if (!(this.initialHandshake || this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_TASK && this.hsStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP && this.hsStatus != SSLEngineResult.HandshakeStatus.FINISHED)) {
            this.doHandshake();
        }
        return this.peerAppData.remaining();
    }

    private void closeInbound() {
        try {
            this.engine.closeInbound();
        }
        catch (SSLException sSLException) {
            // empty catch block
        }
    }

    private void doShutdown() throws IOException {
        if (this.engine.isOutboundDone()) {
            return;
        }
        this.netData.clear();
        try {
            this.engine.wrap(this.dummy, this.netData);
        }
        catch (Exception e1) {
            return;
        }
        this.netData.flip();
        this.flushData();
    }

    @JRubyMethod(rest=true, required=1, optional=1)
    public IRubyObject sysread(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.getRuntime();
        int len = RubyNumeric.fix2int(args2[0]);
        RubyString str = null;
        str = args2.length == 2 && !args2[1].isNil() ? args2[1].convertToString() : this.getRuntime().newString("");
        if (len == 0) {
            str.clear();
            return str;
        }
        if (len < 0) {
            throw runtime.newArgumentError("negative string size (or size too big)");
        }
        try {
            if (this.engine == null || !this.peerAppData.hasRemaining() && this.peerNetData.position() <= 0) {
                this.waitSelect(1);
            }
            ByteBuffer dst = ByteBuffer.allocate(len);
            int rr = -1;
            while (rr <= 0) {
                rr = this.engine == null ? this.getSocketChannel().read(dst) : this.read(dst);
                if (rr != -1) continue;
                throw this.getRuntime().newEOFError();
            }
            byte[] bss = new byte[rr];
            dst.position(dst.position() - rr);
            dst.get(bss);
            str.setValue(new ByteList(bss));
            return str;
        }
        catch (IOException ioe) {
            throw this.getRuntime().newIOError(ioe.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject syswrite(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.getRuntime();
        try {
            this.checkClosed();
            this.waitSelect(4);
            byte[] bls = arg2.convertToString().getBytes();
            ByteBuffer b1 = ByteBuffer.wrap(bls);
            int written = this.engine == null ? this.writeToChannel(b1) : this.write(b1);
            ((RubyIO)api.callMethod(this, "io")).flush();
            return this.getRuntime().newFixnum(written);
        }
        catch (IOException ioe) {
            throw runtime.newIOError(ioe.getMessage());
        }
    }

    private void checkClosed() {
        if (!this.getSocketChannel().isOpen()) {
            throw this.getRuntime().newIOError("closed stream");
        }
    }

    private void forceClose() {
        this.close(true);
    }

    private void close(boolean force) {
        if (this.engine == null) {
            throw this.getRuntime().newEOFError();
        }
        this.engine.closeOutbound();
        if (!force && this.netData.hasRemaining()) {
            return;
        }
        try {
            this.doShutdown();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @JRubyMethod
    public IRubyObject sysclose() {
        this.close(this.rubyCtx.isProtocolForClient());
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (this.callMethod(tc, "sync_close").isTrue()) {
            this.callMethod(tc, "io").callMethod(tc, "close");
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject cert() {
        try {
            Certificate[] cert2 = this.engine.getSession().getLocalCertificates();
            if (cert2.length > 0) {
                return X509Cert.wrap(this.getRuntime(), cert2[0]);
            }
        }
        catch (java.security.cert.CertificateEncodingException ex) {
            throw X509Cert.newCertificateError(this.getRuntime(), ex);
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert() {
        block4: {
            try {
                Certificate[] cert2 = this.engine.getSession().getPeerCertificates();
                if (cert2.length > 0) {
                    return X509Cert.wrap(this.getRuntime(), cert2[0]);
                }
            }
            catch (java.security.cert.CertificateEncodingException ex) {
                throw X509Cert.newCertificateError(this.getRuntime(), ex);
            }
            catch (SSLPeerUnverifiedException ex) {
                if (!this.getRuntime().isVerbose()) break block4;
                this.getRuntime().getWarnings().warning(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
            }
        }
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject peer_cert_chain() {
        try {
            X509Certificate[] certs = this.engine.getSession().getPeerCertificateChain();
            RubyArray arr = this.getRuntime().newArray(certs.length);
            for (int i2 = 0; i2 < certs.length; ++i2) {
                arr.add(X509Cert.wrap(this.getRuntime(), certs[i2]));
            }
            return arr;
        }
        catch (CertificateEncodingException e) {
            throw X509Cert.newCertificateError(this.getRuntime(), e);
        }
        catch (SSLPeerUnverifiedException ex) {
            if (this.getRuntime().isVerbose()) {
                this.getRuntime().getWarnings().warning(String.format("%s: %s", ex.getClass().getName(), ex.getMessage()));
            }
            return this.getRuntime().getNil();
        }
    }

    @JRubyMethod
    public IRubyObject cipher() {
        return this.getRuntime().newString(this.engine.getSession().getCipherSuite());
    }

    @JRubyMethod
    public IRubyObject state() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#state");
        return this.getRuntime().getNil();
    }

    @JRubyMethod
    public IRubyObject pending() {
        System.err.println("WARNING: unimplemented method called: SSLSocket#pending");
        return this.getRuntime().getNil();
    }

    private SocketChannel getSocketChannel() {
        return (SocketChannel)this.io.getChannel();
    }
}

