/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.openssl.Digest;
import org.jruby.ext.openssl.PKeyDH;
import org.jruby.ext.openssl.PKeyDSA;
import org.jruby.ext.openssl.PKeyRSA;
import org.jruby.ext.openssl.Utils;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class PKey
extends RubyObject {
    private static final long serialVersionUID = 6114668087816965720L;

    public static void createPKey(Ruby runtime, RubyModule ossl) {
        RubyModule mPKey = ossl.defineModuleUnder("PKey");
        RubyClass cPKey = mPKey.defineClassUnder("PKey", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        RubyClass openSSLError = ossl.getClass("OpenSSLError");
        mPKey.defineClassUnder("PKeyError", openSSLError, openSSLError.getAllocator());
        cPKey.defineAnnotatedMethods(PKey.class);
        PKeyRSA.createPKeyRSA(runtime, mPKey);
        PKeyDSA.createPKeyDSA(runtime, mPKey);
        PKeyDH.createPKeyDH(runtime, mPKey, cPKey);
    }

    public static RaiseException newPKeyError(Ruby runtime, String message2) {
        return Utils.newError(runtime, "OpenSSL::PKey::PKeyError", message2);
    }

    public PKey(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod
    public IRubyObject initialize(ThreadContext context) {
        return this;
    }

    PublicKey getPublicKey() {
        return null;
    }

    PrivateKey getPrivateKey() {
        return null;
    }

    String getAlgorithm() {
        return "NONE";
    }

    public abstract IRubyObject to_der();

    @JRubyMethod
    public IRubyObject sign(IRubyObject digest2, IRubyObject data2) {
        if (!this.callMethod(this.getRuntime().getCurrentContext(), "private?").isTrue()) {
            throw this.getRuntime().newArgumentError("Private key is needed.");
        }
        String digAlg = ((Digest)digest2).getShortAlgorithm();
        try {
            Signature sig = Signature.getInstance(digAlg + "WITH" + this.getAlgorithm());
            sig.initSign(this.getPrivateKey());
            byte[] inp = data2.convertToString().getBytes();
            sig.update(inp);
            byte[] sigge = sig.sign();
            return RubyString.newString(this.getRuntime(), sigge);
        }
        catch (GeneralSecurityException gse) {
            throw PKey.newPKeyError(this.getRuntime(), gse.getMessage());
        }
    }

    @JRubyMethod
    public IRubyObject verify(IRubyObject digest2, IRubyObject sig, IRubyObject data2) {
        boolean valid;
        if (!(digest2 instanceof Digest)) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid digest");
        }
        if (!(sig instanceof RubyString)) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid signature");
        }
        if (!(data2 instanceof RubyString)) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid data");
        }
        byte[] sigBytes = ((RubyString)sig).getBytes();
        byte[] dataBytes = ((RubyString)data2).getBytes();
        String algorithm = ((Digest)digest2).getShortAlgorithm() + "WITH" + this.getAlgorithm();
        try {
            Signature signature = Signature.getInstance(algorithm);
            signature.initVerify(this.getPublicKey());
            signature.update(dataBytes);
            valid = signature.verify(sigBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw PKey.newPKeyError(this.getRuntime(), "unsupported algorithm: " + algorithm);
        }
        catch (SignatureException e) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid signature");
        }
        catch (InvalidKeyException e) {
            throw PKey.newPKeyError(this.getRuntime(), "invalid key");
        }
        return this.getRuntime().newBoolean(valid);
    }

    protected static void addSplittedAndFormatted(StringBuilder result2, BigInteger value2) {
        String v = value2.toString(16);
        if (v.length() % 2 != 0) {
            v = "0" + v;
        }
        String sep = "";
        for (int i2 = 0; i2 < v.length(); i2 += 2) {
            result2.append(sep);
            if (i2 % 30 == 0) {
                result2.append("\n    ");
            }
            result2.append(v.substring(i2, i2 + 2));
            sep = ":";
        }
        result2.append("\n");
    }
}

