/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.Pointer;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.WeakReferenceReaper;

@JRubyClass(name={"FFI::AutoPointer"}, parent="FFI::Pointer")
public final class AutoPointer
extends Pointer {
    static final String AUTOPTR_CLASS_NAME = "AutoPointer";
    private static final ConcurrentMap<ReaperGroup, Boolean> referenceSet = new ConcurrentHashMap<ReaperGroup, Boolean>();
    private static final ThreadLocal<Reference<ReaperGroup>> currentReaper = new ThreadLocal();
    private Pointer pointer;
    private Object referent;
    private volatile transient Reaper reaper;

    public static RubyClass createAutoPointerClass(Ruby runtime, RubyModule module) {
        RubyClass result2 = module.defineClassUnder(AUTOPTR_CLASS_NAME, module.getClass("Pointer"), AutoPointerAllocator.INSTANCE);
        result2.defineAnnotatedMethods(AutoPointer.class);
        result2.defineAnnotatedConstants(AutoPointer.class);
        return result2;
    }

    private AutoPointer(Ruby runtime, RubyClass klazz) {
        super(runtime, klazz, runtime.getFFI().getNullMemoryIO());
    }

    private static final void checkPointer(Ruby runtime, IRubyObject ptr) {
        if (!(ptr instanceof Pointer)) {
            throw runtime.newTypeError(ptr, runtime.getFFI().pointerClass);
        }
        if (ptr instanceof MemoryPointer || ptr instanceof AutoPointer) {
            throw runtime.newTypeError("Cannot use AutoPointer with MemoryPointer or AutoPointer instances");
        }
    }

    @JRubyMethod(name={"from_native"}, meta=true)
    public static IRubyObject from_native(ThreadContext context, IRubyObject recv2, IRubyObject value2, IRubyObject ctx) {
        return ((RubyClass)recv2).newInstance(context, new IRubyObject[]{value2}, Block.NULL_BLOCK);
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject pointerArg) {
        Ruby runtime = context.getRuntime();
        AutoPointer.checkPointer(runtime, pointerArg);
        if (!this.getMetaClass().respondsTo("release")) {
            throw runtime.newRuntimeError("No release method defined");
        }
        this.setMemoryIO(((Pointer)pointerArg).getMemoryIO());
        this.pointer = (Pointer)pointerArg;
        this.setReaper(new Reaper(this.pointer, this.getMetaClass(), "release"));
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public final IRubyObject initialize(ThreadContext context, IRubyObject pointerArg, IRubyObject releaser) {
        AutoPointer.checkPointer(context.getRuntime(), pointerArg);
        this.setMemoryIO(((Pointer)pointerArg).getMemoryIO());
        this.pointer = (Pointer)pointerArg;
        this.setReaper(new Reaper(this.pointer, releaser, "call"));
        return this;
    }

    @JRubyMethod(name={"free"})
    public final IRubyObject free(ThreadContext context) {
        Reaper r = this.reaper;
        if (r == null || r.released) {
            throw context.getRuntime().newRuntimeError("pointer already freed");
        }
        r.release(context);
        this.reaper = null;
        this.referent = null;
        return context.getRuntime().getNil();
    }

    @JRubyMethod(name={"autorelease="})
    public final IRubyObject autorelease(ThreadContext context, IRubyObject autorelease2) {
        Reaper r = this.reaper;
        if (r == null || r.released) {
            throw context.getRuntime().newRuntimeError("pointer already freed");
        }
        r.autorelease(autorelease2.isTrue());
        return context.getRuntime().getNil();
    }

    private void setReaper(Reaper reaper) {
        Object referent;
        Reference<ReaperGroup> reaperGroupReference = currentReaper.get();
        ReaperGroup reaperGroup = reaperGroupReference != null ? reaperGroupReference.get() : null;
        Object object = referent = reaperGroup != null ? (Object)reaperGroup.get() : null;
        if (referent == null || !reaperGroup.canAccept()) {
            referent = new Object();
            reaperGroup = new ReaperGroup(referent);
            currentReaper.set(new SoftReference<ReaperGroup>(reaperGroup));
            referenceSet.put(reaperGroup, Boolean.TRUE);
        }
        this.referent = referent;
        this.reaper = reaper;
        reaperGroup.add(reaper);
    }

    private static final class Reaper {
        final Pointer pointer;
        final IRubyObject proc;
        final String methodName;
        volatile Reaper next;
        volatile boolean released;
        volatile boolean unmanaged;

        private Reaper(Pointer ptr, IRubyObject proc2, String methodName) {
            this.pointer = ptr;
            this.proc = proc2;
            this.methodName = methodName;
        }

        final Ruby getRuntime() {
            return this.proc.getRuntime();
        }

        void dispose(ThreadContext context) {
            this.proc.callMethod(context, this.methodName, this.pointer);
        }

        public final void release(ThreadContext context) {
            if (!this.released) {
                this.released = true;
                this.dispose(context);
            }
        }

        public final void autorelease(boolean autorelease2) {
            this.unmanaged = !autorelease2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ReaperGroup
    extends WeakReferenceReaper<Object>
    implements Runnable {
        private static int MAX_REAPERS_PER_GROUP = 100;
        private int reaperCount;
        private volatile Reaper head;

        ReaperGroup(Object referent) {
            super(referent);
        }

        boolean canAccept() {
            return this.reaperCount < MAX_REAPERS_PER_GROUP;
        }

        void add(Reaper r) {
            ++this.reaperCount;
            r.next = this.head;
            this.head = r;
        }

        @Override
        public void run() {
            referenceSet.remove(this);
            Ruby runtime = null;
            ThreadContext ctx = null;
            Reaper r = this.head;
            while (r != null) {
                if (!r.released && !r.unmanaged) {
                    if (r.getRuntime() != runtime) {
                        runtime = r.getRuntime();
                        ctx = runtime.getCurrentContext();
                    }
                    r.dispose(ctx);
                }
                r = r.next;
            }
        }
    }

    private static final class AutoPointerAllocator
    implements ObjectAllocator {
        static final ObjectAllocator INSTANCE = new AutoPointerAllocator();

        private AutoPointerAllocator() {
        }

        public IRubyObject allocate(Ruby runtime, RubyClass klazz) {
            return new AutoPointer(runtime, klazz);
        }
    }
}

