/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.compiler.ArgumentsCallback;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.InvocationCompiler;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.BaseBodyCompiler;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.CodegenUtils;

public class StandardInvocationCompiler
implements InvocationCompiler {
    protected BaseBodyCompiler methodCompiler;
    protected SkinnyMethodAdapter method;

    public StandardInvocationCompiler(BaseBodyCompiler methodCompiler, SkinnyMethodAdapter method2) {
        this.methodCompiler = methodCompiler;
        this.method = method2;
    }

    public SkinnyMethodAdapter getMethodAdapter() {
        return this.method;
    }

    public void setMethodAdapter(SkinnyMethodAdapter sma) {
        this.method = sma;
    }

    public void invokeAttrAssignMasgn(String name2, CompilerCallback receiverCallback, final ArgumentsCallback argsCallback, boolean selfCall) {
        final int temp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(temp);
        ArgumentsCallback newArgumentsCallback = new ArgumentsCallback(){

            public int getArity() {
                return argsCallback == null ? 1 : argsCallback.getArity() + 1;
            }

            public void call(BodyCompiler context) {
                if (argsCallback != null) {
                    argsCallback.call(context);
                }
                StandardInvocationCompiler.this.methodCompiler.getVariableCompiler().getTempLocal(temp);
            }
        };
        this.invokeAttrAssign(name2, receiverCallback, newArgumentsCallback, selfCall, true);
    }

    public void invokeAttrAssign(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, boolean isSelf, boolean expr) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, isSelf ? CallType.VARIABLE : CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
        argsCallback.call(this.methodCompiler);
        int tmp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        switch (argsCallback.getArity()) {
            case 1: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                if (!expr) break;
                this.method.dup();
                this.method.astore(tmp);
                break;
            }
            case 2: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                if (!expr) break;
                this.method.dup();
                this.method.astore(tmp);
                break;
            }
            case 3: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                if (!expr) break;
                this.method.dup();
                this.method.astore(tmp);
                break;
            }
            default: {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                if (!expr) break;
                this.method.dup();
                this.methodCompiler.invokeUtilityMethod("lastElement", CodegenUtils.sig(IRubyObject.class, IRubyObject[].class));
                this.method.astore(tmp);
            }
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", signature);
        this.method.pop();
        if (expr) {
            this.method.aload(tmp);
        }
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithOr(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifne(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithAnd(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        this.method.dup2();
        int argsLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(argsLocal);
        int receiverLocal = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.methodCompiler.getVariableCompiler().setTempLocal(receiverLocal);
        switch (args2.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            default: {
                this.method.invokevirtual(CodegenUtils.p(CallSite.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
            }
        }
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        Label done = new Label();
        this.method.ifeq(done);
        this.method.pop();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getVariableCompiler().getTempLocal(receiverLocal);
        this.methodCompiler.getVariableCompiler().getTempLocal(argsLocal);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                throw new NotCompilableException("Op Element Asgn with zero-arity args");
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoOneArg", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoTwoArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoThreeArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithOrPartTwoNArgs", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class));
            }
        }
        this.method.label(done);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void opElementAsgnWithMethod(CompilerCallback receiver2, ArgumentsCallback args2, CompilerCallback valueCallback, String operator) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiver2.call(this.methodCompiler);
        args2.call(this.methodCompiler);
        valueCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operator, CallType.NORMAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.FUNCTIONAL);
        switch (args2.getArity()) {
            case 0: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 1: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 2: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            case 3: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
                break;
            }
            default: {
                this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
            }
        }
    }

    public void invokeBinaryFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.method.ldc(fixnum);
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Long.TYPE));
        String callSiteMethod = "call";
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    public void invokeBinaryBooleanFixnumRHS(String name2, CompilerCallback receiverCallback, long fixnum) {
        this.invokeBinaryFixnumRHS(name2, receiverCallback, fixnum);
        this.methodCompiler.isTrue();
    }

    public void invokeBinaryFloatRHS(String name2, CompilerCallback receiverCallback, double flote) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, CallType.NORMAL);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        this.method.ldc(flote);
        String signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Double.TYPE));
        String callSiteMethod = "call";
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    public void invokeFixnumLong(String rubyName, int moduleGeneration, CompilerCallback receiverCallback, String methodName, long fixnum) {
        receiverCallback.call(this.methodCompiler);
        final int tmp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(tmp);
        Label slow = new Label();
        Label after = new Label();
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.aload(tmp);
            this.method.ldc(moduleGeneration);
            this.methodCompiler.invokeUtilityMethod("isGenerationEqual", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, Integer.TYPE));
            this.method.ifeq(slow);
        }
        this.method.aload(tmp);
        this.method.checkcast(CodegenUtils.p(RubyFixnum.class));
        this.methodCompiler.loadThreadContext();
        this.method.ldc(fixnum);
        this.method.invokevirtual(CodegenUtils.p(RubyFixnum.class), methodName, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Long.TYPE));
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.go_to(after);
            this.method.label(slow);
            this.invokeBinaryFixnumRHS(rubyName, new CompilerCallback(){

                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.method.aload(tmp);
                }
            }, fixnum);
            this.method.label(after);
        }
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void invokeFloatDouble(String rubyName, int moduleGeneration, CompilerCallback receiverCallback, String methodName, double flote) {
        receiverCallback.call(this.methodCompiler);
        final int tmp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(tmp);
        Label slow = new Label();
        Label after = new Label();
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.aload(tmp);
            this.method.ldc(moduleGeneration);
            this.methodCompiler.invokeUtilityMethod("isGenerationEqual", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, Integer.TYPE));
            this.method.ifeq(slow);
        }
        this.method.aload(tmp);
        this.method.checkcast(CodegenUtils.p(RubyFloat.class));
        this.methodCompiler.loadThreadContext();
        this.method.ldc(flote);
        this.method.invokevirtual(CodegenUtils.p(RubyFloat.class), methodName, CodegenUtils.sig(IRubyObject.class, ThreadContext.class, Double.TYPE));
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.go_to(after);
            this.method.label(slow);
            this.invokeBinaryFloatRHS(rubyName, new CompilerCallback(){

                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.method.aload(tmp);
                }
            }, flote);
            this.method.label(after);
        }
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
    }

    public void invokeRecursive(String name2, int moduleGeneration, ArgumentsCallback argsCallback, CompilerCallback closure, CallType callType, boolean iterator) {
        if (this.methodCompiler.getVariableCompiler().isHeap()) {
            this.invokeDynamic(name2, null, argsCallback, callType, closure, iterator);
        } else {
            Label slow = new Label();
            Label after = new Label();
            if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
                this.methodCompiler.loadSelf();
                this.method.ldc(moduleGeneration);
                this.methodCompiler.invokeUtilityMethod("isGenerationEqual", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, Integer.TYPE));
                this.method.ifeq(slow);
            }
            this.method.aload(0);
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.loadSelf();
            if (argsCallback != null) {
                argsCallback.call(this.methodCompiler);
            }
            this.method.aconst_null();
            this.method.invokestatic(this.methodCompiler.getScriptCompiler().getClassname(), this.methodCompiler.getNativeMethodName(), this.methodCompiler.getSignature());
            if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
                this.method.go_to(after);
                this.method.label(slow);
                this.invokeDynamic(name2, null, argsCallback, callType, closure, iterator);
                this.method.label(after);
            }
        }
    }

    public void invokeNative(String name2, DynamicMethod.NativeCall nativeCall, int moduleGeneration, CompilerCallback receiver2, final ArgumentsCallback args2, CompilerCallback closure, CallType callType, boolean iterator) {
        Class[] nativeSignature = nativeCall.getNativeSignature();
        int leadingArgs = 0;
        receiver2.call(this.methodCompiler);
        final int tmp = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(tmp);
        int[] _argTmp = null;
        if (args2 != null) {
            args2.call(this.methodCompiler);
            switch (args2.getArity()) {
                case 3: {
                    _argTmp = new int[3];
                    _argTmp[2] = this.methodCompiler.getVariableCompiler().grabTempLocal();
                    this.method.astore(_argTmp[2]);
                }
                case 2: {
                    if (_argTmp == null) {
                        _argTmp = new int[2];
                    }
                    _argTmp[1] = this.methodCompiler.getVariableCompiler().grabTempLocal();
                    this.method.astore(_argTmp[1]);
                }
            }
            if (_argTmp == null) {
                _argTmp = new int[]{this.methodCompiler.getVariableCompiler().grabTempLocal()};
            }
            this.method.astore(_argTmp[0]);
            leadingArgs += args2.getArity();
        }
        final int[] argTmp = _argTmp;
        Label slow = new Label();
        Label after = new Label();
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.aload(tmp);
            this.method.ldc(moduleGeneration);
            this.methodCompiler.invokeUtilityMethod("isGenerationEqual", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, Integer.TYPE));
            this.method.ifeq(slow);
        }
        if (nativeCall.isStatic()) {
            if (nativeSignature.length > 0 && nativeSignature[0] == ThreadContext.class) {
                this.methodCompiler.loadThreadContext();
                ++leadingArgs;
            }
            this.method.aload(tmp);
            ++leadingArgs;
        } else {
            this.method.aload(tmp);
            this.method.checkcast(CodegenUtils.p(nativeCall.getNativeTarget()));
            if (nativeSignature.length > 0 && nativeSignature[0] == ThreadContext.class) {
                this.methodCompiler.loadThreadContext();
                ++leadingArgs;
            }
        }
        if (args2 != null) {
            switch (args2.getArity()) {
                default: {
                    this.method.aload(argTmp[0]);
                    break;
                }
                case 2: {
                    this.method.aload(argTmp[0]);
                    this.method.aload(argTmp[1]);
                    break;
                }
                case 3: {
                    this.method.aload(argTmp[0]);
                    this.method.aload(argTmp[1]);
                    this.method.aload(argTmp[2]);
                }
            }
        }
        if (closure != null) {
            closure.call(this.methodCompiler);
            if (nativeSignature.length != leadingArgs + 1 || nativeSignature[leadingArgs] != Block.class) {
                this.method.pop();
            }
        } else if (nativeSignature.length == leadingArgs + 1 && nativeSignature[leadingArgs] == Block.class) {
            this.method.getstatic(CodegenUtils.p(Block.class), "NULL_BLOCK", CodegenUtils.ci(Block.class));
        }
        if (nativeCall.isStatic()) {
            this.method.invokestatic(CodegenUtils.p(nativeCall.getNativeTarget()), nativeCall.getNativeName(), CodegenUtils.sig(nativeCall.getNativeReturn(), nativeSignature));
        } else {
            this.method.invokevirtual(CodegenUtils.p(nativeCall.getNativeTarget()), nativeCall.getNativeName(), CodegenUtils.sig(nativeCall.getNativeReturn(), nativeSignature));
        }
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.go_to(after);
            this.method.label(slow);
            ArgumentsCallback newArgs = null;
            if (args2 != null) {
                newArgs = new ArgumentsCallback(){

                    public int getArity() {
                        return args2.getArity();
                    }

                    public void call(BodyCompiler context) {
                        switch (args2.getArity()) {
                            default: {
                                StandardInvocationCompiler.this.method.aload(argTmp[0]);
                                break;
                            }
                            case 2: {
                                StandardInvocationCompiler.this.method.aload(argTmp[0]);
                                StandardInvocationCompiler.this.method.aload(argTmp[1]);
                                break;
                            }
                            case 3: {
                                StandardInvocationCompiler.this.method.aload(argTmp[0]);
                                StandardInvocationCompiler.this.method.aload(argTmp[1]);
                                StandardInvocationCompiler.this.method.aload(argTmp[2]);
                            }
                        }
                    }
                };
            }
            this.invokeDynamic(name2, new CompilerCallback(){

                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.method.aload(tmp);
                }
            }, newArgs, callType, closure, iterator);
            this.method.label(after);
        }
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        if (argTmp != null) {
            for (int i2 : argTmp) {
                this.methodCompiler.getVariableCompiler().releaseTempLocal();
            }
        }
    }

    public void invokeTrivial(String name2, int moduleGeneration, CompilerCallback body) {
        Label slow = new Label();
        Label after = new Label();
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.methodCompiler.loadSelf();
            this.method.ldc(moduleGeneration);
            this.methodCompiler.invokeUtilityMethod("isGenerationEqual", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, Integer.TYPE));
            this.method.iffalse(slow);
        }
        body.call(this.methodCompiler);
        if (!RubyInstanceConfig.NOGUARDS_COMPILE_ENABLED) {
            this.method.go_to(after);
            this.method.label(slow);
            this.invokeDynamic(name2, null, null, CallType.FUNCTIONAL, null, false);
            this.method.label(after);
        }
    }

    public void invokeDynamic(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        if (RubyInstanceConfig.INLINE_DYNCALL_ENABLED && closureArg == null && (callType == CallType.FUNCTIONAL || callType == CallType.VARIABLE)) {
            if (argsCallback == null) {
                this.invokeDynamicSelfNoBlockZero(name2);
                return;
            }
            if (argsCallback.getArity() >= 1 && argsCallback.getArity() <= 3) {
                this.invokeDynamicSelfNoBlockSpecificArity(name2, argsCallback);
                return;
            }
        }
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, callType);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        if (callType == CallType.SUPER && closureArg == null) {
            closureArg = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.methodCompiler.loadBlock();
                }
            };
        }
        String callSiteMethod = "call";
        if (argsCallback == null) {
            if (closureArg == null) {
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class));
            } else {
                if (iterator) {
                    callSiteMethod = "callIter";
                }
                closureArg.call(this.methodCompiler);
                signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class));
            }
        } else {
            argsCallback.call(this.methodCompiler);
            if (closureArg == null) {
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                        break;
                    }
                }
            } else {
                if (iterator) {
                    callSiteMethod = "callIter";
                }
                closureArg.call(this.methodCompiler);
                switch (argsCallback.getArity()) {
                    case 1: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 2: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    case 3: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class));
                        break;
                    }
                    default: {
                        signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
                    }
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    public void invokeDynamicVarargs(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback, CallType callType, CompilerCallback closureArg, boolean iterator) {
        String signature;
        assert (argsCallback.getArity() == -1);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, name2, callType);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        if (receiverCallback != null) {
            receiverCallback.call(this.methodCompiler);
        } else {
            this.methodCompiler.loadSelf();
        }
        if (callType == CallType.SUPER && closureArg == null) {
            closureArg = new CompilerCallback(){

                public void call(BodyCompiler context) {
                    StandardInvocationCompiler.this.methodCompiler.loadBlock();
                }
            };
        }
        String callSiteMethod = "callVarargs";
        argsCallback.call(this.methodCompiler);
        if (closureArg == null) {
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
        } else {
            if (iterator) {
                callSiteMethod = "callVarargsIter";
            }
            closureArg.call(this.methodCompiler);
            signature = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class, Block.class));
        }
        this.method.invokevirtual(CodegenUtils.p(CallSite.class), callSiteMethod, signature);
    }

    public void invokeDynamicSelfNoBlockZero(String name2) {
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    }

    public void invokeDynamicSelfNoBlockSpecificArity(String name2, ArgumentsCallback argsCallback) {
        String signature2;
        String signature1;
        this.methodCompiler.loadThis();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        argsCallback.call(this.methodCompiler);
        String thisClass = this.methodCompiler.getScriptCompiler().getClassname();
        switch (argsCallback.getArity()) {
            case 1: {
                signature1 = CodegenUtils.sig(IRubyObject.class, "L" + thisClass + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class);
                break;
            }
            case 2: {
                signature1 = CodegenUtils.sig(IRubyObject.class, "L" + thisClass + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                break;
            }
            case 3: {
                signature1 = CodegenUtils.sig(IRubyObject.class, "L" + thisClass + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                break;
            }
            default: {
                throw new RuntimeException("invalid arity for inline dyncall: " + argsCallback.getArity());
            }
        }
        String synthMethodName = this.methodCompiler.getNativeMethodName() + "$call" + this.methodCompiler.getScriptCompiler().getAndIncrementMethodIndex();
        SkinnyMethodAdapter m2 = new SkinnyMethodAdapter(this.methodCompiler.getScriptCompiler().getClassVisitor(), 4106, synthMethodName, signature1, null, null);
        this.method.invokestatic(thisClass, synthMethodName, signature1);
        SkinnyMethodAdapter oldMethod = this.methodCompiler.method;
        this.methodCompiler.method = m2;
        m2.start();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2);
        m2.aload(1);
        m2.aload(2);
        m2.aload(2);
        m2.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        m2.ldc(name2);
        switch (argsCallback.getArity()) {
            case 1: {
                signature2 = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class);
                m2.aload(3);
                break;
            }
            case 2: {
                signature2 = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class);
                m2.aload(3);
                m2.aload(4);
                break;
            }
            case 3: {
                signature2 = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                m2.aload(3);
                m2.aload(4);
                m2.aload(5);
                break;
            }
            default: {
                throw new RuntimeException("invalid arity for inline dyncall: " + argsCallback.getArity());
            }
        }
        m2.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", signature2);
        m2.areturn();
        m2.end();
        this.methodCompiler.method = oldMethod;
    }

    public void invokeDynamicNoBlockZero(String name2, CompilerCallback receiverCallback) {
        receiverCallback.call(this.methodCompiler);
        int recv2 = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(recv2);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2, recv2);
        this.methodCompiler.loadThreadContext();
        this.method.aload(recv2);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class));
    }

    public void invokeDynamicNoBlockSpecificArity(String name2, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        int recv2 = this.methodCompiler.getVariableCompiler().grabTempLocal();
        this.method.astore(recv2);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheMethod(this.methodCompiler, name2, recv2);
        this.methodCompiler.loadThreadContext();
        this.method.aload(recv2);
        this.methodCompiler.getVariableCompiler().releaseTempLocal();
        this.method.dup();
        this.method.invokeinterface(CodegenUtils.p(IRubyObject.class), "getMetaClass", CodegenUtils.sig(RubyClass.class, new Class[0]));
        this.method.ldc(name2);
        argsCallback.call(this.methodCompiler);
        switch (argsCallback.getArity()) {
            case 1: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class));
                break;
            }
            case 2: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class));
                break;
            }
            case 3: {
                this.method.invokevirtual(CodegenUtils.p(DynamicMethod.class), "call", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, RubyModule.class, String.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
            }
        }
    }

    public void invokeOpAsgnWithOr(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        Label done = new Label();
        Label isTrue = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifne(isTrue);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isTrue);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithAnd(String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        receiverCallback.call(this.methodCompiler);
        this.method.dup();
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.invokeUtilityMethod("preOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        Label done = new Label();
        Label isFalse = new Label();
        this.method.dup();
        this.methodCompiler.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE, new Class[0]));
        this.method.ifeq(isFalse);
        this.method.pop();
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("postOpAsgnWithOrAnd", CodegenUtils.sig(IRubyObject.class, IRubyObject.class, IRubyObject.class, ThreadContext.class, IRubyObject.class, CallSite.class));
        this.method.go_to(done);
        this.method.label(isFalse);
        this.method.swap();
        this.method.pop();
        this.method.label(done);
    }

    public void invokeOpAsgnWithMethod(String operatorName, String attrName, String attrAsgnName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, attrAsgnName, CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void invokeOpElementAsgnWithMethod(String operatorName, CompilerCallback receiverCallback, ArgumentsCallback argsCallback) {
        this.methodCompiler.loadThreadContext();
        this.methodCompiler.loadSelf();
        receiverCallback.call(this.methodCompiler);
        argsCallback.call(this.methodCompiler);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]", CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, operatorName, CallType.FUNCTIONAL);
        this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "[]=", CallType.NORMAL);
        this.methodCompiler.invokeUtilityMethod("opElementAsgnWithMethod", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, CallSite.class, CallSite.class, CallSite.class));
    }

    public void yield(CompilerCallback argsCallback, boolean unwrap) {
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        } else {
            this.method.aconst_null();
        }
        if (unwrap) {
            this.method.aconst_null();
            this.method.aconst_null();
            this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldArray", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class));
        } else {
            this.method.invokevirtual(CodegenUtils.p(Block.class), "yield", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class));
        }
    }

    public void yield19(CompilerCallback argsCallback, boolean unsplat) {
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback != null) {
            argsCallback.call(this.methodCompiler);
        } else {
            this.method.aconst_null();
        }
        if (unsplat) {
            this.methodCompiler.invokeUtilityMethod("unsplatValue19", CodegenUtils.sig(IRubyObject.class, IRubyObject.class));
        }
        this.method.aconst_null();
        this.method.aconst_null();
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldArray", CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class));
    }

    public void yieldSpecific(ArgumentsCallback argsCallback) {
        String signature;
        this.methodCompiler.loadBlock();
        this.methodCompiler.loadThreadContext();
        if (argsCallback == null) {
            signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class);
        } else {
            argsCallback.call(this.methodCompiler);
            switch (argsCallback.getArity()) {
                case 1: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class);
                    break;
                }
                case 2: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                case 3: {
                    signature = CodegenUtils.sig(IRubyObject.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class);
                    break;
                }
                default: {
                    throw new NotCompilableException("Can't do specific-arity call for > 3 args yet");
                }
            }
        }
        this.method.invokevirtual(CodegenUtils.p(Block.class), "yieldSpecific", signature);
    }

    public void invokeEqq(ArgumentsCallback receivers, CompilerCallback argument) {
        if (argument == null) {
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaselessWhen", CodegenUtils.sig(Boolean.TYPE, IRubyObject[].class));
                    break;
                }
            }
        } else {
            this.methodCompiler.getScriptCompiler().getCacheCompiler().cacheCallSite(this.methodCompiler, "===", CallType.NORMAL);
            this.methodCompiler.loadThreadContext();
            this.methodCompiler.loadSelf();
            argument.call(this.methodCompiler);
            receivers.call(this.methodCompiler);
            switch (receivers.getArity()) {
                case 1: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 2: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                case 3: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class));
                    break;
                }
                default: {
                    this.methodCompiler.invokeUtilityMethod("invokeEqqForCaseWhen", CodegenUtils.sig(Boolean.TYPE, CallSite.class, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject[].class));
                }
            }
        }
    }
}

