/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Map;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArgsFile;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.common.IRubyWarnings;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.platform.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.Constants;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.ReadonlyGlobalVariable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.OSEnvironment;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.OutputStrings;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.STDIO;

public class RubyGlobal {
    public static void createGlobals(ThreadContext context, Ruby runtime) {
        String[] argv;
        GlobalVariables globals = runtime.getGlobalVariables();
        runtime.defineGlobalConstant("TOPLEVEL_BINDING", runtime.newBinding());
        runtime.defineGlobalConstant("TRUE", runtime.getTrue());
        runtime.defineGlobalConstant("FALSE", runtime.getFalse());
        runtime.defineGlobalConstant("NIL", runtime.getNil());
        RubyArray argvArray = runtime.newArray();
        for (String arg2 : argv = runtime.getInstanceConfig().getArgv()) {
            argvArray.append(RubyString.newInternalFromJavaExternal(runtime, arg2));
        }
        runtime.defineGlobalConstant("ARGV", argvArray);
        globals.define("$*", new ValueAccessor(argvArray));
        ValueAccessor d = new ValueAccessor(runtime.newString(runtime.getInstanceConfig().displayedFileName()));
        globals.define("$PROGRAM_NAME", d);
        globals.define("$0", d);
        IRubyObject version2 = null;
        RubyFixnum patchlevel = null;
        IRubyObject release = runtime.newString("2012-05-19").freeze(context);
        IRubyObject platform = runtime.newString("java").freeze(context);
        IRubyObject engine = runtime.newString("jruby").freeze(context);
        switch (runtime.getInstanceConfig().getCompatVersion()) {
            case RUBY1_8: {
                version2 = runtime.newString("1.8.7").freeze(context);
                patchlevel = runtime.newFixnum(Constants.RUBY_PATCHLEVEL);
                break;
            }
            case RUBY1_9: {
                version2 = runtime.newString("1.9.3").freeze(context);
                patchlevel = runtime.newFixnum(Constants.RUBY1_9_PATCHLEVEL);
                break;
            }
            case RUBY2_0: {
                version2 = runtime.newString("2.0.0dev").freeze(context);
                patchlevel = runtime.newFixnum(Constants.RUBY2_0_PATCHLEVEL);
            }
        }
        runtime.defineGlobalConstant("RUBY_VERSION", version2);
        runtime.defineGlobalConstant("RUBY_PATCHLEVEL", patchlevel);
        runtime.defineGlobalConstant("RUBY_RELEASE_DATE", release);
        runtime.defineGlobalConstant("RUBY_PLATFORM", platform);
        runtime.defineGlobalConstant("RUBY_ENGINE", engine);
        IRubyObject description = runtime.newString(OutputStrings.getVersionString(runtime.getInstanceConfig().getCompatVersion())).freeze(context);
        runtime.defineGlobalConstant("RUBY_DESCRIPTION", description);
        IRubyObject copyright = runtime.newString(OutputStrings.getCopyrightString()).freeze(context);
        runtime.defineGlobalConstant("RUBY_COPYRIGHT", copyright);
        runtime.defineGlobalConstant("VERSION", version2);
        runtime.defineGlobalConstant("RELEASE_DATE", release);
        runtime.defineGlobalConstant("PLATFORM", platform);
        IRubyObject jrubyVersion = runtime.newString("1.7.0.preview1").freeze(context);
        IRubyObject jrubyRevision = runtime.newString(Constants.REVISION).freeze(context);
        runtime.defineGlobalConstant("JRUBY_VERSION", jrubyVersion);
        runtime.defineGlobalConstant("JRUBY_REVISION", jrubyRevision);
        if (runtime.is1_9()) {
            runtime.defineGlobalConstant("RUBY_REVISION", runtime.newFixnum(Constants.RUBY1_9_REVISION));
            RubyInstanceConfig.Verbosity verbosity = runtime.getInstanceConfig().getVerbosity();
            runtime.defineVariable(new WarningGlobalVariable(runtime, "$-W", verbosity));
        }
        GlobalVariable kcodeGV = runtime.is1_9() ? new NonEffectiveGlobalVariable(runtime, "$KCODE", runtime.getNil()) : new KCodeGlobalVariable(runtime, "$KCODE", runtime.newString("NONE"));
        runtime.defineVariable(kcodeGV);
        runtime.defineVariable(new GlobalVariable.Copy(runtime, "$-K", kcodeGV));
        IRubyObject defaultRS = runtime.newString(runtime.getInstanceConfig().getRecordSeparator()).freeze(context);
        StringGlobalVariable rs = new StringGlobalVariable(runtime, "$/", defaultRS);
        runtime.defineVariable(rs);
        runtime.setRecordSeparatorVar(rs);
        globals.setDefaultSeparator(defaultRS);
        runtime.defineVariable(new StringGlobalVariable(runtime, "$\\", runtime.getNil()));
        runtime.defineVariable(new StringGlobalVariable(runtime, "$,", runtime.getNil()));
        runtime.defineVariable(new LineNumberGlobalVariable(runtime, "$."));
        runtime.defineVariable(new LastlineGlobalVariable(runtime, "$_"));
        runtime.defineVariable(new LastExitStatusVariable(runtime, "$?"));
        runtime.defineVariable(new ErrorInfoGlobalVariable(runtime, "$!", runtime.getNil()));
        runtime.defineVariable(new NonEffectiveGlobalVariable(runtime, "$=", runtime.getFalse()));
        if (runtime.getInstanceConfig().getInputFieldSeparator() == null) {
            runtime.defineVariable(new GlobalVariable(runtime, "$;", runtime.getNil()));
        } else {
            runtime.defineVariable(new GlobalVariable(runtime, "$;", RubyRegexp.newRegexp(runtime, runtime.getInstanceConfig().getInputFieldSeparator(), new RegexpOptions())));
        }
        RubyInstanceConfig.Verbosity verbose = runtime.getInstanceConfig().getVerbosity();
        IRubyObject verboseValue = null;
        verboseValue = verbose == RubyInstanceConfig.Verbosity.NIL ? runtime.getNil() : (verbose == RubyInstanceConfig.Verbosity.TRUE ? runtime.getTrue() : runtime.getFalse());
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$VERBOSE", verboseValue));
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$-v", verboseValue));
        runtime.defineVariable(new VerboseGlobalVariable(runtime, "$-w", verboseValue));
        RubyBoolean debug = runtime.newBoolean(runtime.getInstanceConfig().isDebug());
        runtime.defineVariable(new DebugGlobalVariable(runtime, "$DEBUG", debug));
        runtime.defineVariable(new DebugGlobalVariable(runtime, "$-d", debug));
        runtime.defineVariable(new SafeGlobalVariable(runtime, "$SAFE"));
        runtime.defineVariable(new BacktraceGlobalVariable(runtime, "$@"));
        RubyIO stdin = new RubyIO(runtime, STDIO.IN);
        RubyIO stdout = new RubyIO(runtime, STDIO.OUT);
        RubyIO stderr = new RubyIO(runtime, STDIO.ERR);
        runtime.defineVariable(new InputGlobalVariable(runtime, "$stdin", stdin));
        runtime.defineVariable(new OutputGlobalVariable(runtime, "$stdout", stdout));
        globals.alias("$>", "$stdout");
        if (!runtime.is1_9()) {
            globals.alias("$defout", "$stdout");
        }
        runtime.defineVariable(new OutputGlobalVariable(runtime, "$stderr", stderr));
        if (!runtime.is1_9()) {
            globals.alias("$deferr", "$stderr");
        }
        runtime.defineGlobalConstant("STDIN", stdin);
        runtime.defineGlobalConstant("STDOUT", stdout);
        runtime.defineGlobalConstant("STDERR", stderr);
        runtime.defineVariable(new LoadedFeatures(runtime, "$\""));
        runtime.defineVariable(new LoadedFeatures(runtime, "$LOADED_FEATURES"));
        runtime.defineVariable(new LoadPath(runtime, "$:"));
        runtime.defineVariable(new LoadPath(runtime, "$-I"));
        runtime.defineVariable(new LoadPath(runtime, "$LOAD_PATH"));
        runtime.defineVariable(new MatchMatchGlobalVariable(runtime, "$&"));
        runtime.defineVariable(new PreMatchGlobalVariable(runtime, "$`"));
        runtime.defineVariable(new PostMatchGlobalVariable(runtime, "$'"));
        runtime.defineVariable(new LastMatchGlobalVariable(runtime, "$+"));
        runtime.defineVariable(new BackRefGlobalVariable(runtime, "$~"));
        globals.defineReadonly("$$", new PidAccessor(runtime));
        RubyGlobal.defineGlobalEnvConstants(runtime);
        if (globals.get("$*").isNil()) {
            globals.defineReadonly("$*", new ValueAccessor(runtime.newArray()));
        }
        globals.defineReadonly("$-p", new ValueAccessor(runtime.newBoolean(runtime.getInstanceConfig().isAssumePrinting())));
        globals.defineReadonly("$-a", new ValueAccessor(runtime.newBoolean(runtime.getInstanceConfig().isSplit())));
        globals.defineReadonly("$-l", new ValueAccessor(runtime.newBoolean(runtime.getInstanceConfig().isProcessLineEnds())));
        RubyArgsFile.initArgsFile(runtime);
        globals.alias("$ERROR_INFO", "$!");
        globals.alias("$ERROR_POSITION", "$@");
        globals.alias("$FS", "$;");
        globals.alias("$FIELD_SEPARATOR", "$;");
        globals.alias("$OFS", "$,");
        globals.alias("$OUTPUT_FIELD_SEPARATOR", "$,");
        globals.alias("$RS", "$/");
        globals.alias("$INPUT_RECORD_SEPARATOR", "$/");
        globals.alias("$ORS", "$\\");
        globals.alias("$OUTPUT_RECORD_SEPARATOR", "$\\");
        globals.alias("$NR", "$.");
        globals.alias("$INPUT_LINE_NUMBER", "$.");
        globals.alias("$LAST_READ_LINE", "$_");
        globals.alias("$DEFAULT_OUTPUT", "$>");
        globals.alias("$DEFAULT_INPUT", "$<");
        globals.alias("$PID", "$$");
        globals.alias("$PROCESS_ID", "$$");
        globals.alias("$CHILD_STATUS", "$?");
        globals.alias("$LAST_MATCH_INFO", "$~");
        globals.alias("$IGNORECASE", "$=");
        globals.alias("$ARGV", "$*");
        globals.alias("$MATCH", "$&");
        globals.alias("$PREMATCH", "$`");
        globals.alias("$POSTMATCH", "$'");
        globals.alias("$LAST_PAREN_MATCH", "$+");
    }

    private static void defineGlobalEnvConstants(Ruby runtime) {
        HashMap environmentVariableMap = null;
        OSEnvironment environment = new OSEnvironment();
        environmentVariableMap = environment.getEnvironmentVariableMap(runtime);
        if (environmentVariableMap == null) {
            environmentVariableMap = new HashMap();
        }
        CaseInsensitiveStringOnlyRubyHash env = new CaseInsensitiveStringOnlyRubyHash(runtime, environmentVariableMap, runtime.getNil(), runtime.getInstanceConfig().isNativeEnabled() && runtime.getInstanceConfig().isUpdateNativeENVEnabled());
        env.getSingletonClass().defineAnnotatedMethods(CaseInsensitiveStringOnlyRubyHash.class);
        runtime.defineGlobalConstant("ENV", env);
        runtime.setENV(env);
        Map systemProps = environment.getSystemPropertiesMap(runtime);
        ReadOnlySystemPropertiesHash systemPropsHash = new ReadOnlySystemPropertiesHash(runtime, systemProps, runtime.getNil());
        systemPropsHash.setFrozen(true);
        runtime.defineGlobalConstant("ENV_JAVA", systemPropsHash);
    }

    private static final class PidAccessor
    implements IAccessor {
        private final Ruby runtime;
        private volatile IRubyObject pid = null;

        public PidAccessor(Ruby runtime) {
            this.runtime = runtime;
        }

        public IRubyObject getValue() {
            return this.pid != null ? this.pid : (this.pid = this.runtime.newFixnum(this.runtime.getPosix().getpid()));
        }

        public IRubyObject setValue(IRubyObject newValue) {
            throw this.runtime.newRuntimeError("cannot assign to $$");
        }
    }

    private static class LoadedFeatures
    extends ReadonlyGlobalVariable {
        public LoadedFeatures(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadedFeatures();
        }
    }

    private static class LoadPath
    extends ReadonlyGlobalVariable {
        public LoadPath(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        public IRubyObject get() {
            return this.runtime.getLoadService().getLoadPath();
        }
    }

    public static class OutputGlobalVariable
    extends GlobalVariable {
        public OutputGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            if (value2 instanceof RubyIO) {
                RubyIO io2 = (RubyIO)value2;
                try {
                    io2.getOpenFile().getWriteStreamSafe().setSync(true);
                }
                catch (BadDescriptorException e) {
                    throw this.runtime.newErrnoEBADFError();
                }
            }
            if (!value2.respondsTo("write")) {
                throw this.runtime.newTypeError(this.name() + " must have write method, " + value2.getType().getName() + " given");
            }
            return super.set(value2);
        }
    }

    public static class InputGlobalVariable
    extends GlobalVariable {
        public InputGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (value2 == this.get()) {
                return value2;
            }
            return super.set(value2);
        }
    }

    private static class LastlineGlobalVariable
    extends GlobalVariable {
        public LastlineGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        public IRubyObject get() {
            return RuntimeHelpers.getLastLine(this.runtime, this.runtime.getCurrentContext());
        }

        public IRubyObject set(IRubyObject value2) {
            RuntimeHelpers.setLastLine(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class BacktraceGlobalVariable
    extends GlobalVariable {
        public BacktraceGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        public IRubyObject get() {
            IRubyObject backtrace2;
            IRubyObject errorInfo = this.runtime.getGlobalVariables().get("$!");
            IRubyObject iRubyObject = backtrace2 = errorInfo.isNil() ? this.runtime.getNil() : errorInfo.callMethod(errorInfo.getRuntime().getCurrentContext(), "backtrace");
            if (!(backtrace2 instanceof RubyArray)) {
                backtrace2 = this.runtime.getNil();
            }
            return backtrace2;
        }

        public IRubyObject set(IRubyObject value2) {
            if (this.runtime.getGlobalVariables().get("$!").isNil()) {
                throw this.runtime.newArgumentError("$! not set.");
            }
            this.runtime.getGlobalVariables().get("$!").callMethod(value2.getRuntime().getCurrentContext(), "set_backtrace", value2);
            return value2;
        }
    }

    private static class DebugGlobalVariable
    extends GlobalVariable {
        public DebugGlobalVariable(Ruby runtime, String name2, IRubyObject initialValue) {
            super(runtime, name2, initialValue);
            this.set(initialValue);
        }

        public IRubyObject get() {
            return this.runtime.getDebug();
        }

        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setDebug(newValue);
            } else {
                this.runtime.setDebug(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class WarningGlobalVariable
    extends ReadonlyGlobalVariable {
        public WarningGlobalVariable(Ruby runtime, String name2, RubyInstanceConfig.Verbosity verbosity) {
            super(runtime, name2, verbosity == RubyInstanceConfig.Verbosity.NIL ? RubyFixnum.newFixnum(runtime, 0L) : (verbosity == RubyInstanceConfig.Verbosity.FALSE ? RubyFixnum.newFixnum(runtime, 1L) : (verbosity == RubyInstanceConfig.Verbosity.TRUE ? RubyFixnum.newFixnum(runtime, 2L) : runtime.getNil())));
        }
    }

    private static class VerboseGlobalVariable
    extends GlobalVariable {
        public VerboseGlobalVariable(Ruby runtime, String name2, IRubyObject initialValue) {
            super(runtime, name2, initialValue);
            this.set(initialValue);
        }

        public IRubyObject get() {
            return this.runtime.getVerbose();
        }

        public IRubyObject set(IRubyObject newValue) {
            if (newValue.isNil()) {
                this.runtime.setVerbose(newValue);
            } else {
                this.runtime.setVerbose(this.runtime.newBoolean(newValue.isTrue()));
            }
            return newValue;
        }
    }

    private static class SafeGlobalVariable
    extends GlobalVariable {
        public SafeGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getSafeLevel());
        }

        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.SAFE_NOT_SUPPORTED, "SAFE levels are not supported in JRuby");
            return RubyFixnum.newFixnum(this.runtime, this.runtime.getSafeLevel());
        }
    }

    public static class KCodeGlobalVariable
    extends GlobalVariable {
        public KCodeGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        public IRubyObject get() {
            return this.runtime.getKCode().kcode(this.runtime);
        }

        public IRubyObject set(IRubyObject value2) {
            this.runtime.setKCode(KCode.create(this.runtime, value2.convertToString().toString()));
            return value2;
        }
    }

    public static class StringGlobalVariable
    extends GlobalVariable {
        public StringGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (!value2.isNil() && !(value2 instanceof RubyString)) {
                throw this.runtime.newTypeError("value of " + this.name() + " must be a String");
            }
            return super.set(value2);
        }
    }

    private static class ErrorInfoGlobalVariable
    extends GlobalVariable {
        public ErrorInfoGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, null);
            this.set(value2);
        }

        public IRubyObject set(IRubyObject value2) {
            if (!(value2.isNil() || this.runtime.getException().isInstance(value2) || JavaUtil.isJavaObject(value2) && JavaUtil.unwrapJavaObject(value2) instanceof Throwable)) {
                throw this.runtime.newTypeError("assigning non-exception to $!");
            }
            return this.runtime.getCurrentContext().setErrorInfo(value2);
        }

        public IRubyObject get() {
            return this.runtime.getCurrentContext().getErrorInfo();
        }
    }

    private static class LineNumberGlobalVariable
    extends GlobalVariable {
        public LineNumberGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, null);
        }

        public IRubyObject set(IRubyObject value2) {
            int line = (int)value2.convertToInteger().getLongValue();
            this.runtime.setCurrentLine(line);
            RubyArgsFile.setCurrentLineNumber(this.runtime.getArgsFile(), line);
            return value2;
        }

        public IRubyObject get() {
            return this.runtime.newFixnum(this.runtime.getCurrentLine());
        }
    }

    private static class BackRefGlobalVariable
    extends GlobalVariable {
        public BackRefGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        public IRubyObject get() {
            return RuntimeHelpers.getBackref(this.runtime, this.runtime.getCurrentContext());
        }

        public IRubyObject set(IRubyObject value2) {
            RuntimeHelpers.setBackref(this.runtime, this.runtime.getCurrentContext(), value2);
            return value2;
        }
    }

    private static class LastMatchGlobalVariable
    extends GlobalVariable {
        public LastMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_last(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class PostMatchGlobalVariable
    extends GlobalVariable {
        public PostMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_post(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class PreMatchGlobalVariable
    extends GlobalVariable {
        public PreMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.match_pre(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class MatchMatchGlobalVariable
    extends GlobalVariable {
        public MatchMatchGlobalVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        public IRubyObject get() {
            return RubyRegexp.last_match(this.runtime.getCurrentContext().getCurrentScope().getBackRef(this.runtime));
        }
    }

    private static class LastExitStatusVariable
    extends GlobalVariable {
        public LastExitStatusVariable(Ruby runtime, String name2) {
            super(runtime, name2, runtime.getNil());
        }

        public IRubyObject get() {
            IRubyObject lastExitStatus = this.runtime.getCurrentContext().getLastExitStatus();
            return lastExitStatus == null ? this.runtime.getNil() : lastExitStatus;
        }

        public IRubyObject set(IRubyObject lastExitStatus) {
            throw this.runtime.newNameError("$? is a read-only variable", "$?");
        }
    }

    private static class NonEffectiveGlobalVariable
    extends GlobalVariable {
        public NonEffectiveGlobalVariable(Ruby runtime, String name2, IRubyObject value2) {
            super(runtime, name2, value2);
        }

        public IRubyObject set(IRubyObject value2) {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective; ignored");
            return value2;
        }

        public IRubyObject get() {
            this.runtime.getWarnings().warn(IRubyWarnings.ID.INEFFECTIVE_GLOBAL, "warning: variable " + this.name + " is no longer effective");
            return this.value;
        }
    }

    private static class ReadOnlySystemPropertiesHash
    extends StringOnlyRubyHash {
        public ReadOnlySystemPropertiesHash(Ruby runtime, Map valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime, valueMap, defaultValue, updateRealENV);
        }

        public ReadOnlySystemPropertiesHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
            this(runtime, valueMap, defaultValue, false);
        }

        public void modify() {
            if (this.isFrozen()) {
                throw this.getRuntime().newTypeError("ENV_JAVA is not writable until you require 'java'");
            }
        }
    }

    public static class StringOnlyRubyHash
    extends RubyHash {
        private boolean updateRealENV;

        public StringOnlyRubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime, valueMap, defaultValue);
            this.updateRealENV = updateRealENV;
        }

        public StringOnlyRubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue) {
            this(runtime, valueMap, defaultValue, false);
        }

        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            return this.case_aware_op_aref(context, key2, true);
        }

        public RubyHash to_hash() {
            Ruby runtime = this.getRuntime();
            RubyHash hash2 = RubyHash.newHash(runtime);
            hash2.replace(runtime.getCurrentContext(), this);
            return hash2;
        }

        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2, true);
        }

        public IRubyObject op_aset19(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.op_aset(context, key2, value2);
        }

        protected IRubyObject case_aware_op_aref(ThreadContext context, IRubyObject key2, boolean caseSensitive) {
            if (!caseSensitive) {
                key2 = this.getCorrectKey(key2, context);
            }
            return super.op_aref(context, key2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IRubyObject case_aware_op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2, boolean caseSensitive) {
            IRubyObject valueAsStr;
            if (!key2.respondsTo("to_str")) {
                throw this.getRuntime().newTypeError("can't convert " + key2.getMetaClass() + " into String");
            }
            if (!value2.respondsTo("to_str") && !value2.isNil()) {
                throw this.getRuntime().newTypeError("can't convert " + value2.getMetaClass() + " into String");
            }
            if (!caseSensitive) {
                key2 = this.getCorrectKey(key2, context);
            }
            if (value2.isNil()) {
                return super.delete(context, key2, Block.NULL_BLOCK);
            }
            IRubyObject keyAsStr = this.normalizeEnvString(RuntimeHelpers.invoke(context, key2, "to_str"));
            IRubyObject iRubyObject = valueAsStr = value2.isNil() ? this.getRuntime().getNil() : this.normalizeEnvString(RuntimeHelpers.invoke(context, value2, "to_str"));
            if (!this.updateRealENV) return super.op_aset(context, keyAsStr, valueAsStr);
            POSIX posix = this.getRuntime().getPosix();
            String keyAsJava = keyAsStr.asJavaString();
            if (valueAsStr == this.getRuntime().getNil()) {
                Class<Object> clazz = Object.class;
                synchronized (Object.class) {
                    posix.unsetenv(keyAsJava);
                    // ** MonitorExit[var9_9] (shouldn't be in output)
                    return super.op_aset(context, keyAsStr, valueAsStr);
                }
            }
            Class<Object> clazz = Object.class;
            synchronized (Object.class) {
                posix.setenv(keyAsJava, valueAsStr.asJavaString(), 1);
                // ** MonitorExit[var9_10] (shouldn't be in output)
                return super.op_aset(context, keyAsStr, valueAsStr);
            }
        }

        private RubyString getCorrectKey(IRubyObject key2, ThreadContext context) {
            RubyString originalKey;
            RubyString actualKey = originalKey = key2.convertToString();
            Ruby runtime = context.getRuntime();
            if (Platform.IS_WINDOWS) {
                RubyArray keys2 = super.keys();
                for (int i2 = 0; i2 < keys2.size(); ++i2) {
                    RubyString candidateKey = keys2.eltInternal(i2).convertToString();
                    if (!candidateKey.casecmp(context, originalKey).op_equal(context, RubyFixnum.zero(runtime)).isTrue()) continue;
                    actualKey = candidateKey;
                    break;
                }
            }
            return actualKey;
        }

        private IRubyObject normalizeEnvString(IRubyObject str) {
            if (str instanceof RubyString) {
                Encoding enc = this.getRuntime().getEncodingService().getLocaleEncoding();
                RubyString newStr = this.getRuntime().newString(new ByteList(str.toString().getBytes(), enc));
                newStr.setFrozen(true);
                return newStr;
            }
            return str;
        }
    }

    public static class CaseInsensitiveStringOnlyRubyHash
    extends StringOnlyRubyHash {
        public CaseInsensitiveStringOnlyRubyHash(Ruby runtime, Map valueMap, IRubyObject defaultValue, boolean updateRealENV) {
            super(runtime, valueMap, defaultValue, updateRealENV);
        }

        public IRubyObject op_aref(ThreadContext context, IRubyObject key2) {
            return this.case_aware_op_aref(context, key2, false);
        }

        public IRubyObject op_aset(ThreadContext context, IRubyObject key2, IRubyObject value2) {
            return this.case_aware_op_aset(context, key2, value2, false);
        }

        @JRubyMethod
        public IRubyObject to_s() {
            return this.getRuntime().newString("ENV");
        }
    }
}

