/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DistributionPoint;

public class CRLDistPoint
extends ASN1Encodable {
    ASN1Sequence seq = null;

    public static CRLDistPoint getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, bl));
    }

    public static CRLDistPoint getInstance(Object object) {
        if (object instanceof CRLDistPoint || object == null) {
            return (CRLDistPoint)object;
        }
        if (object instanceof ASN1Sequence) {
            return new CRLDistPoint((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public CRLDistPoint(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
    }

    public CRLDistPoint(DistributionPoint[] distributionPointArray) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        for (int j = 0; j != distributionPointArray.length; ++j) {
            aSN1EncodableVector.add(distributionPointArray[j]);
        }
        this.seq = new DERSequence(aSN1EncodableVector);
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] distributionPointArray = new DistributionPoint[this.seq.size()];
        for (int j = 0; j != this.seq.size(); ++j) {
            distributionPointArray[j] = DistributionPoint.getInstance(this.seq.getObjectAt(j));
        }
        return distributionPointArray;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = System.getProperty("line.separator");
        stringBuffer.append("CRLDistPoint:");
        stringBuffer.append(string2);
        DistributionPoint[] distributionPointArray = this.getDistributionPoints();
        for (int j = 0; j != distributionPointArray.length; ++j) {
            stringBuffer.append("    ");
            stringBuffer.append(distributionPointArray[j]);
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }
}

