/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Arrays;
import java.util.Properties;

public class StubLoader {
    public static final int VERSION_MAJOR = StubLoader.getVersionField("MAJOR");
    public static final int VERSION_MINOR = StubLoader.getVersionField("MINOR");
    private static final String versionClassName = "com.kenai.jffi.Version";
    private static final String bootPropertyFilename = "boot.properties";
    private static final String bootLibraryPropertyName = "jffi.boot.library.path";
    private static final String stubLibraryName = String.format("jffi-%d.%d", VERSION_MAJOR, VERSION_MINOR);
    private static final OS OS_ = StubLoader.determineOS();
    private static final CPU CPU_ = StubLoader.determineCPU();
    private static volatile Throwable failureCause = null;
    private static volatile boolean loaded = false;

    public static final boolean isLoaded() {
        return loaded;
    }

    public static final Throwable getFailureCause() {
        return failureCause;
    }

    private static final OS determineOS() {
        String osName = System.getProperty("os.name").split(" ")[0].toLowerCase();
        if (osName.startsWith("mac") || osName.startsWith("darwin")) {
            return OS.DARWIN;
        }
        if (osName.startsWith("linux")) {
            return OS.LINUX;
        }
        if (osName.startsWith("sunos") || osName.startsWith("solaris")) {
            return OS.SOLARIS;
        }
        if (osName.startsWith("aix")) {
            return OS.AIX;
        }
        if (osName.startsWith("openbsd")) {
            return OS.OPENBSD;
        }
        if (osName.startsWith("freebsd")) {
            return OS.FREEBSD;
        }
        if (osName.startsWith("windows")) {
            return OS.WINDOWS;
        }
        return OS.UNKNOWN;
    }

    private static final CPU determineCPU() {
        String archString = System.getProperty("os.arch", "unknown").toLowerCase();
        if ("x86".equals(archString) || "i386".equals(archString) || "i86pc".equals(archString)) {
            return CPU.I386;
        }
        if ("x86_64".equals(archString) || "amd64".equals(archString)) {
            return CPU.X86_64;
        }
        if ("ppc".equals(archString) || "powerpc".equals(archString)) {
            return CPU.PPC;
        }
        if ("powerpc64".equals(archString)) {
            return CPU.PPC64;
        }
        try {
            return CPU.valueOf(archString.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            return CPU.UNKNOWN;
        }
    }

    public static CPU getCPU() {
        return CPU_;
    }

    public static OS getOS() {
        return OS_;
    }

    private static String getStubLibraryName() {
        return stubLibraryName;
    }

    public static String getPlatformName() {
        if (StubLoader.getOS().equals((Object)OS.DARWIN)) {
            return "Darwin";
        }
        String osName = System.getProperty("os.name").split(" ")[0];
        return StubLoader.getCPU().name().toLowerCase() + "-" + osName;
    }

    private static String getStubLibraryPath() {
        return "jni/" + StubLoader.getPlatformName() + "/" + System.mapLibraryName(stubLibraryName);
    }

    static void load() {
        String libName = StubLoader.getStubLibraryName();
        String bootPath = StubLoader.getBootPath();
        if (bootPath != null && StubLoader.loadFromBootPath(libName, bootPath)) {
            return;
        }
        String libraryPath = System.getProperty("java.library.path");
        if (libraryPath != null && StubLoader.loadFromBootPath(libName, libraryPath)) {
            return;
        }
        StubLoader.loadFromJar();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBootPath() {
        String bootPath = System.getProperty(bootLibraryPropertyName);
        if (bootPath != null) {
            return bootPath;
        }
        InputStream is = StubLoader.getResourceAsStream(bootPropertyFilename);
        if (is != null) {
            Properties p2 = new Properties();
            try {
                p2.load(is);
                String string2 = p2.getProperty(bootLibraryPropertyName);
                return string2;
            }
            catch (IOException ex) {
                try {
                    is.close();
                }
                catch (IOException ex2) {
                    throw new RuntimeException(ex2);
                }
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return null;
    }

    private static String getAlternateLibraryPath(String path2) {
        if (path2.endsWith("dylib")) {
            return path2.substring(0, path2.lastIndexOf("dylib")) + "jnilib";
        }
        return path2.substring(0, path2.lastIndexOf("jnilib")) + "dylib";
    }

    private static boolean loadFromBootPath(String libName, String bootPath) {
        String[] dirs = bootPath.split(File.pathSeparator);
        for (int i2 = 0; i2 < dirs.length; ++i2) {
            String path2 = new File(new File(dirs[i2]), System.mapLibraryName(libName)).getAbsolutePath();
            try {
                System.load(path2);
                return true;
            }
            catch (UnsatisfiedLinkError ex) {
                if (StubLoader.getOS() != OS.DARWIN) continue;
                try {
                    System.load(StubLoader.getAlternateLibraryPath(path2));
                    return true;
                }
                catch (UnsatisfiedLinkError ex2) {
                    // empty catch block
                }
                continue;
            }
        }
        return false;
    }

    private static void loadFromJar() {
        InputStream is = StubLoader.getStubLibraryStream();
        File dstFile = null;
        FileOutputStream os = null;
        try {
            dstFile = File.createTempFile("jffi", null);
            dstFile.deleteOnExit();
            os = new FileOutputStream(dstFile);
            ReadableByteChannel srcChannel = Channels.newChannel(is);
            long pos2 = 0L;
            while (is.available() > 0) {
                pos2 += os.getChannel().transferFrom(srcChannel, pos2, Math.max(4096, is.available()));
            }
        }
        catch (IOException ex) {
            throw new UnsatisfiedLinkError(ex.getMessage());
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
                is.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        System.load(dstFile.getAbsolutePath());
    }

    private static InputStream getStubLibraryStream() {
        Object[] paths;
        String stubPath = StubLoader.getStubLibraryPath();
        for (String string2 : paths = new String[]{stubPath, "/" + stubPath}) {
            InputStream is = StubLoader.getResourceAsStream(string2);
            if (is == null && StubLoader.getOS() == OS.DARWIN) {
                is = StubLoader.getResourceAsStream(StubLoader.getAlternateLibraryPath(string2));
            }
            if (is == null) continue;
            return is;
        }
        throw new UnsatisfiedLinkError("could not locate stub library in jar file.  Tried " + Arrays.deepToString(paths));
    }

    private static InputStream getResourceAsStream(String resourceName) {
        ClassLoader[] cls;
        for (ClassLoader cl : cls = new ClassLoader[]{ClassLoader.getSystemClassLoader(), StubLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
            InputStream is;
            if (cl == null || (is = cl.getResourceAsStream(resourceName)) == null) continue;
            return is;
        }
        return null;
    }

    private static int getVersionField(String name2) {
        try {
            Class<?> c = Class.forName(versionClassName);
            return (Integer)c.getField(name2).get(c);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        try {
            StubLoader.load();
            loaded = true;
        }
        catch (Throwable t) {
            failureCause = t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CPU {
        I386,
        X86_64,
        PPC,
        PPC64,
        SPARC,
        SPARCV9,
        S390X,
        ARM,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OS {
        DARWIN,
        FREEBSD,
        NETBSD,
        OPENBSD,
        LINUX,
        SOLARIS,
        WINDOWS,
        AIX,
        ZLINUX,
        UNKNOWN;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

