/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class ReturnInstr
extends ReturnBase {
    public final IRMethod methodToReturnFrom;

    public ReturnInstr(Operand returnValue, IRMethod methodToReturnFrom) {
        super(Operation.RETURN, returnValue);
        this.methodToReturnFrom = methodToReturnFrom;
    }

    public ReturnInstr(Operand returnValue) {
        this(returnValue, null);
    }

    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.returnValue + (this.methodToReturnFrom == null ? "" : ", <" + this.methodToReturnFrom.getName() + ">") + ")";
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new ReturnInstr(this.returnValue.cloneForInlining(ii), this.methodToReturnFrom);
    }

    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (this.methodToReturnFrom == null) {
            Variable v = ii.getCallResultVariable();
            return v == null ? null : new CopyInstr(v, this.returnValue.cloneForInlining(ii));
        }
        if (ii.getInlineHostScope() == this.methodToReturnFrom) {
            return new ReturnInstr(this.returnValue.cloneForInlining(ii));
        }
        return this.cloneForInlining(ii);
    }

    public void visit(IRVisitor visitor) {
        visitor.ReturnInstr(this);
    }
}

