/*
 * Decompiled with CFR 0.152.
 */
package jnr.posix.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.util.Platform;

public class Finder {
    private static String PS = Platform.IS_WINDOWS ? ";" : ":";
    private static Map<String, String> EXECUTABLE_EXTENSIONS = new HashMap(){
        {
            this.put(".exe", ".exe");
            this.put(".com", ".com");
            this.put(".cmd", ".cmd");
            this.put(".bat", ".bat");
        }
    };

    public static String findFileInPath(POSIX posix, String name2, String path2) {
        if (path2 == null || path2.length() == 0) {
            path2 = System.getenv("PATH");
        }
        if (path2 == null || path2.length() == 0) {
            return name2;
        }
        return Finder.findFileCommon(posix, name2, path2, true);
    }

    public static String findFileCommon(POSIX posix, String name2, String path2, boolean executableOnly) {
        if (name2 == null || name2.length() == 0) {
            return name2;
        }
        int length2 = name2.length();
        boolean isAbsolute = false;
        boolean isPath = false;
        int i2 = 0;
        if (Platform.IS_WINDOWS) {
            if (length2 > 1 && Character.isLetter(name2.charAt(0)) && name2.charAt(1) == ':') {
                i2 = 2;
                isAbsolute = true;
            }
            int extensionIndex = -1;
            char c = name2.charAt(i2);
            if (i2 == 47 || i2 == 92) {
                c = name2.charAt(++i2);
                isAbsolute = true;
            }
            while (i2 < length2) {
                switch (c) {
                    case '/': 
                    case '\\': {
                        isPath = true;
                        extensionIndex = -1;
                        break;
                    }
                    case '.': {
                        extensionIndex = i2 - 1;
                    }
                }
                c = name2.charAt(i2);
                ++i2;
            }
            if (extensionIndex >= 0 && EXECUTABLE_EXTENSIONS.get(name2.substring(extensionIndex).toLowerCase()) == null) {
                extensionIndex = -1;
            }
            if (!executableOnly) {
                if (isAbsolute) {
                    return name2;
                }
            } else if (isPath) {
                if (extensionIndex >= 0) {
                    return name2;
                }
                if (executableOnly) {
                    return Finder.addExtension(name2);
                }
                if (new File(name2).exists()) {
                    return name2;
                }
                return null;
            }
            String[] paths = path2.split(PS);
            for (int p2 = 0; p2 < paths.length; ++p2) {
                String home2;
                String currentPath = paths[p2];
                int currentPathLength = currentPath.length();
                if (currentPath == null || currentPathLength == 0) continue;
                if (currentPath.charAt(0) == '~' && (currentPathLength == 1 || currentPathLength > 1 && (currentPath.charAt(1) == '/' || currentPath.charAt(1) == '\\')) && (home2 = System.getenv("HOME")) != null) {
                    currentPath = home2 + (currentPathLength == 1 ? "" : currentPath.substring(1));
                }
                if (!currentPath.endsWith("/") && !currentPath.endsWith("\\")) {
                    currentPath = currentPath + "\\";
                }
                String filename2 = currentPath + name2;
                if (Platform.IS_WINDOWS) {
                    filename2.replace('/', '\\');
                }
                if (Platform.IS_WINDOWS && executableOnly && extensionIndex == -1) {
                    String extendedFilename = Finder.addExtension(filename2);
                    if (extendedFilename == null) continue;
                    return extendedFilename;
                }
                FileStat stat2 = posix.allocateStat();
                int value2 = posix.libc().stat(filename2, stat2);
                if (value2 < 0) continue;
                if (!executableOnly) {
                    return filename2;
                }
                if (stat2.isDirectory() || !stat2.isExecutable()) continue;
                return filename2;
            }
        }
        return null;
    }

    public static String addExtension(String path2) {
        for (String extension : EXECUTABLE_EXTENSIONS.keySet()) {
            String newPath = path2 + extension;
            if (!new File(newPath).exists()) continue;
            return newPath;
        }
        return null;
    }
}

