/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jnr.constants.Constant;
import jnr.constants.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantSet
extends AbstractSet<Constant> {
    private final ConcurrentMap<String, Constant> nameToConstant;
    private final ConcurrentMap<Long, Constant> valueToConstant;
    private final Set<Enum> constants;
    private final Class<Enum> enumClass;
    private volatile Long minValue;
    private volatile Long maxValue;
    private static final ConcurrentMap<String, ConstantSet> constantSets = new ConcurrentHashMap<String, ConstantSet>();
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstantSet getConstantSet(String name2) {
        ConstantSet constants2 = (ConstantSet)constantSets.get(name2);
        if (constants2 == null) {
            Object object = lock;
            synchronized (object) {
                if (!constantSets.containsKey(name2)) {
                    Class<Enum> enumClass = ConstantSet.getEnumClass(name2);
                    if (enumClass == null) {
                        return null;
                    }
                    if (!Constant.class.isAssignableFrom(enumClass)) {
                        throw new ClassCastException("class for " + name2 + " does not implement Constant interface");
                    }
                    constants2 = new ConstantSet(enumClass);
                    constantSets.put(name2, constants2);
                }
            }
        }
        return constants2;
    }

    private static final Class<Enum> getEnumClass(String name2) {
        String[] prefixes;
        for (String prefix : prefixes = Platform.getPlatform().getPackagePrefixes()) {
            try {
                return Class.forName(prefix + "." + name2).asSubclass(Enum.class);
            }
            catch (ClassNotFoundException ex) {
            }
        }
        return null;
    }

    private ConstantSet(Class<Enum> enumClass) {
        this.enumClass = enumClass;
        this.nameToConstant = new ConcurrentHashMap<String, Constant>();
        this.valueToConstant = new ConcurrentHashMap<Long, Constant>();
        this.constants = EnumSet.allOf(enumClass);
    }

    public Constant getConstant(String name2) {
        Constant c = (Constant)this.nameToConstant.get(name2);
        if (c == null) {
            try {
                c = (Constant)Constant.class.cast(Enum.valueOf(this.enumClass, name2));
                this.nameToConstant.put(name2, c);
            }
            catch (IllegalArgumentException ex) {
                return null;
            }
        }
        return c;
    }

    public Constant getConstant(long value2) {
        Constant c = (Constant)this.valueToConstant.get(value2);
        if (c == null) {
            for (Enum e : this.constants) {
                if (!(e instanceof Constant) || ((Constant)((Object)e)).longValue() != value2) continue;
                c = (Constant)((Object)e);
                break;
            }
            if (c != null) {
                this.valueToConstant.put(value2, c);
            }
        }
        return c;
    }

    public long getValue(String name2) {
        Constant c = this.getConstant(name2);
        return c != null ? c.longValue() : 0L;
    }

    public String getName(int value2) {
        Constant c = this.getConstant(value2);
        return c != null ? c.name() : "unknown";
    }

    private Long getLongField(String name2, long defaultValue) {
        try {
            Field f = this.enumClass.getField("MIN_VALUE");
            return (Long)f.get(this.enumClass);
        }
        catch (NoSuchFieldException ex) {
            return defaultValue;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public long minValue() {
        if (this.minValue == null) {
            this.minValue = this.getLongField("MIN_VALUE", Integer.MIN_VALUE);
        }
        return this.minValue.intValue();
    }

    public long maxValue() {
        if (this.maxValue == null) {
            this.maxValue = this.getLongField("MAX_VALUE", Integer.MAX_VALUE);
        }
        return this.maxValue.intValue();
    }

    @Override
    public Iterator<Constant> iterator() {
        return new ConstantIterator(this.constants);
    }

    @Override
    public int size() {
        return this.constants.size();
    }

    @Override
    public boolean contains(Object o) {
        return o != null && o.getClass().equals(this.enumClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ConstantIterator
    implements Iterator<Constant> {
        private final Iterator<Enum> it;
        private Constant next = null;

        ConstantIterator(Collection<Enum> constants2) {
            this.it = constants2.iterator();
            this.next = this.it.hasNext() ? (Constant)((Object)this.it.next()) : null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null && !this.next.name().equals("__UNKNOWN_CONSTANT__");
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Constant next() {
            Constant prev = this.next;
            this.next = this.it.hasNext() ? (Constant)((Object)this.it.next()) : null;
            return prev;
        }
    }
}

