/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.load;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.Ruby;
import org.jruby.ast.executable.Script;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.util.ClassCache;
import org.jruby.util.JRubyClassLoader;

public class CompiledScriptLoader {
    public static Script loadScriptFromFile(Ruby runtime, InputStream inStream, String resourceName) {
        String className;
        BufferedInputStream in;
        block15: {
            ClassReader cr;
            in = null;
            in = new BufferedInputStream(inStream, 8192);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[8196];
            int read2 = 0;
            while ((read2 = ((InputStream)in).read(buf)) != -1) {
                baos.write(buf, 0, read2);
            }
            buf = baos.toByteArray();
            JRubyClassLoader jcl = runtime.getJRubyClassLoader();
            ClassCache.OneShotClassLoader oscl = new ClassCache.OneShotClassLoader(jcl);
            Class<?> clazz = oscl.defineClass(className = (cr = new ClassReader(buf)).getClassName().replace('/', '.'), buf);
            if (!Script.class.isAssignableFrom(clazz)) break block15;
            Script script = (Script)clazz.newInstance();
            Object var14_17 = null;
            try {
                ((InputStream)in).close();
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
            return script;
        }
        try {
            try {
                throw runtime.newLoadError("use `java_import' to load normal Java classes: " + className);
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            catch (InstantiationException ie) {
                if (runtime.getDebug().isTrue()) {
                    ie.printStackTrace();
                }
                throw runtime.newLoadError("Error loading compiled script '" + resourceName + "': " + ie);
            }
            catch (IllegalAccessException iae) {
                if (runtime.getDebug().isTrue()) {
                    iae.printStackTrace();
                }
                throw runtime.newLoadError("Error loading compiled script '" + resourceName + "': " + iae);
            }
            catch (LinkageError le) {
                if (runtime.getDebug().isTrue()) {
                    le.printStackTrace();
                }
                throw runtime.newLoadError("Linkage error loading compiled script; you may need to recompile '" + resourceName + "': " + le);
            }
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            try {
                ((InputStream)in).close();
            }
            catch (IOException ioe) {
                throw runtime.newIOErrorFromException(ioe);
            }
            throw throwable;
        }
    }
}

