/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.security.cert.X509CRL;
import java.util.Collection;
import org.bouncycastle.asn1.DEREncodable;
import org.jruby.ext.openssl.impl.CipherSpec;
import org.jruby.ext.openssl.impl.PKCS7Data;
import org.jruby.ext.openssl.impl.RecipInfo;
import org.jruby.ext.openssl.impl.SignEnvelope;
import org.jruby.ext.openssl.impl.SignerInfoWithPkey;
import org.jruby.ext.openssl.x509store.X509AuxCertificate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PKCS7DataSignedAndEnveloped
extends PKCS7Data {
    private SignEnvelope signedAndEnveloped = new SignEnvelope();

    public PKCS7DataSignedAndEnveloped() {
        this.signedAndEnveloped.setVersion(1);
        this.signedAndEnveloped.getEncData().setContentType(21);
    }

    @Override
    public int getType() {
        return 24;
    }

    @Override
    public boolean isSignedAndEnveloped() {
        return true;
    }

    @Override
    public SignEnvelope getSignedAndEnveloped() {
        return this.signedAndEnveloped;
    }

    @Override
    public void setCipher(CipherSpec cipher2) {
        this.signedAndEnveloped.getEncData().setCipher(cipher2);
    }

    @Override
    public void addRecipientInfo(RecipInfo ri) {
        this.signedAndEnveloped.getRecipientInfo().add(ri);
    }

    @Override
    public void addSigner(SignerInfoWithPkey psi) {
        this.signedAndEnveloped.getMdAlgs().add(psi.getDigestAlgorithm());
        this.signedAndEnveloped.getSignerInfo().add(psi);
    }

    @Override
    public Collection<SignerInfoWithPkey> getSignerInfo() {
        return this.signedAndEnveloped.getSignerInfo();
    }

    @Override
    public void addCertificate(X509AuxCertificate cert2) {
        this.signedAndEnveloped.getCert().add(cert2);
    }

    @Override
    public void addCRL(X509CRL crl) {
        this.signedAndEnveloped.getCrl().add(crl);
    }

    public static PKCS7DataSignedAndEnveloped fromASN1(DEREncodable content) {
        throw new UnsupportedOperationException("TODO: can't create DataSignedAndEnveloped from ASN1 yet");
    }
}

