/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.PasswordRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.PasswordRecipientInformation;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.operator.GenericKey;

public abstract class PasswordRecipientInfoGenerator
implements RecipientInfoGenerator {
    private char[] password;
    private AlgorithmIdentifier keyDerivationAlgorithm;
    private ASN1ObjectIdentifier kekAlgorithm;
    private SecureRandom random;
    private int schemeID;
    private int keySize;
    private int blockSize;

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray) {
        this(aSN1ObjectIdentifier, cArray, PasswordRecipientInfoGenerator.getKeySize(aSN1ObjectIdentifier), (Integer)PasswordRecipientInformation.BLOCKSIZES.get(aSN1ObjectIdentifier));
    }

    protected PasswordRecipientInfoGenerator(ASN1ObjectIdentifier aSN1ObjectIdentifier, char[] cArray, int n, int n2) {
        this.password = cArray;
        this.schemeID = 1;
        this.kekAlgorithm = aSN1ObjectIdentifier;
        this.keySize = n;
        this.blockSize = n2;
    }

    private static int getKeySize(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Integer n = (Integer)PasswordRecipientInformation.KEYSIZES.get(aSN1ObjectIdentifier);
        if (n == null) {
            throw new IllegalArgumentException("cannot find key size for algorithm: " + aSN1ObjectIdentifier);
        }
        return n;
    }

    public PasswordRecipientInfoGenerator setPasswordConversionScheme(int n) {
        this.schemeID = n;
        return this;
    }

    public PasswordRecipientInfoGenerator setSaltAndIterationCount(byte[] byArray, int n) {
        this.keyDerivationAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params(byArray, n));
        return this;
    }

    public PasswordRecipientInfoGenerator setSecureRandom(SecureRandom secureRandom) {
        this.random = secureRandom;
        return this;
    }

    public RecipientInfo generate(GenericKey genericKey) throws CMSException {
        byte[] byArray;
        Object object;
        Object object2;
        byte[] byArray2 = new byte[this.blockSize];
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        this.random.nextBytes(byArray2);
        if (this.keyDerivationAlgorithm == null) {
            object2 = new byte[20];
            this.random.nextBytes((byte[])object2);
            this.keyDerivationAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params((byte[])object2, 1024));
        }
        object2 = PBKDF2Params.getInstance(this.keyDerivationAlgorithm.getParameters());
        if (this.schemeID == 0) {
            object = new PKCS5S2ParametersGenerator();
            ((PBEParametersGenerator)object).init(PBEParametersGenerator.PKCS5PasswordToBytes(this.password), ((PBKDF2Params)object2).getSalt(), ((PBKDF2Params)object2).getIterationCount().intValue());
            byArray = ((KeyParameter)((PKCS5S2ParametersGenerator)object).generateDerivedParameters(this.keySize)).getKey();
        } else {
            object = new PKCS5S2ParametersGenerator();
            ((PBEParametersGenerator)object).init(PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password), ((PBKDF2Params)object2).getSalt(), ((PBKDF2Params)object2).getIterationCount().intValue());
            byArray = ((KeyParameter)((PKCS5S2ParametersGenerator)object).generateDerivedParameters(this.keySize)).getKey();
        }
        object = new AlgorithmIdentifier(this.kekAlgorithm, new DEROctetString(byArray2));
        byte[] byArray3 = this.generateEncryptedBytes((AlgorithmIdentifier)object, byArray, genericKey);
        DEROctetString dEROctetString = new DEROctetString(byArray3);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.kekAlgorithm);
        aSN1EncodableVector.add(new DEROctetString(byArray2));
        AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_alg_PWRI_KEK, new DERSequence(aSN1EncodableVector));
        return new RecipientInfo(new PasswordRecipientInfo(this.keyDerivationAlgorithm, algorithmIdentifier, dEROctetString));
    }

    protected abstract byte[] generateEncryptedBytes(AlgorithmIdentifier var1, byte[] var2, GenericKey var3) throws CMSException;
}

