/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.SelectorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectBlob {
    Ruby runtime;
    RubyArray readArray = null;
    int readSize = 0;
    RubyIO[] readIOs = null;
    boolean[] unselectableReads = null;
    boolean[] pendingReads = null;
    Boolean[] readBlocking = null;
    int selectedReads = 0;
    RubyArray writeArray = null;
    int writeSize = 0;
    RubyIO[] writeIOs = null;
    boolean[] unselectableWrites = null;
    Boolean[] writeBlocking = null;
    int selectedWrites = 0;
    Selector selector = null;
    RubyArray readResults = null;
    RubyArray writeResults = null;
    RubyArray errorResults = null;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject goForIt(ThreadContext context, Ruby runtime, IRubyObject[] args) {
        block18: {
            block17: {
                this.runtime = runtime;
                try {
                    try {
                        this.processReads(runtime, args, context);
                        this.processWrites(runtime, args, context);
                        if (args.length > 2 && !args[2].isNil()) {
                            SelectBlob.checkArrayType(runtime, args[2]);
                        }
                        has_timeout = args.length > 3 && args[3].isNil() == false;
                        v0 = timeout = has_timeout == false ? 0L : SelectBlob.getTimeoutFromArg(args[3], runtime);
                        if (timeout < 0L) {
                            throw runtime.newArgumentError("time interval must be positive");
                        }
                        if (args[0].isNil() && args[1].isNil() && args[2].isNil()) {
                            if (timeout > 0L) {
                                context.getThread().sleep(timeout);
                            }
                        } else {
                            this.doSelect(has_timeout, timeout);
                            this.processSelectedKeys(runtime);
                            this.processPendingAndUnselectable();
                            this.tidyUp();
                        }
                        if (this.readResults == null && this.writeResults == null && this.errorResults == null) {
                            var7_9 = runtime.getNil();
                            var9_11 = null;
                            if (this.selector == null) return var7_9;
                            break block17;
                        }
                        var7_10 = this.constructResults(runtime);
                        break block18;
                    }
                    catch (BadDescriptorException e) {
                        throw runtime.newErrnoEBADFError();
                    }
                    catch (IOException e) {
                        throw runtime.newIOErrorFromException(e);
                    }
                    catch (InterruptedException ie) {
                        throw runtime.newThreadError("select interrupted");
                    }
                }
                catch (Throwable var8_17) {
                    var9_13 = null;
                    if (this.selector == null) throw var8_17;
                    try {
                        this.selector.close();
                        throw var8_17;
                    }
                    catch (Exception e) {
                        throw var8_17;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [9 : 261->271)] { 
lbl47:
            // 1 sources

            this.selector.close();
            return var7_9;
lbl49:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return var7_9;
        }
        var9_12 = null;
        if (this.selector == null) return var7_10;
        try {}
        catch (Exception e) {
            // empty catch block
            return var7_10;
        }
        this.selector.close();
        return var7_10;
    }

    private void processReads(Ruby runtime2, IRubyObject[] args2, ThreadContext context) throws BadDescriptorException, IOException {
        if (!args2[0].isNil()) {
            SelectBlob.checkArrayType(runtime2, args2[0]);
            this.readArray = (RubyArray)args2[0];
            this.readSize = this.readArray.size();
            if (this.readSize == 0) {
                this.readArray = null;
            } else {
                this.readIOs = new RubyIO[this.readSize];
                HashMap<Character, Integer> attachment = new HashMap<Character, Integer>(1);
                for (int i2 = 0; i2 < this.readSize; ++i2) {
                    RubyIO ioObj = this.saveReadIO(i2, context);
                    this.saveReadBlocking(ioObj, i2);
                    this.saveBufferedRead(ioObj, i2);
                    attachment.clear();
                    attachment.put(Character.valueOf('r'), i2);
                    this.trySelectRead(context, attachment, ioObj);
                }
            }
        }
    }

    private RubyIO saveReadIO(int i2, ThreadContext context) {
        RubyIO ioObj;
        IRubyObject obj = this.readArray.eltOk(i2);
        this.readIOs[i2] = ioObj = RubyIO.convertToIO(context, obj);
        return ioObj;
    }

    private void saveReadBlocking(RubyIO ioObj, int i2) {
        if (ioObj.getChannel() instanceof SelectableChannel) {
            this.getReadBlocking()[i2] = ((SelectableChannel)ioObj.getChannel()).isBlocking();
        }
    }

    private void saveBufferedRead(RubyIO ioObj, int i2) throws BadDescriptorException {
        if (ioObj.getOpenFile().getMainStreamSafe().readDataBuffered()) {
            this.getUnselectableReads()[i2] = true;
        }
    }

    private void trySelectRead(ThreadContext context, Map<Character, Integer> attachment, RubyIO ioObj) throws IOException {
        if (ioObj.getChannel() instanceof SelectableChannel && SelectBlob.registerSelect(context, this.getSelector(context), attachment, ioObj, 17)) {
            ++this.selectedReads;
            if (ioObj.writeDataBuffered()) {
                this.getPendingReads()[attachment.get((Object)Character.valueOf((char)'r')).intValue()] = true;
            }
        } else if ((ioObj.getOpenFile().getMode() & 1) != 0) {
            this.getUnselectableReads()[attachment.get((Object)Character.valueOf((char)'r')).intValue()] = true;
        }
    }

    private void processWrites(Ruby runtime2, IRubyObject[] args2, ThreadContext context) throws IOException {
        if (args2.length > 1 && !args2[1].isNil()) {
            SelectBlob.checkArrayType(runtime2, args2[1]);
            this.writeArray = (RubyArray)args2[1];
            this.writeSize = this.writeArray.size();
            if (this.writeArray.size() == 0) {
                this.writeArray = null;
            } else {
                this.writeIOs = new RubyIO[this.writeSize];
                HashMap<Character, Integer> attachment = new HashMap<Character, Integer>(1);
                for (int i2 = 0; i2 < this.writeSize; ++i2) {
                    RubyIO ioObj = this.saveWriteIO(i2, context);
                    this.saveWriteBlocking(ioObj, i2);
                    attachment.clear();
                    attachment.put(Character.valueOf('w'), i2);
                    this.trySelectWrite(context, attachment, ioObj);
                }
            }
        }
    }

    private RubyIO saveWriteIO(int i2, ThreadContext context) {
        RubyIO ioObj;
        IRubyObject obj = this.writeArray.eltOk(i2);
        this.writeIOs[i2] = ioObj = RubyIO.convertToIO(context, obj);
        return ioObj;
    }

    private void saveWriteBlocking(RubyIO ioObj, int i2) {
        if (ioObj.getChannel() instanceof SelectableChannel) {
            if (this.readBlocking != null) {
                int readIndex = this.fastSearch(this.readIOs, ioObj);
                if (readIndex == -1) {
                    this.getWriteBlocking()[i2] = ((SelectableChannel)ioObj.getChannel()).isBlocking();
                }
            } else {
                this.getWriteBlocking()[i2] = ((SelectableChannel)ioObj.getChannel()).isBlocking();
            }
        }
    }

    private void trySelectWrite(ThreadContext context, Map<Character, Integer> attachment, RubyIO ioObj) throws IOException {
        if (!SelectBlob.registerSelect(context, this.getSelector(context), attachment, ioObj, 4)) {
            ++this.selectedReads;
            if ((ioObj.getOpenFile().getMode() & 2) != 0) {
                this.getUnselectableWrites()[attachment.get((Object)Character.valueOf((char)'w')).intValue()] = true;
            }
        }
    }

    private static long getTimeoutFromArg(IRubyObject timeArg, Ruby runtime2) {
        long timeout2 = 0L;
        if (timeArg instanceof RubyFloat) {
            timeout2 = Math.round(((RubyFloat)timeArg).getDoubleValue() * 1000.0);
        } else if (timeArg instanceof RubyFixnum) {
            timeout2 = Math.round(((RubyFixnum)timeArg).getDoubleValue() * 1000.0);
        } else {
            throw runtime2.newTypeError("can't convert " + timeArg.getMetaClass().getName() + " into time interval");
        }
        if (timeout2 < 0L) {
            throw runtime2.newArgumentError("negative timeout given");
        }
        return timeout2;
    }

    private void doSelect(boolean has_timeout, long timeout2) throws IOException {
        if (this.selector != null) {
            if (this.pendingReads == null && this.unselectableReads == null && this.unselectableWrites == null) {
                if (has_timeout) {
                    if (timeout2 == 0L) {
                        this.selector.selectNow();
                    } else {
                        for (SelectionKey sk : this.selector.keys()) {
                            SocketChannel socketChannel;
                            if ((sk.interestOps() & 4) == 0 || sk.isWritable() || !(sk.channel() instanceof SocketChannel) || !(socketChannel = (SocketChannel)sk.channel()).isConnectionPending()) continue;
                            socketChannel.finishConnect();
                        }
                        this.selector.select(timeout2);
                    }
                } else {
                    this.selector.select();
                }
            } else {
                this.selector.selectNow();
            }
        }
    }

    private void processSelectedKeys(Ruby runtime2) {
        if (this.selector != null) {
            for (SelectionKey key2 : this.selector.selectedKeys()) {
                int readIoIndex = 0;
                int writeIoIndex = 0;
                try {
                    int interestAndReady = key2.interestOps() & key2.readyOps();
                    if (this.readArray != null && (interestAndReady & 0x19) != 0) {
                        readIoIndex = (Integer)((Map)key2.attachment()).get(Character.valueOf('r'));
                        this.getReadResults().append(this.readArray.eltOk(readIoIndex));
                        if (this.pendingReads != null) {
                            this.pendingReads[readIoIndex] = false;
                        }
                    }
                    if (this.writeArray == null || (interestAndReady & 4) == 0) continue;
                    writeIoIndex = (Integer)((Map)key2.attachment()).get(Character.valueOf('w'));
                    this.getWriteResults().append(this.writeArray.eltOk(writeIoIndex));
                }
                catch (CancelledKeyException cke) {
                    int interest = key2.interestOps();
                    if (this.readArray != null && (interest & 0x19) != 0) {
                        if (this.pendingReads != null) {
                            this.pendingReads[readIoIndex] = false;
                        }
                        if (this.errorResults != null) {
                            this.errorResults = RubyArray.newArray(runtime2, this.readArray.size() + this.writeArray.size());
                        }
                        if (this.fastSearch(this.errorResults.toJavaArrayUnsafe(), this.readIOs[readIoIndex]) == -1) {
                            this.getErrorResults().append(this.readArray.eltOk(readIoIndex));
                        }
                    }
                    if (this.writeArray == null || (interest & 4) == 0 || this.fastSearch(this.errorResults.toJavaArrayUnsafe(), this.writeIOs[writeIoIndex]) != -1) continue;
                    this.errorResults.append(this.writeArray.eltOk(writeIoIndex));
                }
            }
        }
    }

    private void processPendingAndUnselectable() {
        int i2;
        if (this.pendingReads != null) {
            for (i2 = 0; i2 < this.pendingReads.length; ++i2) {
                if (!this.pendingReads[i2]) continue;
                this.getReadResults().append(this.readArray.eltOk(i2));
            }
        }
        if (this.unselectableReads != null) {
            for (i2 = 0; i2 < this.unselectableReads.length; ++i2) {
                if (!this.unselectableReads[i2]) continue;
                this.getReadResults().append(this.readArray.eltOk(i2));
            }
        }
        if (this.unselectableWrites != null) {
            for (i2 = 0; i2 < this.unselectableWrites.length; ++i2) {
                if (!this.unselectableWrites[i2]) continue;
                this.getWriteResults().append(this.writeArray.eltOk(i2));
            }
        }
    }

    private void tidyUp() throws IOException {
        int i2;
        if (this.selector != null) {
            this.selector.close();
        }
        if (this.readBlocking != null) {
            for (i2 = 0; i2 < this.readBlocking.length; ++i2) {
                if (this.readBlocking[i2] == null) continue;
                try {
                    ((SelectableChannel)this.readIOs[i2].getChannel()).configureBlocking(this.readBlocking[i2]);
                    continue;
                }
                catch (IllegalBlockingModeException ibme) {
                    throw this.runtime.newConcurrencyError("can not set IO blocking after select; concurrent select detected?");
                }
            }
        }
        if (this.writeBlocking != null) {
            for (i2 = 0; i2 < this.writeBlocking.length; ++i2) {
                if (this.writeBlocking[i2] == null) continue;
                try {
                    ((SelectableChannel)this.writeIOs[i2].getChannel()).configureBlocking(this.writeBlocking[i2]);
                    continue;
                }
                catch (IllegalBlockingModeException ibme) {
                    throw this.runtime.newConcurrencyError("can not set IO blocking after select; concurrent select detected?");
                }
            }
        }
    }

    private RubyArray getReadResults() {
        if (this.readResults == null) {
            this.readResults = RubyArray.newArray(this.runtime, this.readArray.size());
        }
        return this.readResults;
    }

    private RubyArray getWriteResults() {
        if (this.writeResults == null) {
            this.writeResults = RubyArray.newArray(this.runtime, this.writeArray.size());
        }
        return this.writeResults;
    }

    private RubyArray getErrorResults() {
        if (this.errorResults != null) {
            this.errorResults = RubyArray.newArray(this.runtime, this.readArray.size() + this.writeArray.size());
        }
        return this.errorResults;
    }

    private Selector getSelector(ThreadContext context) throws IOException {
        if (this.selector == null) {
            this.selector = SelectorFactory.openWithRetryFrom(context.getRuntime(), SelectorProvider.provider());
        }
        return this.selector;
    }

    private Boolean[] getReadBlocking() {
        if (this.readBlocking == null) {
            this.readBlocking = new Boolean[this.readSize];
        }
        return this.readBlocking;
    }

    private Boolean[] getWriteBlocking() {
        if (this.writeBlocking == null) {
            this.writeBlocking = new Boolean[this.writeSize];
        }
        return this.writeBlocking;
    }

    private boolean[] getUnselectableReads() {
        if (this.unselectableReads == null) {
            this.unselectableReads = new boolean[this.readSize];
        }
        return this.unselectableReads;
    }

    private boolean[] getUnselectableWrites() {
        if (this.unselectableWrites == null) {
            this.unselectableWrites = new boolean[this.writeSize];
        }
        return this.unselectableWrites;
    }

    private boolean[] getPendingReads() {
        if (this.pendingReads == null) {
            this.pendingReads = new boolean[this.readSize];
        }
        return this.pendingReads;
    }

    private IRubyObject constructResults(Ruby runtime2) {
        return RubyArray.newArrayLight(runtime2, this.readResults == null ? RubyArray.newEmptyArray(runtime2) : this.readResults, this.writeResults == null ? RubyArray.newEmptyArray(runtime2) : this.writeResults, this.errorResults == null ? RubyArray.newEmptyArray(runtime2) : this.errorResults);
    }

    private int fastSearch(Object[] ary, Object obj) {
        for (int i2 = 0; i2 < ary.length; ++i2) {
            if (ary[i2] != obj) continue;
            return i2;
        }
        return -1;
    }

    private static void checkArrayType(Ruby runtime2, IRubyObject obj) {
        if (!(obj instanceof RubyArray)) {
            throw runtime2.newTypeError("wrong argument type " + obj.getMetaClass().getName() + " (expected Array)");
        }
    }

    private static boolean registerSelect(ThreadContext context, Selector selector, Map<Character, Integer> obj, RubyIO ioObj, int ops) throws IOException {
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return false;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key2 = ((SelectableChannel)channel).keyFor(selector);
        if (key2 == null) {
            HashMap<Character, Integer> attachment = new HashMap<Character, Integer>(1);
            attachment.putAll(obj);
            ((SelectableChannel)channel).register(selector, real_ops, attachment);
        } else {
            key2.interestOps(key2.interestOps() | real_ops);
            Map att = (Map)key2.attachment();
            att.putAll(obj);
            key2.attach(att);
        }
        return true;
    }
}

