/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.Map;
import org.jruby.RubyClass;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodHandle
extends Operand {
    protected Operand methodName;
    protected Operand receiver;
    private String resolvedMethodName;
    private CacheEntry cachedMethod;
    private IRubyObject receiverObj;

    public MethodHandle(Operand methodName, Operand receiver2) {
        this.methodName = methodName;
        this.receiver = receiver2;
    }

    public Operand getMethodNameOperand() {
        return this.methodName;
    }

    public DynamicMethod getResolvedMethod() {
        return this.cachedMethod.method;
    }

    public String getResolvedMethodName() {
        return this.resolvedMethodName;
    }

    public IRubyObject getReceiverObj() {
        return this.receiverObj;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        this.methodName = this.methodName.getSimplifiedOperand(valueMap);
        this.receiver = this.receiver.getSimplifiedOperand(valueMap);
        return this;
    }

    public String toString() {
        return "<" + this.receiver + "." + this.methodName + ">";
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        return new MethodHandle(this.methodName.cloneForInlining(ii), this.receiver.cloneForInlining(ii));
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        this.receiverObj = (IRubyObject)this.receiver.retrieve(interp);
        if (this.methodName instanceof MethAddr) {
            this.resolvedMethodName = ((MethAddr)this.methodName).getName();
        } else {
            IRubyObject mnameObj = (IRubyObject)this.methodName.retrieve(interp);
            assert (mnameObj instanceof RubyString || mnameObj instanceof RubySymbol);
            if (!mnameObj.toString().equals(this.resolvedMethodName)) {
                this.cachedMethod = null;
                this.resolvedMethodName = mnameObj.toString();
            }
        }
        RubyClass receiverClass = this.receiverObj.getMetaClass();
        if (this.cachedMethod == null || !this.cachedMethod.typeOk(receiverClass)) {
            this.cachedMethod = receiverClass.searchWithCache(this.resolvedMethodName);
        }
        return this;
    }
}

