/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.TypeConverter;

public class JRubyTypeLibrary
implements Library {
    public void load(Ruby runtime2, boolean wrap2) throws IOException {
        RubyModule jrubyType = runtime2.defineModule("Type");
        jrubyType.defineAnnotatedMethods(JRubyTypeLibrary.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject coerce_to(ThreadContext context, IRubyObject self, IRubyObject object, IRubyObject clazz, IRubyObject method2) {
        Ruby ruby2 = object.getRuntime();
        if (!(clazz instanceof RubyClass)) {
            throw ruby2.newTypeError(clazz, ruby2.getClassClass());
        }
        if (!(method2 instanceof RubySymbol)) {
            throw ruby2.newTypeError(method2, ruby2.getSymbol());
        }
        RubyClass rubyClass = (RubyClass)clazz;
        RubySymbol methodSym = (RubySymbol)method2;
        return TypeConverter.convertToTypeOrRaise(object, rubyClass, methodSym.asJavaString());
    }
}

