/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.NativeType;
import org.jruby.ext.ffi.Struct;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Type;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::StructByValue"}, parent="FFI::Type")
public final class StructByValue
extends Type {
    private final StructLayout structLayout;
    private final RubyClass structClass;

    public static RubyClass createStructByValueClass(Ruby runtime2, RubyModule ffiModule) {
        RubyClass sbvClass = ffiModule.defineClassUnder("StructByValue", ffiModule.fastGetClass("Type"), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        sbvClass.defineAnnotatedMethods(StructByValue.class);
        sbvClass.defineAnnotatedConstants(StructByValue.class);
        ffiModule.fastGetClass("Type").fastSetConstant("Struct", sbvClass);
        return sbvClass;
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static final IRubyObject newStructByValue(ThreadContext context, IRubyObject klass, IRubyObject structClass) {
        if (!(structClass instanceof RubyClass)) {
            throw context.getRuntime().newTypeError("wrong argument type " + structClass.getMetaClass().getName() + " (expected Class)");
        }
        if (!((RubyClass)structClass).isKindOfModule(context.getRuntime().fastGetModule("FFI").fastGetClass("Struct"))) {
            throw context.getRuntime().newTypeError("wrong argument type " + structClass.getMetaClass().getName() + " (expected subclass of FFI::Struct)");
        }
        return new StructByValue(context.getRuntime(), (RubyClass)klass, (RubyClass)structClass, Struct.getStructLayout(context.getRuntime(), structClass));
    }

    private StructByValue(Ruby runtime2, RubyClass klass, RubyClass structClass, StructLayout structLayout) {
        super(runtime2, klass, NativeType.STRUCT, structLayout.size, structLayout.alignment);
        this.structClass = structClass;
        this.structLayout = structLayout;
    }

    StructByValue(Ruby runtime2, RubyClass structClass, StructLayout structLayout) {
        super(runtime2, runtime2.fastGetModule("FFI").fastGetClass("Type").fastGetClass("Struct"), NativeType.STRUCT, structLayout.size, structLayout.alignment);
        this.structClass = structClass;
        this.structLayout = structLayout;
    }

    @JRubyMethod(name={"to_s"})
    public final IRubyObject to_s(ThreadContext context) {
        return RubyString.newString(context.getRuntime(), String.format("#<FFI::StructByValue:%s>", this.structClass.getName()));
    }

    @JRubyMethod(name={"layout"})
    public final IRubyObject layout(ThreadContext context) {
        return this.structLayout;
    }

    @JRubyMethod(name={"struct_class"})
    public final IRubyObject struct_class(ThreadContext context) {
        return this.structClass;
    }

    public final StructLayout getStructLayout() {
        return this.structLayout;
    }

    public final RubyClass getStructClass() {
        return this.structClass;
    }

    public final Struct newStruct(Ruby runtime2, byte[] data, int offset2) {
        return new Struct(runtime2, this.structClass, this.structLayout, new Buffer(runtime2, data, offset2, this.structLayout.getSize()));
    }
}

