/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.operands.KeyValuePair;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hash
extends Operand {
    public final List<KeyValuePair> pairs;

    public Hash(List<KeyValuePair> pairs) {
        this.pairs = pairs;
    }

    public boolean isBlank() {
        return this.pairs == null || this.pairs.isEmpty();
    }

    @Override
    public boolean isConstant() {
        for (KeyValuePair pair : this.pairs) {
            if (pair.getKey().isConstant() && pair.getValue().isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        int i2 = 0;
        for (KeyValuePair pair : this.pairs) {
            pair.setKey(pair.getKey().getSimplifiedOperand(valueMap));
            pair.setValue(pair.getValue().getSimplifiedOperand(valueMap));
            ++i2;
        }
        return this;
    }

    @Override
    public IRClass getTargetClass() {
        return IRClass.getCoreClass("Hash");
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (KeyValuePair pair : this.pairs) {
            pair.getKey().addUsedVariables(l);
            pair.getValue().addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.isConstant()) {
            return this;
        }
        ArrayList<KeyValuePair> newPairs = new ArrayList<KeyValuePair>();
        for (KeyValuePair pair : this.pairs) {
            newPairs.add(new KeyValuePair(pair.getKey().cloneForInlining(ii), pair.getValue().cloneForInlining(ii)));
        }
        return new Hash(newPairs);
    }

    @Override
    public Object retrieve(InterpreterContext interp) {
        Ruby runtime2 = interp.getRuntime();
        RubyHash hash2 = RubyHash.newHash(runtime2);
        for (KeyValuePair pair : this.pairs) {
            hash2.fastASetCheckString(runtime2, (IRubyObject)pair.getKey().retrieve(interp), (IRubyObject)pair.getValue().retrieve(interp));
        }
        return hash2;
    }
}

