/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jruby.lexer.yacc.LexerSource;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteArrayLexerSource
extends LexerSource {
    private Cursor readCursor;
    private Cursor mainCursor;
    private Cursor pushbackCursor;
    private final boolean captureSource;

    public ByteArrayLexerSource(String sourceName, byte[] in, List<String> list2, int line, boolean extraPositionInformation) {
        super(sourceName, list2, line, extraPositionInformation);
        this.mainCursor = this.readCursor = new ByteArrayCursor(in);
        this.pushbackCursor = new PushbackCursor(this.mainCursor, new ByteList(128));
        this.captureSource = list2 != null;
    }

    @Override
    public boolean matchMarker(ByteList marker, boolean indent, boolean withNewline) throws IOException {
        int i2;
        int c;
        int matchPos = 0;
        if (indent) {
            c = this.readCursor.at(matchPos);
            while (c != -1 && Character.isWhitespace(c) && c != 10) {
                c = this.readCursor.at(++matchPos);
            }
        }
        for (i2 = 0; i2 < marker.length(); ++i2) {
            if (this.readCursor.at(matchPos) != marker.get(i2)) {
                return false;
            }
            ++matchPos;
        }
        if (withNewline) {
            if ((c = this.readCursor.at(matchPos++)) == 13) {
                c = this.readCursor.at(matchPos);
            }
            if (c != 10 && c != -1) {
                return false;
            }
        }
        for (i2 = 0; i2 < matchPos; ++i2) {
            this.readCursor.read();
        }
        return true;
    }

    @Override
    public int read() {
        return this.readCursor.read();
    }

    @Override
    public ByteList readUntil(char marker) throws IOException {
        return this.readUntil(marker, true);
    }

    private ByteList readUntil(char marker, boolean nullIfEnd) throws IOException {
        int c;
        ByteList result2 = new ByteList(128);
        while ((c = this.readCursor.read()) != marker && c != -1) {
            result2.append(c);
        }
        if (nullIfEnd && c == -1) {
            return null;
        }
        return result2;
    }

    @Override
    public ByteList readLineBytes() throws IOException {
        return this.readUntil('\n', false);
    }

    @Override
    public int skipUntil(int marker) throws IOException {
        int c;
        while ((c = this.readCursor.read()) != marker && c != -1) {
        }
        return c;
    }

    @Override
    public void unread(int c) {
        if (c == -1) {
            return;
        }
        if (this.captureSource) {
            this.uncaptureFeature(c);
        }
        this.readCursor.unread(c);
    }

    @Override
    public void unreadMany(CharSequence line) {
        for (int i2 = line.length() - 1; i2 >= 0; --i2) {
            this.unread(line.charAt(i2));
        }
    }

    @Override
    public boolean peek(int c) throws IOException {
        return this.readCursor.at(0) == c;
    }

    @Override
    public boolean lastWasBeginOfLine() {
        int c = this.readCursor.at(-1);
        return c == 10 || c == -1;
    }

    @Override
    public boolean wasBeginOfLine() {
        int c = this.readCursor.at(-2);
        return c == 10 || c == -1 && c != this.readCursor.at(-1);
    }

    @Override
    public String getCurrentLine() {
        int c;
        int lineOffset = 0;
        while ((c = this.readCursor.at(lineOffset - 1)) != 10 && c != -1) {
            --lineOffset;
        }
        String ptr = this.makePointer(-(lineOffset + 1));
        StringBuilder lineBuilder = new StringBuilder();
        c = this.readCursor.at(lineOffset);
        while (c != 10 && c != -1) {
            lineBuilder.append((char)c);
            c = this.readCursor.at(++lineOffset);
        }
        lineBuilder.append('\n').append(ptr);
        return lineBuilder.toString();
    }

    @Override
    public InputStream getRemainingAsStream() {
        int c;
        ByteList buf = new ByteList(128);
        while ((c = this.read()) != -1) {
            buf.append(c);
        }
        return new ByteArrayInputStream(buf.getUnsafeBytes(), 0, buf.length());
    }

    private int forward(int c) {
        if (c != -1) {
            ++this.offset;
            switch (c) {
                case 10: {
                    ++this.line;
                    break;
                }
                case 13: {
                    c = this.read();
                    if (c != 10) {
                        this.unread(c);
                        c = 10;
                        break;
                    }
                    if (!this.captureSource) break;
                    this.uncaptureFeature(c);
                    this.captureFeature(13);
                }
            }
        }
        if (this.captureSource) {
            this.captureFeature(c);
        }
        return c;
    }

    private void backward(int c) {
        --this.offset;
        if (c == 10) {
            --this.line;
            if (this.readCursor.at(-1) == 13) {
                this.unread(13);
            }
        }
    }

    class PushbackCursor
    implements Cursor {
        private final Cursor parent;
        private final ByteList region;

        public PushbackCursor(Cursor prev, ByteList region) {
            this.parent = prev;
            this.region = region;
        }

        public int read() {
            int index2 = this.region.length() - 1;
            if (index2 < 0) {
                ByteArrayLexerSource.this.readCursor = this.parent;
                return this.parent.read();
            }
            int c = 0xFF & this.region.get(index2);
            this.region.setRealSize(index2);
            return ByteArrayLexerSource.this.forward(c);
        }

        public void unread(int c) {
            this.region.append(c);
            ByteArrayLexerSource.this.backward(c);
        }

        public int at(int offset2) {
            if (offset2 < 0) {
                return this.parent.at(offset2);
            }
            if (offset2 >= this.region.length()) {
                return this.parent.at(offset2 - this.region.length());
            }
            return 0xFF & this.region.get(this.region.length() - offset2 - 1);
        }
    }

    class ByteArrayCursor
    implements Cursor {
        private final byte[] region;
        private int index;

        public ByteArrayCursor(byte[] region) {
            this.region = region;
            this.index = 0;
        }

        public int read() {
            if (this.index >= this.region.length) {
                return ByteArrayLexerSource.this.forward(-1);
            }
            return 0xFF & ByteArrayLexerSource.this.forward(this.region[this.index++]);
        }

        public void unread(int c) {
            if (this.index > 0 && this.region[this.index - 1] == c) {
                --this.index;
                ByteArrayLexerSource.this.backward(c);
            } else {
                ByteArrayLexerSource.this.readCursor = ByteArrayLexerSource.this.pushbackCursor;
                ByteArrayLexerSource.this.pushbackCursor.unread(c);
            }
        }

        public int at(int offset2) {
            int location = this.index + offset2;
            if (location >= this.region.length || location < 0) {
                return -1;
            }
            return 0xFF & this.region[location];
        }
    }

    static interface Cursor {
        public int read();

        public void unread(int var1);

        public int at(int var1);
    }
}

