/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.ArrayList;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.ast.InvisibleNode;
import org.jruby.ast.NodeType;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.ISourcePositionHolder;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Node
implements ISourcePositionHolder {
    static final List<Node> EMPTY_LIST = new ArrayList<Node>();
    private ISourcePosition position;

    public Node(ISourcePosition position) {
        assert (position != null);
        this.position = position;
    }

    @Override
    public ISourcePosition getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(ISourcePosition position) {
        this.position = position;
    }

    public abstract Object accept(NodeVisitor var1);

    public abstract List<Node> childNodes();

    protected static List<Node> createList(Node ... nodes) {
        ArrayList<Node> list2 = new ArrayList<Node>();
        for (Node node : nodes) {
            if (node == null) continue;
            list2.add(node);
        }
        return list2;
    }

    public String toString() {
        if (this instanceof InvisibleNode) {
            return "";
        }
        StringBuilder builder = new StringBuilder(60);
        builder.append("(").append(this.getNodeName());
        if (this instanceof INameNode) {
            builder.append(":").append(((INameNode)((Object)this)).getName());
        }
        builder.append(" ").append(this.getPosition().getStartLine());
        for (Node child : this.childNodes()) {
            builder.append(", ").append(child);
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getNodeName() {
        String name2 = this.getClass().getName();
        int i2 = name2.lastIndexOf(46);
        String nodeType = name2.substring(i2 + 1);
        return nodeType;
    }

    public boolean isInvisible() {
        return this instanceof InvisibleNode;
    }

    public IRubyObject interpret(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        throw new RuntimeException(this.getClass().getSimpleName() + " should not be directly interpreted");
    }

    public IRubyObject assign(Ruby runtime2, ThreadContext context, IRubyObject self, IRubyObject value2, Block block, boolean checkArity) {
        throw new RuntimeException("Invalid node encountered in interpreter: \"" + this.getClass().getName() + "\", please report this at www.jruby.org");
    }

    public String definition(Ruby runtime2, ThreadContext context, IRubyObject self, Block aBlock) {
        try {
            this.interpret(runtime2, context, self, aBlock);
            return "expression";
        }
        catch (JumpException jumpExcptn) {
            return null;
        }
    }

    public abstract NodeType getNodeType();
}

