/*
 * Decompiled with CFR 0.152.
 */
package org.yecht.ruby;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyEnumerable;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;
import org.yecht.Data;
import org.yecht.ImplicitScanner2;
import org.yecht.Node;
import org.yecht.Pointer;
import org.yecht.ScalarStyle;
import org.yecht.ruby.ArrayStorageLink;
import org.yecht.ruby.HashStorageLink;
import org.yecht.ruby.PossibleLinkNode;
import org.yecht.ruby.YAMLExtra;

public class DefaultResolver {
    private static Map<String, ObjectCreator> scalarTypes = new HashMap<String, ObjectCreator>();

    private static int extractInt(byte[] buff, int p2, int pend) {
        int len = 0;
        while (p2 + len < pend && Character.isDigit((char)buff[p2 + len])) {
            ++len;
        }
        try {
            return Integer.parseInt(new String(buff, p2, len, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
    }

    public static IRubyObject makeTime(Ruby runtime2, Pointer str, int len) {
        int ptr = str.start;
        int pend = ptr + len;
        RubyFixnum year2 = runtime2.newFixnum(0);
        RubyFixnum mon = runtime2.newFixnum(0);
        RubyFixnum day = runtime2.newFixnum(0);
        RubyFixnum hour2 = runtime2.newFixnum(0);
        RubyFixnum min2 = runtime2.newFixnum(0);
        RubyFixnum sec2 = runtime2.newFixnum(0);
        long usec2 = 0L;
        if (str.buffer[ptr] != 0 && ptr < pend) {
            year2 = runtime2.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 4] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            mon = runtime2.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            day = runtime2.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            hour2 = runtime2.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            min2 = runtime2.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if (str.buffer[ptr += 2] != 0 && ptr < pend) {
            while (!Character.isDigit((char)str.buffer[ptr]) && ptr < pend) {
                ++ptr;
            }
            sec2 = runtime2.newFixnum(DefaultResolver.extractInt(str.buffer, ptr, pend));
        }
        if ((ptr += 2) < pend && str.buffer[ptr] == 46) {
            int end2;
            for (end2 = ptr + 1; Character.isDigit((char)str.buffer[end2]) && end2 < pend; ++end2) {
            }
            byte[] padded = new byte[]{48, 48, 48, 48, 48, 48};
            System.arraycopy(str.buffer, ptr + 1, padded, 0, end2 - (ptr + 1));
            try {
                usec2 = Long.parseLong(new String(padded, 0, 6, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            usec2 = 0L;
        }
        while (ptr < pend && str.buffer[ptr] != 90 && str.buffer[ptr] != 43 && str.buffer[ptr] != 45 && str.buffer[ptr] != 0) {
            ++ptr;
        }
        if (ptr < pend && (str.buffer[ptr] == 45 || str.buffer[ptr] == 43)) {
            int lenx = 1;
            while (ptr + lenx < pend && Character.isDigit((char)str.buffer[ptr + lenx])) {
                ++lenx;
            }
            if (str.buffer[ptr] == 43) {
                ++ptr;
                --lenx;
            }
            try {
                long tz_offset = Long.parseLong(new String(str.buffer, ptr, lenx, "ISO-8859-1")) * 3600L;
                ptr += lenx;
                while (ptr < pend && str.buffer[ptr] != 58 && str.buffer[ptr] != 0) {
                    ++ptr;
                }
                if (ptr < pend && str.buffer[ptr] == 58) {
                    tz_offset = tz_offset < 0L ? (tz_offset -= (long)(DefaultResolver.extractInt(str.buffer, ptr, pend) * 60)) : (tz_offset += (long)(DefaultResolver.extractInt(str.buffer, ++ptr, pend) * 60));
                }
                IRubyObject time = runtime2.getClass("Time").callMethod(runtime2.getCurrentContext(), "utc", new IRubyObject[]{year2, mon, day, hour2, min2, sec2});
                long tmp = RubyNumeric.num2long(time.callMethod(runtime2.getCurrentContext(), "to_i")) - tz_offset;
                return runtime2.getClass("Time").callMethod(runtime2.getCurrentContext(), "at", new IRubyObject[]{runtime2.newFixnum(tmp), runtime2.newFixnum(usec2)});
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            return runtime2.getClass("Time").callMethod(runtime2.getCurrentContext(), "utc", new IRubyObject[]{year2, mon, day, hour2, min2, sec2, runtime2.newFixnum(usec2)});
        }
        System.err.println("oopsie, returning null");
        return null;
    }

    private static boolean handleScalar(Ruby runtime2, Node n, String type_id, IRubyObject[] ref, YAMLExtra x) throws UnsupportedEncodingException {
        Data.Str ds = (Data.Str)n.data;
        ThreadContext ctx = runtime2.getCurrentContext();
        boolean transferred = true;
        IRubyObject obj = null;
        if (type_id == null) {
            obj = RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len);
        } else if (ds.style == ScalarStyle.Plain && ds.len > 1 && ds.ptr.buffer[ds.ptr.start] == 58) {
            obj = x.DefaultResolver.callMethod(ctx, "transfer", new IRubyObject[]{runtime2.newString("tag:ruby.yaml.org,2002:sym"), RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start + 1, ds.len - 1)});
        } else {
            ObjectCreator oc = scalarTypes.get(type_id);
            if (oc != null) {
                obj = oc.create(runtime2, n, ds);
            } else if (type_id.startsWith("int")) {
                n.strBlowAwayCommas();
                obj = RubyNumeric.str2inum(runtime2, RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len), 10, true);
            } else if (type_id.startsWith("float")) {
                n.strBlowAwayCommas();
                obj = RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len);
                obj = obj.callMethod(ctx, "to_f");
            } else if (type_id.startsWith("timestamp")) {
                obj = DefaultResolver.makeTime(runtime2, ds.ptr, ds.len);
            } else if (type_id.startsWith("merge")) {
                obj = x.MergeKey.callMethod(ctx, "new");
            } else if (type_id.startsWith("default")) {
                obj = x.DefaultKey.callMethod(ctx, "new");
            } else {
                transferred = false;
                obj = RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len);
            }
        }
        ref[0] = obj;
        return transferred;
    }

    public static boolean handleSeq(Ruby runtime2, Node n, String type_id, IRubyObject[] ref) {
        boolean transferred = type_id == null || "seq".equals(type_id);
        Data.Seq dl = (Data.Seq)n.data;
        Object[] items = dl.items;
        RubyArray obj = RubyArray.newArray(runtime2, dl.idx);
        for (int i2 = 0; i2 < dl.idx; ++i2) {
            IRubyObject _obj = (IRubyObject)items[i2];
            if (_obj instanceof PossibleLinkNode) {
                ((PossibleLinkNode)((Object)_obj)).addLink(new ArrayStorageLink(obj, i2, _obj));
            }
            obj.store(i2, _obj);
        }
        ref[0] = obj;
        return transferred;
    }

    public static boolean handleMap(final Ruby runtime2, Node n, String type_id, IRubyObject[] ref, YAMLExtra x) {
        boolean transferred = type_id == null || "map".equals(type_id);
        ThreadContext ctx = runtime2.getCurrentContext();
        Data.Map dm = (Data.Map)n.data;
        Object[] keys2 = dm.keys;
        Object[] vals = dm.values;
        RubyHash obj = RubyHash.newHash(runtime2);
        RubyClass cMergeKey = x.MergeKey;
        RubyClass cDefaultKey = x.DefaultKey;
        for (int i2 = 0; i2 < dm.idx; ++i2) {
            IRubyObject k = (IRubyObject)keys2[i2];
            IRubyObject v = (IRubyObject)vals[i2];
            if (null == v) {
                v = runtime2.getNil();
            }
            boolean skip_aset = false;
            if (cMergeKey.isInstance(k)) {
                IRubyObject tmp = null;
                tmp = TypeConverter.convertToTypeWithCheck(v, runtime2.getHash(), "to_hash");
                if (!tmp.isNil()) {
                    RubyHash dup2 = (RubyHash)v.callMethod(ctx, "dup");
                    dup2.callMethod(ctx, "update", (IRubyObject)obj);
                    obj = dup2;
                    skip_aset = true;
                } else {
                    IRubyObject end2;
                    IRubyObject tmph;
                    tmp = v.checkArrayType();
                    if (!tmp.isNil() && !(tmph = TypeConverter.convertToTypeWithCheck(end2 = ((RubyArray)tmp).pop(ctx), runtime2.getHash(), "to_hash")).isNil()) {
                        final RubyHash dup3 = (RubyHash)tmph.callMethod(ctx, "dup");
                        tmp = ((RubyArray)tmp).reverse();
                        ((RubyArray)tmp).append(obj);
                        RubyEnumerable.callEach(runtime2, ctx, tmp, new BlockCallback(){

                            public IRubyObject call(ThreadContext _ctx, IRubyObject[] largs, Block blk) {
                                IRubyObject entry = largs[0];
                                IRubyObject tmp = null;
                                tmp = TypeConverter.convertToTypeWithCheck(entry, runtime2.getHash(), "to_hash");
                                if (!tmp.isNil()) {
                                    dup3.callMethod(_ctx, "update", tmp);
                                }
                                return runtime2.getNil();
                            }
                        });
                        obj = dup3;
                        skip_aset = true;
                    }
                }
            } else if (cDefaultKey.isInstance(k)) {
                obj.callMethod(ctx, "default=", v);
                skip_aset = true;
            }
            if (skip_aset) continue;
            if (v instanceof PossibleLinkNode) {
                ((PossibleLinkNode)((Object)v)).addLink(new HashStorageLink(obj, k, v));
            }
            obj.fastASet(k, v);
        }
        ref[0] = obj;
        return transferred;
    }

    public static boolean orgHandler(IRubyObject self, Node n, IRubyObject[] ref, YAMLExtra x) {
        Ruby runtime2 = self.getRuntime();
        String type_id = n.type_id;
        boolean transferred = false;
        if (type_id != null && type_id.startsWith("tag:yaml.org,2002:")) {
            type_id = type_id.substring(18);
        }
        try {
            switch (n.kind) {
                case Str: {
                    transferred = DefaultResolver.handleScalar(runtime2, n, type_id, ref, x);
                    break;
                }
                case Seq: {
                    transferred = DefaultResolver.handleSeq(runtime2, n, type_id, ref);
                    break;
                }
                case Map: {
                    transferred = DefaultResolver.handleMap(runtime2, n, type_id, ref, x);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return transferred;
    }

    @JRubyMethod
    public static IRubyObject node_import(IRubyObject self, IRubyObject node) {
        Node n = (Node)node.dataGetStructChecked();
        IRubyObject[] _obj = new IRubyObject[]{null};
        if (!DefaultResolver.orgHandler(self, n, _obj, ((org.yecht.ruby.Node)node).x)) {
            _obj[0] = self.callMethod(self.getRuntime().getCurrentContext(), "transfer", new IRubyObject[]{self.getRuntime().newString(n.type_id), _obj[0]});
        }
        return _obj[0];
    }

    @JRubyMethod
    public static IRubyObject detect_implicit(IRubyObject self, IRubyObject val) {
        IRubyObject tmp = TypeConverter.convertToTypeWithCheck(val, self.getRuntime().getString(), "to_str");
        if (!tmp.isNil()) {
            ByteList bl = ((RubyString)tmp).getByteList();
            String type_id = ImplicitScanner2.matchImplicit(Pointer.create(bl.bytes, bl.begin), bl.realSize);
            return self.getRuntime().newString(type_id);
        }
        return RubyString.newEmptyString(self.getRuntime());
    }

    static {
        scalarTypes.put("null", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return runtime2.getNil();
            }
        });
        scalarTypes.put("binary", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                ThreadContext ctx = runtime2.getCurrentContext();
                RubyString obj = RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len);
                obj.callMethod(ctx, "tr!", new IRubyObject[]{runtime2.newString("\n\t "), runtime2.newString("")});
                IRubyObject arr = obj.callMethod(ctx, "unpack", (IRubyObject)runtime2.newString("m"));
                return ((RubyArray)arr).shift(ctx);
            }
        });
        scalarTypes.put("bool#yes", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return runtime2.getTrue();
            }
        });
        scalarTypes.put("bool#no", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return runtime2.getFalse();
            }
        });
        scalarTypes.put("int#hex", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                n.strBlowAwayCommas();
                return RubyNumeric.str2inum(runtime2, RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len), 16, true);
            }
        });
        scalarTypes.put("int#oct", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                n.strBlowAwayCommas();
                return RubyNumeric.str2inum(runtime2, RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len), 8, true);
            }
        });
        scalarTypes.put("int#base60", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) throws UnsupportedEncodingException {
                long sixty = 1L;
                long total2 = 0L;
                n.strBlowAwayCommas();
                int ptr = ds.ptr.start;
                int end2 = ptr + ds.len;
                while (end2 > ptr) {
                    int colon;
                    long bnum = 0L;
                    for (colon = end2 - 1; colon >= ptr && ds.ptr.buffer[colon] != 58; --colon) {
                    }
                    bnum = Integer.parseInt(new String(ds.ptr.buffer, colon + 1, end2 - (colon + 1), "ISO-8859-1"));
                    total2 += bnum * sixty;
                    sixty *= 60L;
                    end2 = colon;
                }
                return runtime2.newFixnum(total2);
            }
        });
        scalarTypes.put("float#base60", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) throws UnsupportedEncodingException {
                long sixty = 1L;
                double total2 = 0.0;
                n.strBlowAwayCommas();
                int ptr = ds.ptr.start;
                int end2 = ptr + ds.len;
                while (end2 > ptr) {
                    int colon;
                    double bnum = 0.0;
                    for (colon = end2 - 1; colon >= ptr && ds.ptr.buffer[colon] != 58; --colon) {
                    }
                    bnum = Double.parseDouble(new String(ds.ptr.buffer, colon + 1, end2 - (colon + 1), "ISO-8859-1"));
                    total2 += bnum * (double)sixty;
                    sixty *= 60L;
                    end2 = colon;
                }
                return runtime2.newFloat(total2);
            }
        });
        scalarTypes.put("float#nan", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return runtime2.newFloat(Double.NaN);
            }
        });
        scalarTypes.put("float#inf", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return runtime2.newFloat(Double.POSITIVE_INFINITY);
            }
        });
        scalarTypes.put("float#neginf", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return runtime2.newFloat(Double.NEGATIVE_INFINITY);
            }
        });
        scalarTypes.put("timestamp#iso8601", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return DefaultResolver.makeTime(runtime2, ds.ptr, ds.len);
            }
        });
        scalarTypes.put("timestamp#spaced", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return DefaultResolver.makeTime(runtime2, ds.ptr, ds.len);
            }
        });
        scalarTypes.put("timestamp#ymd", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) throws UnsupportedEncodingException {
                RubyFixnum year2 = runtime2.newFixnum(Integer.parseInt(new String(ds.ptr.buffer, 0, 4, "ISO-8859-1")));
                RubyFixnum mon = runtime2.newFixnum(Integer.parseInt(new String(ds.ptr.buffer, 5, 2, "ISO-8859-1")));
                RubyFixnum day = runtime2.newFixnum(Integer.parseInt(new String(ds.ptr.buffer, 8, 2, "ISO-8859-1")));
                RubyKernel.require(runtime2.getTopSelf(), runtime2.newString("date"), Block.NULL_BLOCK);
                return runtime2.getClass("Date").callMethod(runtime2.getCurrentContext(), "new", new IRubyObject[]{year2, mon, day});
            }
        });
        scalarTypes.put("str", new ObjectCreator(){

            public IRubyObject create(Ruby runtime2, Node n, Data.Str ds) {
                return RubyString.newStringShared(runtime2, ds.ptr.buffer, ds.ptr.start, ds.len);
            }
        });
    }

    private static interface ObjectCreator {
        public IRubyObject create(Ruby var1, Node var2, Data.Str var3) throws UnsupportedEncodingException;
    }
}

