/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.posix;

import com.kenai.constantine.platform.Errno;
import com.kenai.constantine.platform.windows.LastError;
import java.io.File;
import java.io.FileDescriptor;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.jruby.ext.posix.BaseHeapFileStat;
import org.jruby.ext.posix.BaseNativePOSIX;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.FileTime;
import org.jruby.ext.posix.Group;
import org.jruby.ext.posix.LibCProvider;
import org.jruby.ext.posix.POSIXHandler;
import org.jruby.ext.posix.Passwd;
import org.jruby.ext.posix.WindowsFileStat;
import org.jruby.ext.posix.WindowsLibC;

final class WindowsPOSIX
extends BaseNativePOSIX {
    private static final int FILE_TYPE_CHAR = 2;
    private static final Map<Integer, Errno> errorToErrnoMapper = new HashMap<Integer, Errno>();
    private static final int INVALID_HANDLE_VALUE = -1;
    private static final int GENERIC_ALL = 0x10000000;
    private static final int GENERIC_READ = Integer.MIN_VALUE;
    private static final int GENERIC_WRITE = 0x40000000;
    private static final int GENERIC_EXECUTE = 0x2000000;
    private static final int FILE_SHARE_DELETE = 4;
    private static final int FILE_SHARE_READ = 1;
    private static final int FILE_SHARE_WRITE = 2;
    private static final int CREATE_ALWAYS = 2;
    private static final int CREATE_NEW = 1;
    private static final int OPEN_ALWAYS = 4;
    private static final int OPEN_EXISTING = 3;
    private static final int TRUNCATE_EXISTING = 5;
    public static final int FILE_FLAG_BACKUP_SEMANTICS = 0x2000000;

    WindowsPOSIX(String libraryName, LibCProvider libc, POSIXHandler handler) {
        super(libraryName, libc, handler);
    }

    public BaseHeapFileStat allocateStat() {
        return new WindowsFileStat(this);
    }

    public int kill(int pid2, int signal2) {
        this.handler.unimplementedError("kill");
        return -1;
    }

    public int chown(String filename2, int user, int group2) {
        return 0;
    }

    public int getegid() {
        this.handler.unimplementedError("egid");
        return -1;
    }

    public int setegid(int egid2) {
        this.handler.unimplementedError("setegid");
        return -1;
    }

    public int geteuid() {
        return 0;
    }

    public int seteuid(int euid2) {
        this.handler.unimplementedError("seteuid");
        return -1;
    }

    public int getuid() {
        return 0;
    }

    public int setuid(int uid2) {
        this.handler.unimplementedError("setuid");
        return -1;
    }

    public int getgid() {
        this.handler.unimplementedError("getgid");
        return -1;
    }

    public int setgid(int gid2) {
        this.handler.unimplementedError("setgid");
        return -1;
    }

    public int getpgid(int pid2) {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int getpgid() {
        this.handler.unimplementedError("getpgid");
        return -1;
    }

    public int setpgid(int pid2, int pgid) {
        this.handler.unimplementedError("setpgid");
        return -1;
    }

    public int getpriority(int which, int who) {
        this.handler.unimplementedError("getpriority");
        return -1;
    }

    public int setpriority(int which, int who, int prio) {
        this.handler.unimplementedError("setpriority");
        return -1;
    }

    public int getppid() {
        return 0;
    }

    public int lchmod(String filename2, int mode2) {
        this.handler.unimplementedError("lchmod");
        return -1;
    }

    public int lchown(String filename2, int user, int group2) {
        this.handler.unimplementedError("lchown");
        return -1;
    }

    public FileStat lstat(String path2) {
        return this.stat(path2);
    }

    public String readlink(String oldpath) {
        this.handler.unimplementedError("readlink");
        return null;
    }

    public int utimes(String path2, long[] atimeval, long[] mtimeval) {
        int handle;
        FileTime mTime;
        WindowsLibC libc = (WindowsLibC)this.libc();
        byte[] wpath = WindowsPOSIX.toWPath(path2);
        FileTime aTime = atimeval == null ? null : this.unixTimeToFileTime(atimeval[0]);
        FileTime fileTime = mTime = mtimeval == null ? null : this.unixTimeToFileTime(mtimeval[0]);
        if (aTime == null || mTime == null) {
            FileTime nowFile = this.unixTimeToFileTime(System.currentTimeMillis() / 1000L);
            if (aTime == null) {
                aTime = nowFile;
            }
            if (mTime == null) {
                mTime = nowFile;
            }
        }
        if ((handle = libc.CreateFileW(wpath, 0x40000000, 3, null, 3, 0x2000000, 0)) == -1) {
            return -1;
        }
        boolean timeSet = libc.SetFileTime(handle, null, aTime, mTime);
        libc.CloseHandle(handle);
        return timeSet ? 0 : -1;
    }

    private FileTime unixTimeToFileTime(long unixTime) {
        long ft = (unixTime + 11644473600L) * 10000000L;
        FileTime fileTime = new FileTime();
        fileTime.dwLowDateTime.set(ft & 0xFFFFFFFFL);
        fileTime.dwHighDateTime.set(ft >> 32 & 0xFFFFFFFFL);
        return fileTime;
    }

    public int wait(int[] status2) {
        this.handler.unimplementedError("wait");
        return -1;
    }

    public int waitpid(int pid2, int[] status2, int flags) {
        this.handler.unimplementedError("waitpid");
        return -1;
    }

    public String getlogin() {
        return this.helper.getlogin();
    }

    public int endgrent() {
        return 0;
    }

    public int endpwent() {
        return this.helper.endpwent();
    }

    public Group getgrent() {
        return null;
    }

    public Passwd getpwent() {
        return null;
    }

    public Group getgrgid(int which) {
        return null;
    }

    public Passwd getpwnam(String which) {
        return null;
    }

    public Group getgrnam(String which) {
        return null;
    }

    public int setgrent() {
        return 0;
    }

    public int setpwent() {
        return this.helper.setpwent();
    }

    public Passwd getpwuid(int which) {
        return null;
    }

    public boolean isatty(FileDescriptor fd) {
        int handle = (int)this.helper.gethandle(fd);
        int type2 = ((WindowsLibC)this.libc()).GetFileType(handle);
        return type2 == 2;
    }

    public int mkdir(String path2, int mode2) {
        byte[] widePath = WindowsPOSIX.toWPath(path2);
        int res = ((WindowsLibC)this.libc())._wmkdir(widePath);
        if (res < 0) {
            int error2 = this.errno();
            this.handler.error(WindowsPOSIX.mapErrorToErrno(error2), path2);
        }
        return res;
    }

    public int link(String oldpath, String newpath) {
        byte[] oldWPath = WindowsPOSIX.toWPath(oldpath);
        byte[] newWPath = WindowsPOSIX.toWPath(newpath);
        boolean linkCreated = ((WindowsLibC)this.libc()).CreateHardLinkW(newWPath, oldWPath, null);
        if (!linkCreated) {
            int error2 = this.errno();
            this.handler.error(WindowsPOSIX.mapErrorToErrno(error2), oldpath + " or " + newpath);
            return error2;
        }
        return 0;
    }

    private static Errno mapErrorToErrno(int error2) {
        Errno errno2 = errorToErrnoMapper.get(error2);
        if (errno2 == null) {
            errno2 = Errno.__UNKNOWN_CONSTANT__;
        }
        return errno2;
    }

    private static byte[] toWPath(String path2) {
        boolean absolute = new File(path2).isAbsolute();
        if (absolute) {
            path2 = "//?/" + path2;
        }
        return WindowsPOSIX.toWString(path2);
    }

    private static byte[] toWString(String string2) {
        string2 = string2 + '\u0000';
        try {
            return string2.getBytes("UTF-16LE");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    static {
        errorToErrnoMapper.put(LastError.ERROR_INVALID_FUNCTION.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_FILE_NOT_FOUND.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_PATH_NOT_FOUND.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_TOO_MANY_OPEN_FILES.value(), Errno.EMFILE);
        errorToErrnoMapper.put(LastError.ERROR_ACCESS_DENIED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_HANDLE.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.ERROR_ARENA_TRASHED.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_NOT_ENOUGH_MEMORY.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_BLOCK.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_BAD_ENVIRONMENT.value(), Errno.E2BIG);
        errorToErrnoMapper.put(LastError.ERROR_BAD_FORMAT.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_ACCESS.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_DATA.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_DRIVE.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_CURRENT_DIRECTORY.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_NOT_SAME_DEVICE.value(), Errno.EXDEV);
        errorToErrnoMapper.put(LastError.ERROR_NO_MORE_FILES.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_WRITE_PROTECT.value(), Errno.EROFS);
        errorToErrnoMapper.put(LastError.ERROR_BAD_UNIT.value(), Errno.ENODEV);
        errorToErrnoMapper.put(LastError.ERROR_NOT_READY.value(), Errno.ENXIO);
        errorToErrnoMapper.put(LastError.ERROR_BAD_COMMAND.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_CRC.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_LENGTH.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SEEK.value(), Errno.EIO);
        errorToErrnoMapper.put(LastError.ERROR_NOT_DOS_DISK.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SECTOR_NOT_FOUND.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_OUT_OF_PAPER.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_WRITE_FAULT.value(), Errno.EIO);
        errorToErrnoMapper.put(LastError.ERROR_READ_FAULT.value(), Errno.EIO);
        errorToErrnoMapper.put(LastError.ERROR_GEN_FAILURE.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_LOCK_VIOLATION.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SHARING_VIOLATION.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_WRONG_DISK.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_SHARING_BUFFER_EXCEEDED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_NETPATH.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_NETWORK_ACCESS_DENIED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_NET_NAME.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_FILE_EXISTS.value(), Errno.EEXIST);
        errorToErrnoMapper.put(LastError.ERROR_CANNOT_MAKE.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_FAIL_I24.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_PARAMETER.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_NO_PROC_SLOTS.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(LastError.ERROR_DRIVE_LOCKED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BROKEN_PIPE.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_DISK_FULL.value(), Errno.ENOSPC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_TARGET_HANDLE.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_HANDLE.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_WAIT_NO_CHILDREN.value(), Errno.ECHILD);
        errorToErrnoMapper.put(LastError.ERROR_CHILD_NOT_COMPLETE.value(), Errno.ECHILD);
        errorToErrnoMapper.put(LastError.ERROR_DIRECT_ACCESS_HANDLE.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.ERROR_NEGATIVE_SEEK.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.ERROR_SEEK_ON_DEVICE.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_DIR_NOT_EMPTY.value(), Errno.ENOTEMPTY);
        errorToErrnoMapper.put(LastError.ERROR_DIRECTORY.value(), Errno.ENOTDIR);
        errorToErrnoMapper.put(LastError.ERROR_NOT_LOCKED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_BAD_PATHNAME.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_MAX_THRDS_REACHED.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(LastError.ERROR_LOCK_FAILED.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.ERROR_ALREADY_EXISTS.value(), Errno.EEXIST);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_STARTING_CODESEG.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_STACKSEG.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_MODULETYPE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_EXE_SIGNATURE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_EXE_MARKED_INVALID.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_BAD_EXE_FORMAT.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_ITERATED_DATA_EXCEEDS_64k.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_MINALLOCSIZE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_DYNLINK_FROM_INVALID_RING.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_IOPL_NOT_ENABLED.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INVALID_SEGDPL.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_AUTODATASEG_EXCEEDS_64k.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_RING2SEG_MUST_BE_MOVABLE.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_RELOC_CHAIN_XEEDS_SEGLIM.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_INFLOOP_IN_RELOC_CHAIN.value(), Errno.ENOEXEC);
        errorToErrnoMapper.put(LastError.ERROR_FILENAME_EXCED_RANGE.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.ERROR_NESTING_NOT_ALLOWED.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(229, Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_BAD_PIPE.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_PIPE_BUSY.value(), Errno.EAGAIN);
        errorToErrnoMapper.put(LastError.ERROR_NO_DATA.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_PIPE_NOT_CONNECTED.value(), Errno.EPIPE);
        errorToErrnoMapper.put(LastError.ERROR_OPERATION_ABORTED.value(), Errno.EINTR);
        errorToErrnoMapper.put(LastError.ERROR_NOT_ENOUGH_QUOTA.value(), Errno.ENOMEM);
        errorToErrnoMapper.put(LastError.ERROR_MOD_NOT_FOUND.value(), Errno.ENOENT);
        errorToErrnoMapper.put(LastError.WSAENAMETOOLONG.value(), Errno.ENAMETOOLONG);
        errorToErrnoMapper.put(LastError.WSAENOTEMPTY.value(), Errno.ENOTEMPTY);
        errorToErrnoMapper.put(LastError.WSAEINTR.value(), Errno.EINTR);
        errorToErrnoMapper.put(LastError.WSAEBADF.value(), Errno.EBADF);
        errorToErrnoMapper.put(LastError.WSAEACCES.value(), Errno.EACCES);
        errorToErrnoMapper.put(LastError.WSAEFAULT.value(), Errno.EFAULT);
        errorToErrnoMapper.put(LastError.WSAEINVAL.value(), Errno.EINVAL);
        errorToErrnoMapper.put(LastError.WSAEMFILE.value(), Errno.EMFILE);
    }
}

