/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.ext.ffi.DirectMemoryIO;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.Platform;

public final class SwappedMemoryIO
implements MemoryIO,
DirectMemoryIO {
    protected static final int LONG_SIZE = Platform.getPlatform().longSize();
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize();
    private final Ruby runtime;
    private final MemoryIO io;

    SwappedMemoryIO(Ruby runtime2, MemoryIO io2) {
        this.runtime = runtime2;
        this.io = io2;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN) ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }

    public final long getAddress() {
        return this.io instanceof DirectMemoryIO ? ((DirectMemoryIO)this.io).getAddress() : 0L;
    }

    public SwappedMemoryIO slice(long offset2) {
        return offset2 == 0L ? this : new SwappedMemoryIO(this.runtime, this.io.slice(offset2));
    }

    public SwappedMemoryIO slice(long offset2, long size2) {
        return new SwappedMemoryIO(this.runtime, this.io.slice(offset2, size2));
    }

    public final ByteBuffer asByteBuffer() {
        return this.io.asByteBuffer().order(this.order());
    }

    Ruby getRuntime() {
        return this.runtime;
    }

    public final boolean equals(Object obj) {
        return obj == this || obj instanceof SwappedMemoryIO && ((SwappedMemoryIO)obj).io.equals(this.io);
    }

    public final int hashCode() {
        return this.io.hashCode();
    }

    public final boolean isNull() {
        return this.io.isNull();
    }

    public final boolean isDirect() {
        return this.io.isDirect();
    }

    public final byte getByte(long offset2) {
        return this.io.getByte(offset2);
    }

    public final short getShort(long offset2) {
        return Short.reverseBytes(this.io.getShort(offset2));
    }

    public final int getInt(long offset2) {
        return Integer.reverseBytes(this.io.getInt(offset2));
    }

    public final long getLong(long offset2) {
        return Long.reverseBytes(this.io.getLong(offset2));
    }

    public final long getNativeLong(long offset2) {
        return LONG_SIZE == 32 ? (long)this.getInt(offset2) : this.getLong(offset2);
    }

    public final float getFloat(long offset2) {
        return Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(this.io.getFloat(offset2))));
    }

    public final double getDouble(long offset2) {
        return Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(this.io.getDouble(offset2))));
    }

    public final long getAddress(long offset2) {
        throw this.runtime.newRuntimeError("cannot get native address values in non-native byte order memory");
    }

    public final DirectMemoryIO getMemoryIO(long offset2) {
        throw this.runtime.newRuntimeError("cannot get native address values in non-native byte order memory");
    }

    public final void putByte(long offset2, byte value2) {
        this.io.putByte(offset2, value2);
    }

    public final void putShort(long offset2, short value2) {
        this.io.putShort(offset2, Short.reverseBytes(value2));
    }

    public final void putInt(long offset2, int value2) {
        this.io.putInt(offset2, Integer.reverseBytes(value2));
    }

    public final void putLong(long offset2, long value2) {
        this.io.putLong(offset2, Long.reverseBytes(value2));
    }

    public final void putNativeLong(long offset2, long value2) {
        if (LONG_SIZE == 32) {
            this.putInt(offset2, (int)value2);
        } else {
            this.putLong(offset2, value2);
        }
    }

    public final void putAddress(long offset2, long value2) {
        throw this.runtime.newRuntimeError("cannot write native address values to non-native byte order memory");
    }

    public final void putFloat(long offset2, float value2) {
        this.io.putFloat(offset2, Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(value2))));
    }

    public final void putDouble(long offset2, double value2) {
        this.io.putDouble(offset2, Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(value2))));
    }

    public final void putMemoryIO(long offset2, MemoryIO value2) {
        throw this.runtime.newRuntimeError("cannot write native address values to non-native byte order memory");
    }

    public final void get(long offset2, byte[] dst, int off, int len) {
        this.io.get(offset2, dst, off, len);
    }

    public final void put(long offset2, byte[] src, int off, int len) {
        this.io.put(offset2, src, off, len);
    }

    public final void get(long offset2, short[] dst, int off, int len) {
        this.io.get(offset2, dst, off, len);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = Short.reverseBytes(dst[off + i2]);
        }
    }

    public final void put(long offset2, short[] src, int off, int len) {
        short[] values = new short[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = Short.reverseBytes(src[off + i2]);
        }
        this.io.put(offset2, values, 0, len);
    }

    public final void get(long offset2, int[] dst, int off, int len) {
        this.io.get(offset2, dst, off, len);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = Integer.reverseBytes(dst[off + i2]);
        }
    }

    public final void put(long offset2, int[] src, int off, int len) {
        int[] values = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = Integer.reverseBytes(src[off + i2]);
        }
        this.io.put(offset2, values, 0, len);
    }

    public final void get(long offset2, long[] dst, int off, int len) {
        this.io.get(offset2, dst, off, len);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = Long.reverseBytes(dst[off + i2]);
        }
    }

    public final void put(long offset2, long[] src, int off, int len) {
        long[] values = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = Long.reverseBytes(src[off + i2]);
        }
        this.io.put(offset2, values, 0, len);
    }

    public final void get(long offset2, float[] dst, int off, int len) {
        this.io.get(offset2, dst, off, len);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(dst[off + i2])));
        }
    }

    public final void put(long offset2, float[] src, int off, int len) {
        int[] values = new int[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = Integer.reverseBytes(Float.floatToRawIntBits(src[off + i2]));
        }
        this.io.put(offset2, values, 0, len);
    }

    public final void get(long offset2, double[] dst, int off, int len) {
        this.io.get(offset2, dst, off, len);
        for (int i2 = 0; i2 < len; ++i2) {
            dst[off + i2] = Double.longBitsToDouble(Long.reverseBytes(Double.doubleToRawLongBits(dst[off + i2])));
        }
    }

    public final void put(long offset2, double[] src, int off, int len) {
        long[] values = new long[len];
        for (int i2 = 0; i2 < len; ++i2) {
            values[i2] = Long.reverseBytes(Double.doubleToRawLongBits(src[off + i2]));
        }
        this.io.put(offset2, values, 0, len);
    }

    public final int indexOf(long offset2, byte value2) {
        return this.io.indexOf(offset2, value2);
    }

    public final int indexOf(long offset2, byte value2, int maxlen) {
        return this.io.indexOf(offset2, value2, maxlen);
    }

    public final void setMemory(long offset2, long size2, byte value2) {
        this.io.setMemory(offset2, size2, value2);
    }

    public final byte[] getZeroTerminatedByteArray(long offset2) {
        return this.io.getZeroTerminatedByteArray(offset2);
    }

    public final byte[] getZeroTerminatedByteArray(long offset2, int maxlen) {
        return this.io.getZeroTerminatedByteArray(offset2, maxlen);
    }

    public void putZeroTerminatedByteArray(long offset2, byte[] bytes2, int off, int len) {
        this.io.putZeroTerminatedByteArray(offset2, bytes2, off, len);
    }
}

