/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyInternalCallInstr
extends CallInstr {
    public RubyInternalCallInstr(Variable result, MethAddr methAddr, Operand receiver2, Operand[] args2) {
        super(Operation.RUBY_INTERNALS, result, methAddr, receiver2, args2, null);
    }

    public RubyInternalCallInstr(Variable result, MethAddr methAddr, Operand receiver2, Operand[] args2, Operand closure) {
        super(result, methAddr, receiver2, args2, closure);
    }

    public boolean isRubyInternalsCall() {
        return true;
    }

    public boolean isStaticCallTarget() {
        return true;
    }

    public IRMethod getTargetMethodWithReceiver(Operand receiver2) {
        return null;
    }

    public Instr cloneForInlining(InlinerInfo ii) {
        return new RubyInternalCallInstr(ii.getRenamedVariable(this.result), (MethAddr)this._methAddr.cloneForInlining(ii), this.getReceiver().cloneForInlining(ii), this.cloneCallArgs(ii), this._closure == null ? null : this._closure.cloneForInlining(ii));
    }

    public Label interpret(InterpreterContext interp, IRubyObject self) {
        if (this.getMethodAddr() == MethAddr.DEFINE_ALIAS) {
            Operand[] args2 = this.getCallArgs();
            RubyModule clazz = self instanceof RubyModule ? (RubyModule)self : self.getMetaClass();
            clazz.defineAlias(args2[0].retrieve(interp).toString(), args2[1].retrieve(interp).toString());
        } else {
            super.interpret(interp, self);
        }
        return null;
    }
}

