/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.instructions;

import java.util.Map;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.Interp;
import org.jruby.compiler.ir.Operation;
import org.jruby.compiler.ir.instructions.Instr;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFromBindingInstr
extends Instr {
    private IRMethod sourceMethod;
    private int bindingSlot;
    private String slotName;

    public LoadFromBindingInstr(Variable v, IRExecutionScope scope, String slotName) {
        super(Operation.BINDING_LOAD, v);
        this.slotName = slotName;
        this.sourceMethod = scope.getClosestMethodAncestor();
        this.bindingSlot = this.sourceMethod.assignBindingSlot(slotName);
    }

    public String getSlotName() {
        return this.slotName;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[0];
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap) {
    }

    @Override
    public String toString() {
        return "\t" + this.result + " = BINDING(" + this.sourceMethod + ")." + this.getSlotName();
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new LoadFromBindingInstr(ii.getRenamedVariable(this.result), this.sourceMethod, this.getSlotName());
    }

    @Override
    @Interp
    public Label interpret(InterpreterContext interp, IRubyObject self) {
        LocalVariable v = (LocalVariable)this.getResult();
        if (this.bindingSlot == -1) {
            this.bindingSlot = this.sourceMethod.getBindingSlot(this.getSlotName());
        }
        interp.setLocalVariable(v.getLocation(), interp.getSharedBindingVariable(this.bindingSlot));
        return null;
    }
}

