/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.operands.ClassMetaObject;
import org.jruby.compiler.ir.operands.ClosureMetaObject;
import org.jruby.compiler.ir.operands.MethodMetaObject;
import org.jruby.compiler.ir.operands.ModuleMetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.interpreter.InterpreterContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class MetaObject
extends Operand {
    public final IRScope scope;

    protected MetaObject(IRScope scope) {
        this.scope = scope;
    }

    public static MetaObject create(IRScope scope) {
        if (scope instanceof IRClass) {
            return new ClassMetaObject((IRClass)scope);
        }
        if (scope instanceof IRModule) {
            return new ModuleMetaObject((IRModule)scope);
        }
        if (scope instanceof IRMethod) {
            return new MethodMetaObject((IRMethod)scope);
        }
        if (scope instanceof IRClosure) {
            return new ClosureMetaObject((IRClosure)scope);
        }
        assert (false) : "IRSCript created";
        return new MetaObject(scope);
    }

    public String toString() {
        return this.scope.toString();
    }

    public boolean isConstant() {
        return true;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClosure() {
        return false;
    }

    public IRScope getScope() {
        return this.scope;
    }

    public Operand getNearestClass() {
        if (this.isClass()) {
            return this;
        }
        Operand parent = this.getContainer();
        while (parent instanceof MetaObject && !((MetaObject)parent).isClass()) {
            parent = ((MetaObject)parent).getContainer();
        }
        return parent;
    }

    public Operand getContainer() {
        return this.scope.getContainer();
    }

    public IRClass getTargetClass() {
        return this.scope instanceof IRModule ? IRClass.getCoreClass("Module") : null;
    }

    protected RubyModule interpretBody(InterpreterContext interp, ThreadContext context, RubyModule module) {
        this.scope.getStaticScope().setModule(module);
        IRMethod rootMethod = ((IRModule)this.scope).getRootMethod();
        InterpretedIRMethod method2 = new InterpretedIRMethod(rootMethod, module.getMetaClass());
        method2.call(context, (IRubyObject)module, (RubyModule)module.getMetaClass(), "", new IRubyObject[0]);
        return module;
    }

    protected RubyModule getContainer(InterpreterContext interp, Ruby runtime2) {
        return this.scope.getContainer() != null ? (RubyModule)this.scope.getContainer().retrieve(interp) : runtime2.getObject();
    }
}

