/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir.operands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.compiler.ir.representations.InlinerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BacktickString
extends Operand {
    public final List<Operand> _pieces;

    public BacktickString(Operand val) {
        this._pieces = new ArrayList<Operand>();
        this._pieces.add(val);
    }

    public BacktickString(List<Operand> pieces) {
        this._pieces = pieces;
    }

    @Override
    public boolean isConstant() {
        for (Operand o : this._pieces) {
            if (o.isConstant()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isNonAtomicValue() {
        return true;
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap) {
        int i2 = 0;
        for (Operand p2 : this._pieces) {
            this._pieces.set(i2, p2.getSimplifiedOperand(valueMap));
            ++i2;
        }
        return this;
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        for (Operand o : this._pieces) {
            o.addUsedVariables(l);
        }
    }

    @Override
    public Operand cloneForInlining(InlinerInfo ii) {
        if (this.isConstant()) {
            return this;
        }
        ArrayList<Operand> newPieces = new ArrayList<Operand>();
        for (Operand p2 : this._pieces) {
            newPieces.add(p2.cloneForInlining(ii));
        }
        return new BacktickString(newPieces);
    }
}

