/*
 * Decompiled with CFR 0.152.
 */
package jline;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import jline.SimpleCompletor;

public class ClassNameCompletor
extends SimpleCompletor {
    static /* synthetic */ Class class$jline$ClassNameCompletor;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ClassNameCompletor() throws IOException {
        this((SimpleCompletor.SimpleCompletorFilter)null);
    }

    public ClassNameCompletor(SimpleCompletor.SimpleCompletorFilter filter) throws IOException {
        super(ClassNameCompletor.getClassNames(), filter);
        this.setDelimiter(".");
    }

    public static String[] getClassNames() throws IOException {
        HashSet<URL> urls = new HashSet<URL>();
        for (ClassLoader loader = (class$jline$ClassNameCompletor == null ? (class$jline$ClassNameCompletor = ClassNameCompletor.class$("jline.ClassNameCompletor")) : class$jline$ClassNameCompletor).getClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            urls.addAll(Arrays.asList(((URLClassLoader)loader).getURLs()));
        }
        Class[] systemClasses = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ClassNameCompletor.class$("java.lang.String")) : class$java$lang$String, class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ClassNameCompletor.class$("javax.swing.JFrame")) : class$javax$swing$JFrame};
        for (int i2 = 0; i2 < systemClasses.length; ++i2) {
            URLConnection uc;
            URL classURL = systemClasses[i2].getResource("/" + systemClasses[i2].getName().replace('.', '/') + ".class");
            if (classURL == null || !((uc = classURL.openConnection()) instanceof JarURLConnection)) continue;
            urls.add(((JarURLConnection)uc).getJarFileURL());
        }
        HashSet<String> classes2 = new HashSet<String>();
        Iterator i3 = urls.iterator();
        while (i3.hasNext()) {
            URL url = (URL)i3.next();
            File file2 = new File(url.getFile());
            if (file2.isDirectory()) {
                Set files = ClassNameCompletor.getClassFiles(file2.getAbsolutePath(), new HashSet(), file2, new int[]{200});
                classes2.addAll(files);
                continue;
            }
            if (file2 == null || !file2.isFile()) continue;
            JarFile jf = new JarFile(file2);
            Enumeration<JarEntry> e = jf.entries();
            while (e.hasMoreElements()) {
                String name2;
                JarEntry entry = e.nextElement();
                if (entry == null || !(name2 = entry.getName()).endsWith(".class")) continue;
                classes2.add(name2);
            }
        }
        TreeSet<String> classNames = new TreeSet<String>();
        Iterator i4 = classes2.iterator();
        while (i4.hasNext()) {
            String name3 = (String)i4.next();
            classNames.add(name3.replace('/', '.').substring(0, name3.length() - 6));
        }
        return classNames.toArray(new String[classNames.size()]);
    }

    private static Set getClassFiles(String root, Set holder, File directory, int[] maxDirectories) {
        int n = maxDirectories[0];
        maxDirectories[0] = n - 1;
        if (n < 0) {
            return holder;
        }
        File[] files = directory.listFiles();
        for (int i2 = 0; files != null && i2 < files.length; ++i2) {
            String name2 = files[i2].getAbsolutePath();
            if (!name2.startsWith(root)) continue;
            if (files[i2].isDirectory()) {
                ClassNameCompletor.getClassFiles(root, holder, files[i2], maxDirectories);
                continue;
            }
            if (!files[i2].getName().endsWith(".class")) continue;
            holder.add(files[i2].getAbsolutePath().substring(root.length() + 1));
        }
        return holder;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

