/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.constructor;

import java.beans.IntrospectionException;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.yaml.snakeyaml.TypeDescription;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Construct;
import org.yaml.snakeyaml.constructor.ConstructorException;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Constructor
extends SafeConstructor {
    private final Map<Tag, Class<? extends Object>> typeTags;
    private final Map<Class<? extends Object>, TypeDescription> typeDefinitions;

    public Constructor() {
        this(Object.class);
    }

    public Constructor(Class<? extends Object> theRoot) {
        if (theRoot == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        this.yamlConstructors.put(null, new ConstructYamlObject());
        if (!Object.class.equals(theRoot)) {
            this.rootTag = new Tag(theRoot);
        }
        this.typeTags = new HashMap<Tag, Class<? extends Object>>();
        this.typeDefinitions = new HashMap<Class<? extends Object>, TypeDescription>();
        this.yamlClassConstructors.put(NodeId.scalar, new ConstructScalar());
        this.yamlClassConstructors.put(NodeId.mapping, new ConstructMapping());
        this.yamlClassConstructors.put(NodeId.sequence, new ConstructSequence());
    }

    public Constructor(String theRoot) throws ClassNotFoundException {
        this(Class.forName(Constructor.check(theRoot)));
    }

    private static final String check(String s) {
        if (s == null) {
            throw new NullPointerException("Root type must be provided.");
        }
        if (s.trim().length() == 0) {
            throw new YAMLException("Root type must be provided.");
        }
        return s;
    }

    public TypeDescription addTypeDescription(TypeDescription definition) {
        if (definition == null) {
            throw new NullPointerException("TypeDescription is required.");
        }
        if (this.rootTag == null && definition.isRoot()) {
            this.rootTag = new Tag(definition.getType());
        }
        Tag tag = definition.getTag();
        this.typeTags.put(tag, definition.getType());
        return this.typeDefinitions.put(definition.getType(), definition);
    }

    protected Class<?> getClassForNode(Node node) {
        Class<? extends Object> classForTag = this.typeTags.get(node.getTag());
        if (classForTag == null) {
            Class<?> cl;
            String name2 = node.getTag().getClassName();
            try {
                cl = this.getClassForName(name2);
            }
            catch (ClassNotFoundException e) {
                throw new YAMLException("Class not found: " + name2);
            }
            this.typeTags.put(node.getTag(), cl);
            return cl;
        }
        return classForTag;
    }

    protected Class<?> getClassForName(String name2) throws ClassNotFoundException {
        return Class.forName(name2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructSequence
    implements Construct {
        private ConstructSequence() {
        }

        @Override
        public Object construct(Node node) {
            SequenceNode snode = (SequenceNode)node;
            if (Set.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    throw new YAMLException("Set cannot be recursive.");
                }
                return Constructor.this.constructSet(snode);
            }
            if (Collection.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultList(snode.getValue().size());
                }
                return Constructor.this.constructSequence(snode);
            }
            if (node.getType().isArray()) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createArray(node.getType(), snode.getValue().size());
                }
                return Constructor.this.constructArray(snode);
            }
            ArrayList possibleConstructors = new ArrayList(snode.getValue().size());
            for (java.lang.reflect.Constructor<?> constructor2 : node.getType().getConstructors()) {
                if (snode.getValue().size() != constructor2.getParameterTypes().length) continue;
                possibleConstructors.add(constructor2);
            }
            if (!possibleConstructors.isEmpty()) {
                Object argumentList;
                if (possibleConstructors.size() == 1) {
                    argumentList = new Object[snode.getValue().size()];
                    java.lang.reflect.Constructor c = (java.lang.reflect.Constructor)possibleConstructors.get(0);
                    int index2 = 0;
                    for (Node node2 : snode.getValue()) {
                        Class<?> type2 = c.getParameterTypes()[index2];
                        node2.setType(type2);
                        argumentList[index2++] = Constructor.this.constructObject(node2);
                    }
                    try {
                        return c.newInstance((Object[])argumentList);
                    }
                    catch (Exception e) {
                        throw new YAMLException(e);
                    }
                }
                argumentList = Constructor.this.constructSequence(snode);
                Class[] parameterTypes = new Class[argumentList.size()];
                int index2 = 0;
                Iterator<Object> i$ = argumentList.iterator();
                while (i$.hasNext()) {
                    Object object = i$.next();
                    parameterTypes[index2] = object.getClass();
                    ++index2;
                }
                for (java.lang.reflect.Constructor constructor2 : possibleConstructors) {
                    Class<?>[] argTypes = constructor2.getParameterTypes();
                    boolean foundConstructor = true;
                    for (int i = 0; i < argTypes.length; ++i) {
                        if (this.wrapIfPrimitive(argTypes[i]).isAssignableFrom(parameterTypes[i])) continue;
                        foundConstructor = false;
                        break;
                    }
                    if (!foundConstructor) continue;
                    try {
                        return constructor2.newInstance(argumentList.toArray());
                    }
                    catch (Exception e) {
                        throw new YAMLException(e);
                    }
                }
            }
            throw new YAMLException("No suitable constructor with " + String.valueOf(snode.getValue().size()) + " arguments found for " + node.getType());
        }

        private final Class<? extends Object> wrapIfPrimitive(Class<?> clazz) {
            if (!clazz.isPrimitive()) {
                return clazz;
            }
            if (clazz == Integer.TYPE) {
                return Integer.class;
            }
            if (clazz == Float.TYPE) {
                return Float.class;
            }
            if (clazz == Double.TYPE) {
                return Double.class;
            }
            if (clazz == Boolean.TYPE) {
                return Boolean.class;
            }
            if (clazz == Long.TYPE) {
                return Long.class;
            }
            if (clazz == Character.TYPE) {
                return Character.class;
            }
            if (clazz == Short.TYPE) {
                return Short.class;
            }
            if (clazz == Byte.TYPE) {
                return Byte.class;
            }
            throw new YAMLException("Unexpected primitive " + clazz);
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            SequenceNode snode = (SequenceNode)node;
            if (List.class.isAssignableFrom(node.getType())) {
                List list2 = (List)object;
                Constructor.this.constructSequenceStep2(snode, list2);
            } else if (node.getType().isArray()) {
                Constructor.this.constructArrayStep2(snode, object);
            } else {
                throw new YAMLException("Immutable objects cannot be recursive.");
            }
        }
    }

    protected class ConstructScalar
    extends AbstractConstruct {
        protected ConstructScalar() {
        }

        public Object construct(Node nnode) {
            Object result;
            ScalarNode node = (ScalarNode)nnode;
            Class<? extends Object> type2 = node.getType();
            if (type2.isPrimitive() || type2 == String.class || Number.class.isAssignableFrom(type2) || type2 == Boolean.class || Date.class.isAssignableFrom(type2) || type2 == Character.class || type2 == BigInteger.class || type2 == BigDecimal.class || Enum.class.isAssignableFrom(type2) || Tag.BINARY.equals(node.getTag()) || Calendar.class.isAssignableFrom(type2)) {
                result = this.constructStandardJavaInstance(type2, node);
            } else {
                Object argument;
                java.lang.reflect.Constructor<?>[] javaConstructors = type2.getConstructors();
                int oneArgCount = 0;
                java.lang.reflect.Constructor<Object> javaConstructor = null;
                for (java.lang.reflect.Constructor<?> c : javaConstructors) {
                    if (c.getParameterTypes().length != 1) continue;
                    ++oneArgCount;
                    javaConstructor = c;
                }
                if (javaConstructor == null) {
                    throw new YAMLException("No single argument constructor found for " + type2);
                }
                if (oneArgCount == 1) {
                    argument = this.constructStandardJavaInstance(javaConstructor.getParameterTypes()[0], node);
                } else {
                    argument = Constructor.this.constructScalar(node);
                    try {
                        javaConstructor = type2.getConstructor(String.class);
                    }
                    catch (Exception e) {
                        throw new ConstructorException(null, null, "Can't construct a java object for scalar " + node.getTag() + "; No String constructor found. Exception=" + e.getMessage(), node.getStartMark(), e);
                    }
                }
                try {
                    result = javaConstructor.newInstance(argument);
                }
                catch (Exception e) {
                    throw new ConstructorException(null, null, "Can't construct a java object for scalar " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark(), e);
                }
            }
            return result;
        }

        private Object constructStandardJavaInstance(Class type2, ScalarNode node) {
            Object result;
            if (type2 == String.class) {
                Construct stringConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.STR);
                result = stringConstructor.construct(node);
            } else if (type2 == Boolean.class || type2 == Boolean.TYPE) {
                Construct boolConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.BOOL);
                result = boolConstructor.construct(node);
            } else if (type2 == Character.class || type2 == Character.TYPE) {
                Construct charConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.STR);
                String ch = (String)charConstructor.construct(node);
                if (ch.length() == 0) {
                    result = null;
                } else {
                    if (ch.length() != 1) {
                        throw new YAMLException("Invalid node Character: '" + ch + "'; length: " + ch.length());
                    }
                    result = new Character(ch.charAt(0));
                }
            } else if (Date.class.isAssignableFrom(type2)) {
                Construct dateConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.TIMESTAMP);
                Date date = (Date)dateConstructor.construct(node);
                if (type2 == Date.class) {
                    result = date;
                } else {
                    try {
                        java.lang.reflect.Constructor constr = type2.getConstructor(Long.TYPE);
                        result = constr.newInstance(date.getTime());
                    }
                    catch (Exception e) {
                        throw new YAMLException("Cannot construct: '" + type2 + "'");
                    }
                }
            } else if (type2 == Float.class || type2 == Double.class || type2 == Float.TYPE || type2 == Double.TYPE || type2 == BigDecimal.class) {
                if (type2 == BigDecimal.class) {
                    result = new BigDecimal(node.getValue());
                } else {
                    Construct doubleConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.FLOAT);
                    result = doubleConstructor.construct(node);
                    if (type2 == Float.class || type2 == Float.TYPE) {
                        result = new Float((Double)result);
                    }
                }
            } else if (type2 == Byte.class || type2 == Short.class || type2 == Integer.class || type2 == Long.class || type2 == BigInteger.class || type2 == Byte.TYPE || type2 == Short.TYPE || type2 == Integer.TYPE || type2 == Long.TYPE) {
                Construct intConstructor = (Construct)Constructor.this.yamlConstructors.get(Tag.INT);
                result = intConstructor.construct(node);
                result = type2 == Byte.class || type2 == Byte.TYPE ? (Number)new Byte(result.toString()) : (Number)(type2 == Short.class || type2 == Short.TYPE ? (Number)new Short(result.toString()) : (Number)(type2 == Integer.class || type2 == Integer.TYPE ? (Number)new Integer(result.toString()) : (Number)(type2 == Long.class || type2 == Long.TYPE ? new Long(result.toString()) : new BigInteger(result.toString()))));
            } else if (Enum.class.isAssignableFrom(type2)) {
                String enumValueName = node.getValue();
                try {
                    result = Enum.valueOf(type2, enumValueName);
                }
                catch (Exception ex) {
                    throw new YAMLException("Unable to find enum value '" + enumValueName + "' for enum class: " + type2.getName());
                }
            } else if (Calendar.class.isAssignableFrom(type2)) {
                SafeConstructor.ConstructYamlTimestamp contr = new SafeConstructor.ConstructYamlTimestamp(Constructor.this);
                contr.construct(node);
                result = contr.getCalendar();
            } else {
                throw new YAMLException("Unsupported class: " + type2);
            }
            return result;
        }
    }

    private class ConstructYamlObject
    implements Construct {
        private ConstructYamlObject() {
        }

        private Construct getConstructor(Node node) {
            Class<?> cl = Constructor.this.getClassForNode(node);
            node.setType(cl);
            Construct constructor2 = (Construct)Constructor.this.yamlClassConstructors.get((Object)node.getNodeId());
            return constructor2;
        }

        public Object construct(Node node) {
            Object result = null;
            try {
                result = this.getConstructor(node).construct(node);
            }
            catch (Exception e) {
                throw new ConstructorException(null, null, "Can't construct a java object for " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark(), e);
            }
            return result;
        }

        public void construct2ndStep(Node node, Object object) {
            try {
                this.getConstructor(node).construct2ndStep(node, object);
            }
            catch (Exception e) {
                throw new ConstructorException(null, null, "Can't construct a second step for a java object for " + node.getTag() + "; exception=" + e.getMessage(), node.getStartMark(), e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConstructMapping
    implements Construct {
        private ConstructMapping() {
        }

        @Override
        public Object construct(Node node) {
            MappingNode mnode = (MappingNode)node;
            if (Properties.class.isAssignableFrom(node.getType())) {
                Properties properties = new Properties();
                if (node.isTwoStepsConstruction()) {
                    throw new YAMLException("Properties must not be recursive.");
                }
                Constructor.this.constructMapping2ndStep(mnode, properties);
                return properties;
            }
            if (SortedMap.class.isAssignableFrom(node.getType())) {
                TreeMap<Object, Object> map = new TreeMap<Object, Object>();
                if (!node.isTwoStepsConstruction()) {
                    Constructor.this.constructMapping2ndStep(mnode, map);
                }
                return map;
            }
            if (Map.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultMap();
                }
                return Constructor.this.constructMapping(mnode);
            }
            if (SortedSet.class.isAssignableFrom(node.getType())) {
                TreeSet<Object> set = new TreeSet<Object>();
                Constructor.this.constructSet2ndStep(mnode, set);
                return set;
            }
            if (Collection.class.isAssignableFrom(node.getType())) {
                if (node.isTwoStepsConstruction()) {
                    return Constructor.this.createDefaultSet();
                }
                return Constructor.this.constructSet(mnode);
            }
            if (node.isTwoStepsConstruction()) {
                return this.createEmptyJavaBean(mnode);
            }
            return this.constructJavaBean2ndStep(mnode, this.createEmptyJavaBean(mnode));
        }

        @Override
        public void construct2ndStep(Node node, Object object) {
            if (Map.class.isAssignableFrom(node.getType())) {
                Constructor.this.constructMapping2ndStep((MappingNode)node, (Map)object);
            } else if (Set.class.isAssignableFrom(node.getType())) {
                Constructor.this.constructSet2ndStep((MappingNode)node, (Set)object);
            } else {
                this.constructJavaBean2ndStep((MappingNode)node, object);
            }
        }

        private Object createEmptyJavaBean(MappingNode node) {
            try {
                Class<? extends Object> type2 = node.getType();
                if (Modifier.isAbstract(type2.getModifiers())) {
                    node.setType(Constructor.this.getClassForNode(node));
                }
                java.lang.reflect.Constructor<? extends Object> c = node.getType().getDeclaredConstructor(new Class[0]);
                c.setAccessible(true);
                return c.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new YAMLException(e);
            }
        }

        private Object constructJavaBean2ndStep(MappingNode node, Object object) {
            Class<? extends Object> beanType = node.getType();
            List<NodeTuple> nodeValue = node.getValue();
            for (NodeTuple tuple : nodeValue) {
                if (!(tuple.getKeyNode() instanceof ScalarNode)) {
                    throw new YAMLException("Keys must be scalars but found: " + tuple.getKeyNode());
                }
                ScalarNode keyNode = (ScalarNode)tuple.getKeyNode();
                Node valueNode = tuple.getValueNode();
                keyNode.setType(String.class);
                String key2 = (String)Constructor.this.constructObject(keyNode);
                try {
                    Class<?>[] arguments;
                    MappingNode mnode;
                    Property property = this.getProperty(beanType, key2);
                    valueNode.setType(property.getType());
                    TypeDescription memberDescription = (TypeDescription)Constructor.this.typeDefinitions.get(beanType);
                    boolean typeDetected = false;
                    if (memberDescription != null) {
                        switch (valueNode.getNodeId()) {
                            case sequence: {
                                SequenceNode snode = (SequenceNode)valueNode;
                                Class<? extends Object> memberType = memberDescription.getListPropertyType(key2);
                                if (memberType != null) {
                                    snode.setListType(memberType);
                                    typeDetected = true;
                                    break;
                                }
                                if (!property.getType().isArray()) break;
                                snode.setListType(property.getType().getComponentType());
                                typeDetected = true;
                                break;
                            }
                            case mapping: {
                                mnode = (MappingNode)valueNode;
                                Class<? extends Object> keyType = memberDescription.getMapKeyType(key2);
                                if (keyType == null) break;
                                mnode.setKeyType(keyType);
                                mnode.setValueType(memberDescription.getMapValueType(key2));
                                typeDetected = true;
                            }
                        }
                    }
                    if (!typeDetected && valueNode.getNodeId() != NodeId.scalar && (arguments = property.getActualTypeArguments()) != null) {
                        Class<?> t;
                        if (valueNode.getNodeId() == NodeId.sequence) {
                            t = arguments[0];
                            SequenceNode snode = (SequenceNode)valueNode;
                            snode.setListType(t);
                        } else if (valueNode.getTag().equals(Tag.SET)) {
                            t = arguments[0];
                            mnode = (MappingNode)valueNode;
                            mnode.setKeyType(t);
                            mnode.setUseClassConstructor(true);
                        } else if (valueNode.getNodeId() == NodeId.mapping) {
                            Class<?> ketType = arguments[0];
                            Class<?> valueType = arguments[1];
                            MappingNode mnode2 = (MappingNode)valueNode;
                            mnode2.setKeyType(ketType);
                            mnode2.setValueType(valueType);
                            mnode2.setUseClassConstructor(true);
                        }
                    }
                    Object value2 = Constructor.this.constructObject(valueNode);
                    property.set(object, value2);
                }
                catch (Exception e) {
                    throw new YAMLException("Cannot create property=" + key2 + " for JavaBean=" + object + "; " + e.getMessage(), e);
                }
            }
            return object;
        }

        private Property getProperty(Class<? extends Object> type2, String name2) throws IntrospectionException {
            return Constructor.this.getPropertyUtils().getProperty(type2, name2);
        }
    }
}

