/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TraceType {
    RAW{

        public ThreadContext.RubyStackTraceElement[] getBacktrace(ThreadContext context, boolean nativeException) {
            return ThreadContext.gatherRawBacktrace(context.runtime, Thread.currentThread().getStackTrace());
        }

        public String printBacktrace(RubyException exception2) {
            return 1.printBacktraceMRI(exception2);
        }
    }
    ,
    FULL{

        public ThreadContext.RubyStackTraceElement[] getBacktrace(ThreadContext context, boolean nativeException) {
            return 2.getBacktrace(context, nativeException, true);
        }

        public String printBacktrace(RubyException exception2) {
            return 2.printBacktraceMRI(exception2);
        }
    }
    ,
    RUBY_FRAMED{

        public ThreadContext.RubyStackTraceElement[] getBacktrace(ThreadContext context, boolean nativeException) {
            return 3.getBacktrace(context, nativeException, false);
        }

        public String printBacktrace(RubyException exception2) {
            return 3.printBacktraceMRI(exception2);
        }
    }
    ,
    RUBINIUS{

        public ThreadContext.RubyStackTraceElement[] getBacktrace(ThreadContext context, boolean nativeException) {
            return 4.getBacktrace(context, nativeException, false);
        }

        public String printBacktrace(RubyException exception2) {
            return 4.printBacktraceRubinius(exception2);
        }
    };

    private static final String FIRST_COLOR = "\u001b[0;31m";
    private static final String KERNEL_COLOR = "\u001b[0;36m";
    private static final String EVAL_COLOR = "\u001b[0;33m";
    private static final String CLEAR_COLOR = "\u001b[0m";

    public abstract ThreadContext.RubyStackTraceElement[] getBacktrace(ThreadContext var1, boolean var2);

    public abstract String printBacktrace(RubyException var1);

    protected static String printBacktraceMRI(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext context = runtime2.getCurrentContext();
        IRubyObject backtrace2 = exception2.callMethod(context, "backtrace");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream errorStream = new PrintStream(baos);
        boolean printedPosition = false;
        if (backtrace2.isNil() || !(backtrace2 instanceof RubyArray)) {
            if (context.getFile() != null && context.getFile().length() > 0) {
                errorStream.print(context.getFile() + ":" + context.getLine());
                printedPosition = true;
            } else {
                errorStream.print(context.getLine());
                printedPosition = true;
            }
        } else if (((RubyArray)backtrace2).getLength() == 0) {
            TraceType.printErrorPos(context, errorStream);
        } else {
            IRubyObject mesg = ((RubyArray)backtrace2).first();
            if (mesg.isNil()) {
                TraceType.printErrorPos(context, errorStream);
            } else {
                errorStream.print(mesg);
                printedPosition = true;
            }
        }
        RubyClass type2 = exception2.getMetaClass();
        String info = exception2.toString();
        if (printedPosition) {
            errorStream.print(": ");
        }
        if (type2 == runtime2.getRuntimeError() && (info == null || info.length() == 0)) {
            errorStream.print(": unhandled exception\n");
        } else {
            String path2 = type2.getName();
            if (info.length() == 0) {
                errorStream.print(path2 + '\n');
            } else {
                if (path2.startsWith("#")) {
                    path2 = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                errorStream.print(info);
                if (path2 != null) {
                    errorStream.print(" (" + path2 + ")\n");
                }
                if (tail != null) {
                    errorStream.print(tail + '\n');
                }
            }
        }
        exception2.printBacktrace(errorStream);
        return new String(baos.toByteArray());
    }

    protected static String printBacktraceRubinius(RubyException exception2) {
        Ruby runtime2 = exception2.getRuntime();
        ThreadContext.RubyStackTraceElement[] frames = exception2.getBacktraceElements();
        ArrayList<String> firstParts = new ArrayList<String>();
        int longestFirstPart = 0;
        for (ThreadContext.RubyStackTraceElement frame : frames) {
            String firstPart = frame.getClassName() + "#" + frame.getMethodName();
            if (firstPart.length() > longestFirstPart) {
                longestFirstPart = firstPart.length();
            }
            firstParts.add(firstPart);
        }
        int center2 = longestFirstPart + 2 + 1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("An exception has occurred:\n").append("    ");
        if (exception2.getMetaClass() == runtime2.getRuntimeError() && exception2.message(runtime2.getCurrentContext()).toString().length() == 0) {
            buffer.append("No current exception (RuntimeError)");
        } else {
            buffer.append(exception2.message(runtime2.getCurrentContext()).toString());
        }
        buffer.append('\n').append('\n').append("Backtrace:\n");
        int i = 0;
        for (ThreadContext.RubyStackTraceElement frame : frames) {
            String firstPart = (String)firstParts.get(i);
            String secondPart = frame.getFileName() + ":" + frame.getLineNumber();
            if (i == 0) {
                buffer.append(FIRST_COLOR);
            } else if (frame.isBinding() || frame.getFileName().equals("(eval)")) {
                buffer.append(EVAL_COLOR);
            } else if (frame.getFileName().indexOf(".java") != -1) {
                buffer.append(KERNEL_COLOR);
            }
            buffer.append("  ");
            for (int j = 0; j < center2 - firstPart.length(); ++j) {
                buffer.append(' ');
            }
            buffer.append(firstPart);
            buffer.append(" at ");
            buffer.append(secondPart);
            buffer.append(CLEAR_COLOR);
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public static IRubyObject generateMRIBacktrace(Ruby runtime2, ThreadContext.RubyStackTraceElement[] trace) {
        if (trace == null) {
            return runtime2.getNil();
        }
        RubyArray traceArray = RubyArray.newArray(runtime2);
        for (int i = 0; i < trace.length; ++i) {
            ThreadContext.RubyStackTraceElement element = trace[i];
            RubyString str = RubyString.newString(runtime2, element.getFileName() + ":" + element.getLineNumber() + ":in `" + element.getMethodName() + "'");
            traceArray.append(str);
        }
        return traceArray;
    }

    protected static ThreadContext.RubyStackTraceElement[] getBacktrace(ThreadContext context, boolean nativeException, boolean full) {
        return ThreadContext.gatherHybridBacktrace(context.getRuntime(), context.createBacktrace2(0, nativeException), Thread.currentThread().getStackTrace(), full);
    }

    private static void printErrorPos(ThreadContext context, PrintStream errorStream) {
        if (context.getFile() != null && context.getFile().length() > 0) {
            if (context.getFrameName() != null) {
                errorStream.print(context.getFile() + ":" + context.getLine());
                errorStream.print(":in '" + context.getFrameName() + '\'');
            } else if (context.getLine() != 0) {
                errorStream.print(context.getFile() + ":" + context.getLine());
            } else {
                errorStream.print(context.getFile());
            }
        }
    }

    public static TraceType traceTypeFor(String style) {
        if (style.equalsIgnoreCase("raw")) {
            return RAW;
        }
        if (style.equalsIgnoreCase("ruby_framed")) {
            return RUBY_FRAMED;
        }
        if (style.equalsIgnoreCase("rubinius")) {
            return RUBINIUS;
        }
        if (style.equalsIgnoreCase("full")) {
            return FULL;
        }
        return RUBY_FRAMED;
    }
}

