/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DumpingInvocationMethodFactory;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.internal.runtime.methods.ReflectionMethodFactory;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.SafePropertyAccessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MethodFactory {
    public static final Class[] COMPILED_METHOD_PARAMS = new Class[]{ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
    private static final boolean reflection;
    private static final boolean dumping;
    private static final String dumpingPath;

    public static MethodFactory createFactory(ClassLoader classLoader) {
        if (reflection) {
            return new ReflectionMethodFactory();
        }
        if (dumping) {
            return new DumpingInvocationMethodFactory(dumpingPath, classLoader);
        }
        return new InvocationMethodFactory(classLoader);
    }

    public abstract DynamicMethod getCompiledMethod(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7, ISourcePosition var8, String var9);

    public byte[] getCompiledMethodOffline(String method2, String classPath, String invokerPath, Arity arity2, StaticScope scope, CallConfiguration callConfig, String filename2, int line) {
        return null;
    }

    public abstract DynamicMethod getCompiledMethodLazily(RubyModule var1, String var2, Arity var3, Visibility var4, StaticScope var5, Object var6, CallConfiguration var7, ISourcePosition var8, String var9);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, List<JavaMethodDescriptor> var2);

    public abstract DynamicMethod getAnnotatedMethod(RubyModule var1, JavaMethodDescriptor var2);

    public abstract CompiledBlockCallback getBlockCallback(String var1, String var2, int var3, Object var4);

    public abstract CompiledBlockCallback19 getBlockCallback19(String var1, String var2, int var3, Object var4);

    public byte[] getBlockCallbackOffline(String method2, String file2, int line, String classPath) {
        return null;
    }

    public byte[] getBlockCallback19Offline(String method2, String file2, int line, String classPath) {
        return null;
    }

    static {
        boolean reflection_ = false;
        boolean dumping_ = false;
        String dumpingPath_ = null;
        if (Ruby.isSecurityRestricted()) {
            reflection_ = true;
        } else {
            reflection_ = RubyInstanceConfig.REFLECTED_HANDLES;
            if (SafePropertyAccessor.getProperty("jruby.dump_invocations") != null) {
                dumping_ = true;
                dumpingPath_ = SafePropertyAccessor.getProperty("jruby.dump_invocations");
            }
        }
        reflection = reflection_;
        dumping = dumping_;
        dumpingPath = dumpingPath_;
    }

    @Deprecated
    public static interface MethodDefiningCallback {
        public void define(RubyModule var1, JavaMethodDescriptor var2, DynamicMethod var3);
    }
}

