/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.invokers.InstanceFieldGetter;
import org.jruby.java.invokers.InstanceFieldSetter;
import org.jruby.java.invokers.InstanceMethodInvoker;
import org.jruby.java.invokers.MethodInvoker;
import org.jruby.java.invokers.StaticFieldGetter;
import org.jruby.java.invokers.StaticFieldSetter;
import org.jruby.java.invokers.StaticMethodInvoker;
import org.jruby.java.proxies.ArrayJavaProxyCreator;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaProxy
extends RubyObject {
    private static final boolean DEBUG = false;
    private JavaObject javaObject;
    protected Object object;

    public JavaProxy(Ruby runtime2, RubyClass klazz) {
        super(runtime2, klazz);
    }

    @Override
    public Object dataGetStruct() {
        this.lazyJavaObject();
        return this.javaObject;
    }

    @Override
    public void dataWrapStruct(Object object) {
        this.javaObject = (JavaObject)object;
        this.object = this.javaObject.getValue();
    }

    public Object getObject() {
        if (this.object == null) {
            if (this.javaObject == null) {
                throw this.getRuntime().newRuntimeError("Java wrapper with no contents: " + this.getMetaClass().getName());
            }
            this.object = this.javaObject.getValue();
        }
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    private void lazyJavaObject() {
        if (this.javaObject == null) {
            this.javaObject = JavaObject.wrap(this.getRuntime(), this.object);
        }
    }

    @Override
    public Class getJavaClass() {
        return this.object.getClass();
    }

    public static RubyClass createJavaProxy(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        RubyClass javaProxy = runtime2.defineClass("JavaProxy", runtime2.getObject(), new ObjectAllocator(){

            public IRubyObject allocate(Ruby runtime2, RubyClass klazz) {
                return new JavaProxy(runtime2, klazz);
            }
        });
        RubyClass singleton = javaProxy.getSingletonClass();
        singleton.addReadWriteAttribute(context, "java_class");
        javaProxy.defineAnnotatedMethods(JavaProxy.class);
        javaProxy.includeModule(runtime2.fastGetModule("JavaProxyMethods"));
        return javaProxy;
    }

    @JRubyMethod(frame=true, meta=true)
    public static IRubyObject inherited(ThreadContext context, IRubyObject recv2, IRubyObject subclass) {
        IRubyObject subJavaClass = RuntimeHelpers.invoke(context, subclass, "java_class");
        if (subJavaClass.isNil()) {
            subJavaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
            RuntimeHelpers.invoke(context, subclass, "java_class=", subJavaClass);
        }
        return RuntimeHelpers.invokeSuper(context, recv2, subclass, Block.NULL_BLOCK);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject singleton_class(IRubyObject recv2) {
        return ((RubyClass)recv2).getSingletonClass();
    }

    @JRubyMethod(name={"[]"}, meta=true, rest=true)
    public static IRubyObject op_aref(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject javaClass = RuntimeHelpers.invoke(context, recv2, "java_class");
        if (args2.length > 0) {
            ArrayJavaProxyCreator ajpc = new ArrayJavaProxyCreator(context.runtime);
            ajpc.setup(context, javaClass, args2);
            return ajpc;
        }
        return Java.get_proxy_class(javaClass, RuntimeHelpers.invoke(context, javaClass, "array_class"));
    }

    @Override
    public IRubyObject initialize_copy(IRubyObject original) {
        super.initialize_copy(original);
        this.setObject(((JavaProxy)original).object);
        return this;
    }

    private static Class<?> getJavaClass(ThreadContext context, RubyModule module) {
        try {
            IRubyObject jClass = RuntimeHelpers.invoke(context, module, "java_class");
            return !(jClass instanceof JavaClass) ? null : ((JavaClass)jClass).javaClass();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Map<String, String> getFieldListFromArgs(IRubyObject[] args2) {
        final HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < args2.length; ++i) {
            if (args2[i] instanceof RubyHash) {
                ((RubyHash)args2[i]).visitAll(new RubyHash.Visitor(){

                    public void visit(IRubyObject key2, IRubyObject value2) {
                        map.put(key2.asString().toString(), value2.asString().toString());
                    }
                });
                continue;
            }
            String value2 = args2[i].asString().toString();
            map.put(value2, value2);
        }
        return map;
    }

    private static void installField(ThreadContext context, Map<String, String> fieldMap, Field field2, RubyModule module, boolean asReader, boolean asWriter) {
        boolean isFinal = Modifier.isFinal(field2.getModifiers());
        Iterator<Map.Entry<String, String>> iter = fieldMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            String key2 = entry.getKey();
            if (!key2.equals(field2.getName())) continue;
            if (Ruby.isSecurityRestricted() && !Modifier.isPublic(field2.getModifiers())) {
                throw context.getRuntime().newSecurityError("Cannot change accessibility on fields in a restricted mode: field '" + field2.getName() + "'");
            }
            String asName = entry.getValue();
            if (Modifier.isStatic(field2.getModifiers())) {
                if (asReader) {
                    module.getSingletonClass().addMethod(asName, new StaticFieldGetter(key2, module, field2));
                }
                if (asWriter) {
                    if (isFinal) {
                        throw context.getRuntime().newSecurityError("Cannot change final field '" + field2.getName() + "'");
                    }
                    module.getSingletonClass().addMethod(asName + "=", new StaticFieldSetter(key2, module, field2));
                }
            } else {
                if (asReader) {
                    module.addMethod(asName, new InstanceFieldGetter(key2, module, field2));
                }
                if (asWriter) {
                    if (isFinal) {
                        throw context.getRuntime().newSecurityError("Cannot change final field '" + field2.getName() + "'");
                    }
                    module.addMethod(asName + "=", new InstanceFieldSetter(key2, module, field2));
                }
            }
            iter.remove();
            break;
        }
    }

    private static void findFields(ThreadContext context, RubyModule topModule, IRubyObject[] args2, boolean asReader, boolean asWriter) {
        Map<String, String> fieldMap = JavaProxy.getFieldListFromArgs(args2);
        for (RubyModule module = topModule; module != null; module = module.getSuperClass()) {
            Class<?> javaClass = JavaProxy.getJavaClass(context, module);
            if (javaClass == null) continue;
            Field[] fields2 = JavaClass.getDeclaredFields(javaClass);
            for (int j = 0; j < fields2.length; ++j) {
                JavaProxy.installField(context, fieldMap, fields2[j], module, asReader, asWriter);
            }
        }
        if (!fieldMap.isEmpty()) {
            throw JavaClass.undefinedFieldError(context.getRuntime(), topModule.getName(), fieldMap.keySet().iterator().next());
        }
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_accessor(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, true);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_reader(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, true, false);
        return context.getRuntime().getNil();
    }

    @JRubyMethod(meta=true, rest=true)
    public static IRubyObject field_writer(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        JavaProxy.findFields(context, (RubyModule)recv2, args2, false, true);
        return context.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"equal?"})
    public IRubyObject equal_p(ThreadContext context, IRubyObject other) {
        Ruby runtime2 = context.getRuntime();
        if (other instanceof JavaProxy) {
            boolean equal = this.getObject() == ((JavaProxy)other).getObject();
            return runtime2.newBoolean(equal);
        }
        return runtime2.getFalse();
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        Ruby runtime2 = context.getRuntime();
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(name2, new Class[0]));
        return method2.invokeDirect(this.getObject());
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.getRuntime();
        if (argTypesAry.size() != 0) {
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime2, argTypesClasses);
        }
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(name2, new Class[0]));
        return method2.invokeDirect(this.getObject());
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes, IRubyObject arg0) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Ruby runtime2 = context.getRuntime();
        if (argTypesAry.size() != 1) {
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime2, argTypesClasses);
        }
        Class argTypeClass = (Class)argTypesAry.eltInternal(0).toJava(Class.class);
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(name2, argTypeClass));
        return method2.invokeDirect(this.getObject(), arg0.toJava(argTypeClass));
    }

    @JRubyMethod(required=4, rest=true, backtrace=true)
    public IRubyObject java_send(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime2 = context.getRuntime();
        String name2 = args2[0].asJavaString();
        RubyArray argTypesAry = args2[1].convertToArray();
        int argsLen = args2.length - 2;
        if (argTypesAry.size() != argsLen) {
            Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
            throw JavaMethod.newArgSizeMismatchError(runtime2, argTypesClasses);
        }
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argsLen]);
        Object[] argsAry = new Object[argsLen];
        for (int i = 0; i < argsLen; ++i) {
            argsAry[i] = args2[i + 2].toJava(argTypesClasses[i]);
        }
        JavaMethod method2 = new JavaMethod(runtime2, this.getMethod(name2, argTypesClasses));
        return method2.invokeDirect(this.getObject(), argsAry);
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName) {
        String name2 = rubyName.asJavaString();
        return this.getRubyMethod(name2, new Class[0]);
    }

    @JRubyMethod(backtrace=true)
    public IRubyObject java_method(ThreadContext context, IRubyObject rubyName, IRubyObject argTypes) {
        String name2 = rubyName.asJavaString();
        RubyArray argTypesAry = argTypes.convertToArray();
        Class[] argTypesClasses = (Class[])argTypesAry.toArray(new Class[argTypesAry.size()]);
        return this.getRubyMethod(name2, argTypesClasses);
    }

    @JRubyMethod
    public IRubyObject marshal_dump() {
        if (Serializable.class.isAssignableFrom(this.object.getClass())) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(this.object);
                return this.getRuntime().newString(new ByteList(baos.toByteArray()));
            }
            catch (IOException ioe) {
                throw this.getRuntime().newIOErrorFromException(ioe);
            }
        }
        throw this.getRuntime().newTypeError("no marshal_dump is defined for class " + this.getJavaClass());
    }

    @JRubyMethod
    public IRubyObject marshal_load(ThreadContext context, IRubyObject str) {
        try {
            ByteList byteList = str.convertToString().getByteList();
            ByteArrayInputStream bais = new ByteArrayInputStream(byteList.getUnsafeBytes(), byteList.getBegin(), byteList.getRealSize());
            JRubyObjectInputStream ois = new JRubyObjectInputStream(context.getRuntime(), bais);
            this.object = ois.readObject();
            return this;
        }
        catch (IOException ioe) {
            throw context.getRuntime().newIOErrorFromException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw context.getRuntime().newTypeError("Class not found unmarshaling Java type: " + cnfe.getLocalizedMessage());
        }
    }

    @Override
    protected int inspectHashCode() {
        return System.identityHashCode(this.object);
    }

    private Method getMethod(String name2, Class ... argTypes) {
        try {
            return this.getObject().getClass().getMethod(name2, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw JavaMethod.newMethodNotFoundError(this.getRuntime(), this.getObject().getClass(), name2 + CodegenUtils.prettyParams(argTypes), name2);
        }
    }

    private MethodInvoker getMethodInvoker(Method method2) {
        if (Modifier.isStatic(method2.getModifiers())) {
            return new StaticMethodInvoker(this.metaClass.getMetaClass(), method2);
        }
        return new InstanceMethodInvoker((RubyModule)this.metaClass, method2);
    }

    private RubyMethod getRubyMethod(String name2, Class ... argTypes) {
        Method jmethod = this.getMethod(name2, argTypes);
        if (Modifier.isStatic(jmethod.getModifiers())) {
            return RubyMethod.newMethod(this.metaClass.getSingletonClass(), CodegenUtils.prettyParams(argTypes), this.metaClass.getSingletonClass(), name2, this.getMethodInvoker(jmethod), this.getMetaClass());
        }
        return RubyMethod.newMethod(this.metaClass, CodegenUtils.prettyParams(argTypes), this.metaClass, name2, this.getMethodInvoker(jmethod), this);
    }

    @Override
    public Object toJava(Class type2) {
        if (type2.isAssignableFrom(this.getObject().getClass())) {
            if (Java.OBJECT_PROXY_CACHE) {
                this.getRuntime().getJavaSupport().getObjectProxyCache().put(this.getObject(), this);
            }
            return this.getObject();
        }
        return super.toJava(type2);
    }

    public Object unwrap() {
        return this.getObject();
    }
}

