/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScopeImpl;
import org.jruby.compiler.ir.compiler_pass.CompilerPass;
import org.jruby.compiler.ir.instructions.DefineClassMethodInstr;
import org.jruby.compiler.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.compiler.ir.instructions.OneOperandInstr;
import org.jruby.compiler.ir.instructions.ReceiveSelfInstruction;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.parser.LocalStaticScope;
import org.jruby.parser.StaticScope;

public class IRModule
extends IRScopeImpl {
    private static final String ROOT_METHOD_PREFIX = ":_ROOT_:";
    private static Map<String, IRClass> coreClasses;
    private IRMethod rootMethod;
    private CodeVersion version;
    public final List<IRMethod> methods = new ArrayList<IRMethod>();

    private static IRClass addCoreClass(String name2, IRScope parent, String[] coreMethods, StaticScope staticScope) {
        IRClass c = new IRClass(parent, null, null, name2, staticScope);
        coreClasses.put(c.getName(), c);
        if (coreMethods != null) {
            for (String m : coreMethods) {
                IRMethod meth = new IRMethod(c, null, m, true, null);
                meth.setCodeModificationFlag(false);
                c.addMethod(meth);
            }
        }
        return c;
    }

    public static void bootStrap() {
        coreClasses = new HashMap<String, IRClass>();
        IRClass obj = IRModule.addCoreClass("Object", null, null, null);
        IRModule.addCoreClass("Class", IRModule.addCoreClass("Module", obj, null, null), null, null);
        IRModule.addCoreClass("Fixnum", obj, new String[]{"+", "-", "/", "*"}, null);
        IRModule.addCoreClass("Float", obj, new String[]{"+", "-", "/", "*"}, null);
        IRModule.addCoreClass("Array", obj, new String[]{"[]", "each", "inject"}, null);
        IRModule.addCoreClass("Range", obj, new String[]{"each"}, null);
        IRModule.addCoreClass("Hash", obj, new String[]{"each"}, null);
        IRModule.addCoreClass("String", obj, null, null);
        IRModule.addCoreClass("Proc", obj, null, null);
    }

    public static IRClass getCoreClass(String n) {
        return coreClasses.get(n);
    }

    public static boolean isAClassRootMethod(IRMethod m) {
        return m.getName().startsWith(ROOT_METHOD_PREFIX);
    }

    private void addRootMethod() {
        String n = ROOT_METHOD_PREFIX + this.getName();
        this.rootMethod = new IRMethod(this, MetaObject.create(this), n, false, new LocalStaticScope(null));
        this.rootMethod.addInstr(new ReceiveSelfInstruction(this.rootMethod.getSelf()));
    }

    public void addMethod(IRMethod method2) {
        assert (!IRModule.isAClassRootMethod(method2));
        this.methods.add(method2);
        OneOperandInstr instruction = method2.isInstanceMethod ? new DefineInstanceMethodInstr(this, method2) : new DefineClassMethodInstr(this, method2);
        this.getRootMethod().addInstr(instruction);
    }

    protected void runCompilerPassOnNestedScopes(CompilerPass p2) {
        super.runCompilerPassOnNestedScopes(p2);
        this.getRootMethod().runCompilerPass(p2);
        for (IRMethod meth : this.methods) {
            meth.runCompilerPass(p2);
        }
    }

    public IRModule getNearestModule() {
        return this;
    }

    public IRModule(IRScope lexicalParent, Operand container, String name2, StaticScope scope) {
        super(lexicalParent, container, name2, scope);
        this.addRootMethod();
        this.updateVersion();
    }

    public void updateVersion() {
        this.version = CodeVersion.getClassVersionToken();
    }

    public String getScopeName() {
        return "Module";
    }

    public CodeVersion getVersion() {
        return this.version;
    }

    public IRMethod getRootMethod() {
        return this.rootMethod;
    }

    public IRMethod getInstanceMethod(String name2) {
        for (IRMethod m : this.methods) {
            if (!m.isInstanceMethod || !m.getName().equals(name2)) continue;
            return m;
        }
        return null;
    }

    public IRMethod getClassMethod(String name2) {
        for (IRMethod m : this.methods) {
            if (m.isInstanceMethod || !this.getName().equals(name2)) continue;
            return m;
        }
        return null;
    }

    public boolean isCoreClass(String className) {
        return this == IRClass.getCoreClass(className);
    }

    public LocalVariable getLocalVariable(String name2) {
        throw new UnsupportedOperationException("This should be happening in the root method of this module/class instead");
    }

    static {
        IRModule.bootStrap();
    }
}

