/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.jruby.Ruby;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2MethodNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TypedArgumentNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ir.IRClass;
import org.jruby.compiler.ir.IRClosure;
import org.jruby.compiler.ir.IRExecutionScope;
import org.jruby.compiler.ir.IRLoop;
import org.jruby.compiler.ir.IRMetaClass;
import org.jruby.compiler.ir.IRMethod;
import org.jruby.compiler.ir.IRModule;
import org.jruby.compiler.ir.IRScope;
import org.jruby.compiler.ir.IRScript;
import org.jruby.compiler.ir.compiler_pass.AddBindingInstructions;
import org.jruby.compiler.ir.compiler_pass.CFG_Builder;
import org.jruby.compiler.ir.compiler_pass.IR_Printer;
import org.jruby.compiler.ir.compiler_pass.InlineTest;
import org.jruby.compiler.ir.compiler_pass.LinearizeCFG;
import org.jruby.compiler.ir.compiler_pass.LiveVariableAnalysis;
import org.jruby.compiler.ir.compiler_pass.opts.DeadCodeElimination;
import org.jruby.compiler.ir.compiler_pass.opts.LocalOptimizationPass;
import org.jruby.compiler.ir.instructions.AttrAssignInstr;
import org.jruby.compiler.ir.instructions.BEQInstr;
import org.jruby.compiler.ir.instructions.BREAK_Instr;
import org.jruby.compiler.ir.instructions.CallInstr;
import org.jruby.compiler.ir.instructions.CaseInstr;
import org.jruby.compiler.ir.instructions.ClosureReturnInstr;
import org.jruby.compiler.ir.instructions.CopyInstr;
import org.jruby.compiler.ir.instructions.DECLARE_LOCAL_TYPE_Instr;
import org.jruby.compiler.ir.instructions.EQQ_Instr;
import org.jruby.compiler.ir.instructions.FilenameInstr;
import org.jruby.compiler.ir.instructions.GetArrayInstr;
import org.jruby.compiler.ir.instructions.GetClassVariableInstr;
import org.jruby.compiler.ir.instructions.GetConstInstr;
import org.jruby.compiler.ir.instructions.GetFieldInstr;
import org.jruby.compiler.ir.instructions.GetGlobalVariableInstr;
import org.jruby.compiler.ir.instructions.IsTrueInstr;
import org.jruby.compiler.ir.instructions.JRubyImplCallInstr;
import org.jruby.compiler.ir.instructions.JUMP_INDIRECT_Instr;
import org.jruby.compiler.ir.instructions.JumpInstr;
import org.jruby.compiler.ir.instructions.LABEL_Instr;
import org.jruby.compiler.ir.instructions.LineNumberInstr;
import org.jruby.compiler.ir.instructions.NotInstr;
import org.jruby.compiler.ir.instructions.PutClassVariableInstr;
import org.jruby.compiler.ir.instructions.PutConstInstr;
import org.jruby.compiler.ir.instructions.PutFieldInstr;
import org.jruby.compiler.ir.instructions.PutGlobalVarInstr;
import org.jruby.compiler.ir.instructions.RECV_EXCEPTION_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_END_MARKER_Instr;
import org.jruby.compiler.ir.instructions.RESCUED_BODY_START_MARKER_Instr;
import org.jruby.compiler.ir.instructions.ReceiveArgumentInstruction;
import org.jruby.compiler.ir.instructions.ReceiveClosureArgInstr;
import org.jruby.compiler.ir.instructions.ReceiveClosureInstr;
import org.jruby.compiler.ir.instructions.ReceiveOptionalArgumentInstr;
import org.jruby.compiler.ir.instructions.ReceiveSelfInstruction;
import org.jruby.compiler.ir.instructions.ReturnInstr;
import org.jruby.compiler.ir.instructions.RubyInternalCallInstr;
import org.jruby.compiler.ir.instructions.SET_RETADDR_Instr;
import org.jruby.compiler.ir.instructions.THROW_EXCEPTION_Instr;
import org.jruby.compiler.ir.instructions.ThreadPollInstr;
import org.jruby.compiler.ir.instructions.YieldInstr;
import org.jruby.compiler.ir.operands.Array;
import org.jruby.compiler.ir.operands.Backref;
import org.jruby.compiler.ir.operands.BacktickString;
import org.jruby.compiler.ir.operands.BooleanLiteral;
import org.jruby.compiler.ir.operands.BreakResult;
import org.jruby.compiler.ir.operands.ClassMetaObject;
import org.jruby.compiler.ir.operands.ClosureMetaObject;
import org.jruby.compiler.ir.operands.CompoundArray;
import org.jruby.compiler.ir.operands.CompoundString;
import org.jruby.compiler.ir.operands.DynamicSymbol;
import org.jruby.compiler.ir.operands.Fixnum;
import org.jruby.compiler.ir.operands.Float;
import org.jruby.compiler.ir.operands.Hash;
import org.jruby.compiler.ir.operands.KeyValuePair;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.LocalVariable;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.MethAddr;
import org.jruby.compiler.ir.operands.ModuleMetaObject;
import org.jruby.compiler.ir.operands.Nil;
import org.jruby.compiler.ir.operands.NthRef;
import org.jruby.compiler.ir.operands.Operand;
import org.jruby.compiler.ir.operands.Range;
import org.jruby.compiler.ir.operands.Regexp;
import org.jruby.compiler.ir.operands.SValue;
import org.jruby.compiler.ir.operands.Splat;
import org.jruby.compiler.ir.operands.StringLiteral;
import org.jruby.compiler.ir.operands.Symbol;
import org.jruby.compiler.ir.operands.Variable;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.util.ByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IRBuilder {
    private int _lastProcessedLineNum = -1;
    private Stack<EnsureBlockInfo> _ensureBlockStack = new Stack();
    private Stack<Label> _rescueBlockLabelStack = new Stack();

    public static void main(String[] args2) {
        boolean isDebug = args2.length > 0 && args2[0].equals("-debug");
        int i = isDebug ? 1 : 0;
        String methName = null;
        if (args2.length > i && args2[i].equals("-inline")) {
            methName = args2[i + 1];
            i += 2;
        }
        boolean isCommandLineScript = args2.length > i && args2[i].equals("-e");
        i += isCommandLineScript ? 1 : 0;
        while (i < args2.length) {
            long t1 = new Date().getTime();
            Node ast = IRBuilder.buildAST(isCommandLineScript, args2[i]);
            long t2 = new Date().getTime();
            IRScope scope = new IRBuilder().buildRoot((RootNode)ast);
            long t3 = new Date().getTime();
            if (isDebug) {
                System.out.println("################## Before local optimization pass ##################");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new LocalOptimizationPass());
            long t4 = new Date().getTime();
            if (isDebug) {
                System.out.println("################## After local optimization pass ##################");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new CFG_Builder());
            long t5 = new Date().getTime();
            long t6 = new Date().getTime();
            if (methName != null) {
                System.out.println("################## After inline pass ##################");
                System.out.println("Asked to inline " + methName);
                scope.runCompilerPass(new InlineTest(methName));
                scope.runCompilerPass(new LocalOptimizationPass());
                scope.runCompilerPass(new IR_Printer());
            }
            if (isDebug) {
                System.out.println("################## After dead code elimination pass ##################");
            }
            scope.runCompilerPass(new LiveVariableAnalysis());
            long t7 = new Date().getTime();
            scope.runCompilerPass(new DeadCodeElimination());
            long t8 = new Date().getTime();
            scope.runCompilerPass(new AddBindingInstructions());
            long t9 = new Date().getTime();
            if (isDebug) {
                scope.runCompilerPass(new IR_Printer());
            }
            if (isDebug) {
                System.out.println("################## After cfg linearization pass ##################");
                scope.runCompilerPass(new IR_Printer());
            }
            scope.runCompilerPass(new LinearizeCFG());
            System.out.println("Time to build AST         : " + (t2 - t1));
            System.out.println("Time to build IR          : " + (t3 - t2));
            System.out.println("Time to run local opts    : " + (t4 - t3));
            System.out.println("Time to run build cfg     : " + (t5 - t4));
            System.out.println("Time to run build domtree : " + (t6 - t5));
            System.out.println("Time to run lva           : " + (t7 - t6));
            System.out.println("Time to run dead code elim: " + (t8 - t7));
            System.out.println("Time to add frame instrs  : " + (t9 - t8));
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Node node;
        Ruby ruby2 = Ruby.getGlobalRuntime();
        if (isCommandLineScript) {
            return ruby2.parse(ByteList.create(arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            try {
                File file2 = new File(arg2);
                fis = new FileInputStream(file2);
                long size2 = file2.length();
                byte[] bytes2 = new byte[(int)size2];
                fis.read(bytes2);
                System.out.println("-- processing " + arg2 + " --");
                node = ruby2.parse(new ByteList(bytes2), arg2, null, 0, false);
                Object var10_9 = null;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            catch (Exception e) {
                throw throwable;
            }
        }
        try {}
        catch (Exception e) {
            // empty catch block
            return node;
        }
        if (fis == null) return node;
        fis.close();
        return node;
    }

    public Node skipOverNewlines(IRScope s, Node n) {
        int currLineNum;
        if (n.getNodeType() == NodeType.NEWLINENODE && (currLineNum = n.getPosition().getStartLine()) != this._lastProcessedLineNum) {
            s.addInstr(new LineNumberInstr(s, currLineNum));
            this._lastProcessedLineNum = currLineNum;
        }
        while (n.getNodeType() == NodeType.NEWLINENODE) {
            n = ((NewlineNode)n).getNextNode();
        }
        return n;
    }

    public Operand generateJRubyUtilityCall(IRScope m, MethAddr meth, Operand receiver2, Operand[] args2) {
        Variable ret = m.getNewTemporaryVariable();
        m.addInstr(new JRubyImplCallInstr(ret, meth, receiver2, args2));
        return ret;
    }

    public Operand build(Node node, IRScope m) {
        if (node == null) {
            return null;
        }
        if (m == null) {
            System.out.println("Got a null scope!");
            throw new NotCompilableException("Unknown node encountered in builder: " + node);
        }
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node, m);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node, m);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat((ArgsCatNode)node, m);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush((ArgsPushNode)node, m);
            }
            case ARRAYNODE: {
                return this.buildArray(node, m);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign((AttrAssignNode)node, m);
            }
            case BACKREFNODE: {
                return this.buildBackref((BackRefNode)node, m);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node, m);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node, m);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node, m);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node, (IRExecutionScope)m);
            }
            case CALLNODE: {
                return this.buildCall((CallNode)node, m);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node, m);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node, m);
            }
            case CLASSVARNODE: {
                return this.buildClassVar((ClassVarNode)node, m);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node, m);
            }
            case CLASSVARDECLNODE: {
                return this.buildClassVarDecl((ClassVarDeclNode)node, m);
            }
            case COLON2NODE: {
                return this.buildColon2((Colon2Node)node, m);
            }
            case COLON3NODE: {
                return this.buildColon3((Colon3Node)node, m);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node, m);
            }
            case CONSTNODE: {
                return this.buildConst((ConstNode)node, m);
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node, m);
            }
            case DEFINEDNODE: {
                return this.buildDefined(node, m);
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node, m);
            }
            case DEFSNODE: {
                return this.buildDefs((DefsNode)node, m);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node, m);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp((DRegexpNode)node, m);
            }
            case DSTRNODE: {
                return this.buildDStr((DStrNode)node, m);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol(node, m);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node, m);
            }
            case DXSTRNODE: {
                return this.buildDXStr((DXStrNode)node, m);
            }
            case ENSURENODE: {
                return this.buildEnsureNode(node, m);
            }
            case EVSTRNODE: {
                return this.buildEvStr((EvStrNode)node, m);
            }
            case FALSENODE: {
                return this.buildFalse(node, m);
            }
            case FCALLNODE: {
                return this.buildFCall((FCallNode)node, m);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node, m);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node, m);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node, (IRExecutionScope)m);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node, m);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar((GlobalVarNode)node, m);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node, m);
            }
            case IFNODE: {
                return this.buildIf((IfNode)node, m);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node, m);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node, m);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node, (IRExecutionScope)m);
            }
            case LITERALNODE: {
                return this.buildLiteral((LiteralNode)node, m);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node, m);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node, m);
            }
            case MATCH2NODE: {
                return this.buildMatch2((Match2Node)node, m);
            }
            case MATCH3NODE: {
                return this.buildMatch3((Match3Node)node, m);
            }
            case MATCHNODE: {
                return this.buildMatch((MatchNode)node, m);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node, m);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn((MultipleAsgnNode)node, m);
            }
            case NEWLINENODE: {
                return this.buildNewline((NewlineNode)node, m);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node, (IRExecutionScope)m);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node, m);
            }
            case NILNODE: {
                return this.buildNil(node, m);
            }
            case NOTNODE: {
                return this.buildNot((NotNode)node, m);
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node, m);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node, m);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node, m);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn(node, m);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node, m);
            }
            case REDONODE: {
                return this.buildRedo(node, (IRExecutionScope)m);
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node, m);
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                return this.buildRescue(node, m);
            }
            case RETRYNODE: {
                return this.buildRetry(node, m);
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node, m);
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use buildRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                return this.buildSClass((SClassNode)node, m);
            }
            case SELFNODE: {
                return this.buildSelf((SelfNode)node, m);
            }
            case SPLATNODE: {
                return this.buildSplat((SplatNode)node, m);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node, m);
            }
            case SUPERNODE: {
                return this.buildSuper((SuperNode)node, m);
            }
            case SVALUENODE: {
                return this.buildSValue((SValueNode)node, m);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node, m);
            }
            case TOARYNODE: {
                return this.buildToAry((ToAryNode)node, m);
            }
            case TRUENODE: {
                return this.buildTrue(node, m);
            }
            case UNDEFNODE: {
                return this.buildUndef(node, m);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node, (IRExecutionScope)m);
            }
            case VALIASNODE: {
                return this.buildVAlias(node, m);
            }
            case VCALLNODE: {
                return this.buildVCall((VCallNode)node, m);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node, (IRExecutionScope)m);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr((XStrNode)node, m);
            }
            case YIELDNODE: {
                return this.buildYield((YieldNode)node, m);
            }
            case ZARRAYNODE: {
                return this.buildZArray(node, m);
            }
            case ZSUPERNODE: {
                return this.buildZSuper((ZSuperNode)node, m);
            }
        }
        new Exception().printStackTrace();
        throw new NotCompilableException("Unknown node encountered in builder: " + node.getClass());
    }

    public void buildArguments(List<Operand> args2, Node node, IRScope s) {
        switch (node.getNodeType()) {
            case ARGSCATNODE: {
                this.buildArgsCatArguments(args2, (ArgsCatNode)node, s);
                break;
            }
            case ARGSPUSHNODE: {
                this.buildArgsPushArguments(args2, (ArgsPushNode)node, s);
                break;
            }
            case ARRAYNODE: {
                this.buildArrayArguments(args2, node, s);
                break;
            }
            case SPLATNODE: {
                this.buildSplatArguments(args2, (SplatNode)node, s);
                break;
            }
            default: {
                Operand retVal = this.build(node, s);
                if (retVal == null) break;
                args2.add(retVal);
            }
        }
    }

    public void buildVariableArityArguments(List<Operand> args2, Node node, IRScope s) {
        this.buildArguments(args2, node, s);
    }

    public void buildSpecificArityArguments(List<Operand> args2, Node node, IRScope s) {
        if (node.getNodeType() == NodeType.ARRAYNODE) {
            ArrayNode arrayNode = (ArrayNode)node;
            if (arrayNode.isLightweight()) {
                for (Node n : arrayNode.childNodes()) {
                    args2.add(this.build(n, s));
                }
            } else {
                args2.add(this.build(arrayNode, s));
            }
        } else {
            args2.add(this.build(node, s));
        }
    }

    public List<Operand> setupCallArgs(Node args2, IRScope s) {
        ArrayList<Operand> argsList = new ArrayList<Operand>();
        if (args2 != null) {
            args2 = this.skipOverNewlines(s, args2);
            this.buildArgs(argsList, args2, s);
        }
        return argsList;
    }

    public void buildArgs(List<Operand> argsList, Node args2, IRScope s) {
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: 
            case SPLATNODE: {
                this.buildVariableArityArguments(argsList, args2, s);
                break;
            }
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)args2;
                this.buildSpecificArityArguments(argsList, arrayNode, s);
                break;
            }
            default: {
                this.buildSpecificArityArguments(argsList, args2, s);
            }
        }
    }

    public void buildAssignment(Node node, IRScope s, Operand values, int argIndex, boolean isSplat) {
        Variable v = s.getNewTemporaryVariable();
        s.addInstr(new GetArrayInstr(v, values, argIndex, isSplat));
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, s, v);
                break;
            }
            case CLASSVARASGNNODE: {
                s.addInstr(new PutClassVariableInstr(MetaObject.create(s).getNearestClass(), ((ClassVarAsgnNode)node).getName(), v));
                break;
            }
            case CLASSVARDECLNODE: {
                s.addInstr(new PutClassVariableInstr(MetaObject.create(s).getNearestClass(), ((ClassVarDeclNode)node).getName(), v));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, s, v);
                break;
            }
            case GLOBALASGNNODE: {
                s.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case INSTASGNNODE: {
                s.addInstr(new PutFieldInstr(this.getSelf(s), ((InstAsgnNode)node).getName(), v));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                s.addInstr(new CopyInstr(this.getScopeNDown(s, depth).getLocalVariable(localVariable.getName()), (Operand)v));
                break;
            }
            case MULTIPLEASGNNODE: {
                this.buildMultipleAsgnAssignment((MultipleAsgnNode)node, s, v);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildBlockArgsAssignment(Node node, IRScope s, int argIndex, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                this.buildAttrAssignAssignment(node, s, v);
                break;
            }
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getScopeNDown(s, dynamicAsgn.getDepth()).getLocalVariable(dynamicAsgn.getName());
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                break;
            }
            case CLASSVARASGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                s.addInstr(new PutClassVariableInstr(MetaObject.create(s).getNearestClass(), ((ClassVarAsgnNode)node).getName(), v));
                break;
            }
            case CLASSVARDECLNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                s.addInstr(new PutClassVariableInstr(MetaObject.create(s).getNearestClass(), ((ClassVarDeclNode)node).getName(), v));
                break;
            }
            case CONSTDECLNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                this.buildConstDeclAssignment((ConstDeclNode)node, s, v);
                break;
            }
            case GLOBALASGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                s.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), (Operand)v));
                break;
            }
            case INSTASGNNODE: {
                Variable v = s.getNewTemporaryVariable();
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                s.addInstr(new PutFieldInstr(this.getSelf(s), ((InstAsgnNode)node).getName(), v));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                LocalVariable v = this.getScopeNDown(s, depth).getLocalVariable(localVariable.getName());
                s.addInstr(new ReceiveClosureArgInstr(v, argIndex, isSplat));
                break;
            }
            case MULTIPLEASGNNODE: {
                this.buildMultipleAsgnAssignment((MultipleAsgnNode)node, s, null);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public Operand buildAlias(AliasNode alias2, IRScope s) {
        Operand newName = this.build(alias2.getNewName(), s);
        Operand oldName = this.build(alias2.getOldName(), s);
        Operand[] args2 = new Operand[]{newName, oldName};
        s.addInstr(new RubyInternalCallInstr(null, MethAddr.DEFINE_ALIAS, MetaObject.create(s), args2));
        return Nil.NIL;
    }

    public Operand buildAnd(AndNode andNode, IRScope m) {
        if (andNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(andNode.getFirstNode(), m);
            return this.build(andNode.getSecondNode(), m);
        }
        if (andNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(andNode.getFirstNode(), m);
            return BooleanLiteral.FALSE;
        }
        Variable ret = m.getNewTemporaryVariable();
        Label l = m.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), m);
        m.addInstr(new CopyInstr(ret, BooleanLiteral.FALSE));
        m.addInstr(new BEQInstr(v1, BooleanLiteral.FALSE, l));
        Operand v2 = this.build(andNode.getSecondNode(), m);
        m.addInstr(new CopyInstr(ret, v2));
        m.addInstr(new LABEL_Instr(l));
        return ret;
    }

    public Operand buildArray(Node node, IRScope m) {
        ArrayList<Operand> elts = new ArrayList<Operand>();
        for (Node e : node.childNodes()) {
            elts.add(this.build(e, m));
        }
        return new Array(elts);
    }

    public Operand buildArgsCat(ArgsCatNode argsCatNode, IRScope s) {
        Operand v1 = this.build(argsCatNode.getFirstNode(), s);
        Operand v2 = this.build(argsCatNode.getSecondNode(), s);
        return new CompoundArray(v1, v2);
    }

    public Operand buildArgsPush(ArgsPushNode node, IRScope m) {
        throw new NotCompilableException("ArgsPush should never be encountered bare in 1.8");
    }

    private Operand buildAttrAssign(AttrAssignNode attrAssignNode, IRScope s) {
        List<Operand> args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), s);
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s);
        s.addInstr(new AttrAssignInstr(obj, new StringLiteral(attrAssignNode.getName()), args2));
        return args2.get(args2.size() - 1);
    }

    public Operand buildAttrAssignAssignment(Node node, IRScope s, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        List<Operand> args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), s);
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s);
        s.addInstr(new AttrAssignInstr(obj, new StringLiteral(attrAssignNode.getName()), args2, value2));
        return value2;
    }

    public Operand buildBackref(BackRefNode node, IRScope m) {
        return new Backref(node.getType());
    }

    public Operand buildBegin(BeginNode beginNode, IRScope s) {
        return this.build(beginNode.getBodyNode(), s);
    }

    public Operand buildBignum(BignumNode node, IRScope s) {
        return new Fixnum(node.getValue());
    }

    public Operand buildBlock(BlockNode node, IRScope s) {
        Operand retVal = null;
        for (Node child : node.childNodes()) {
            retVal = this.build(child, s);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode breakNode, IRExecutionScope s) {
        Operand rv = this.build(breakNode.getValueNode(), s);
        if (s instanceof IRClosure) {
            s.addInstr(new BREAK_Instr(rv));
            return rv;
        }
        return new BreakResult(rv, s.getCurrentLoop().loopEndLabel);
    }

    public Operand buildCall(CallNode callNode, IRScope s) {
        Node callArgsNode = callNode.getArgsNode();
        Node receiverNode = callNode.getReceiverNode();
        List<Operand> args2 = this.setupCallArgs(callArgsNode, s);
        Operand block = this.setupCallClosure(callNode.getIterNode(), s);
        Variable callResult = s.getNewTemporaryVariable();
        CallInstr callInstr = new CallInstr(callResult, new MethAddr(callNode.getName()), this.build(receiverNode, s), args2.toArray(new Operand[args2.size()]), block);
        s.addInstr(callInstr);
        return callResult;
    }

    public Operand buildCase(CaseNode caseNode, IRScope m) {
        Operand value2 = this.build(caseNode.getCaseNode(), m);
        Label endLabel = m.getNewLabel();
        Variable result = m.getNewTemporaryVariable();
        CaseInstr caseInstr = new CaseInstr(result, value2, endLabel);
        m.addInstr(caseInstr);
        ArrayList<Operand> variables = new ArrayList<Operand>();
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node node : caseNode.getCases().childNodes()) {
            WhenNode whenNode = (WhenNode)node;
            Label bodyLabel = m.getNewLabel();
            if (whenNode.getExpressionNodes() instanceof ListNode) {
                for (Node expression : ((ListNode)whenNode.getExpressionNodes()).childNodes()) {
                    Variable eqqResult = m.getNewTemporaryVariable();
                    variables.add(eqqResult);
                    labels.add(bodyLabel);
                    m.addInstr(new EQQ_Instr(eqqResult, this.build(expression, m), value2));
                    m.addInstr(new BEQInstr(eqqResult, BooleanLiteral.TRUE, bodyLabel));
                }
            } else {
                Variable eqqResult = m.getNewTemporaryVariable();
                variables.add(eqqResult);
                labels.add(bodyLabel);
                m.addInstr(new EQQ_Instr(eqqResult, this.build(whenNode.getExpressionNodes(), m), value2));
                m.addInstr(new BEQInstr(eqqResult, BooleanLiteral.TRUE, bodyLabel));
            }
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        if (caseNode.getElseNode() != null) {
            Label elseLbl = m.getNewLabel();
            caseInstr.setElse(elseLbl);
            bodies.put(elseLbl, caseNode.getElseNode());
        }
        for (Map.Entry entry : bodies.entrySet()) {
            m.addInstr(new LABEL_Instr((Label)entry.getKey()));
            Operand bodyValue = this.build((Node)entry.getValue(), m);
            Label tgt = endLabel;
            if (bodyValue instanceof BreakResult) {
                BreakResult br = (BreakResult)bodyValue;
                bodyValue = br._result;
                tgt = br._jumpTarget;
            }
            m.addInstr(new CopyInstr(result, bodyValue));
            m.addInstr(new JumpInstr(tgt));
        }
        m.addInstr(new LABEL_Instr(endLabel));
        caseInstr.setLabels(labels);
        caseInstr.setVariables(variables);
        return result;
    }

    public Operand buildClass(ClassNode classNode, IRScope s) {
        Node superNode = classNode.getSuperNode();
        Colon3Node cpathNode = classNode.getCPath();
        Operand superClass = null;
        if (superNode != null) {
            superClass = this.build(superNode, s);
        }
        Operand container = null;
        if (cpathNode instanceof Colon2Node) {
            Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
            if (leftNode != null) {
                container = this.build(leftNode, s);
            }
        } else if (cpathNode instanceof Colon3Node) {
            container = new ClassMetaObject(IRClass.getCoreClass("Object"));
        }
        String className = cpathNode.getName();
        IRClass c = new IRClass(s, container, superClass, className, classNode.getScope());
        s.addClass(c);
        if (container != null) {
            s.addInstr(new PutConstInstr(container, className, (Operand)new ClassMetaObject(c)));
        }
        if (classNode.getBodyNode() != null) {
            this.build(classNode.getBodyNode(), c.getRootMethod());
        }
        return null;
    }

    public Operand buildSClass(SClassNode sclassNode, IRScope s) {
        Operand receiver2 = this.build(sclassNode.getReceiverNode(), s);
        IRMetaClass mc = new IRMetaClass(s, receiver2, sclassNode.getScope());
        s.addClass(mc);
        if (sclassNode.getBodyNode() != null) {
            this.build(sclassNode.getBodyNode(), mc.getRootMethod());
        }
        return null;
    }

    public Operand buildClassVar(ClassVarNode node, IRScope s) {
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new GetClassVariableInstr(ret, MetaObject.create(s).getNearestClass(), node.getName()));
        return ret;
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode classVarAsgnNode, IRScope s) {
        Operand val = this.build(classVarAsgnNode.getValueNode(), s);
        s.addInstr(new PutClassVariableInstr(MetaObject.create(s).getNearestClass(), classVarAsgnNode.getName(), val));
        return val;
    }

    public Operand buildClassVarDecl(ClassVarDeclNode classVarDeclNode, IRScope s) {
        Operand val = this.build(classVarDeclNode.getValueNode(), s);
        s.addInstr(new PutClassVariableInstr(MetaObject.create(s).getNearestClass(), classVarDeclNode.getName(), val));
        return val;
    }

    public Operand buildConstDecl(ConstDeclNode node, IRScope s) {
        Operand val = this.build(node.getValueNode(), s);
        return this.buildConstDeclAssignment(node, s, val);
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, IRScope s, Operand val) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            s.setConstantValue(constDeclNode.getName(), val);
        } else if (constNode.getNodeType() == NodeType.COLON2NODE) {
            Operand module = this.build(((Colon2Node)constNode).getLeftNode(), s);
            s.addInstr(new PutConstInstr(module, constDeclNode.getName(), val));
        } else {
            s.addInstr(new PutConstInstr(this.getSelf(s), constDeclNode.getName(), val));
        }
        return val;
    }

    private Operand loadConst(IRScope s, IRScope currScope, String name2) {
        Operand cv = s.getConstantValue(name2);
        if (cv == null) {
            Variable v = currScope.getNewTemporaryVariable();
            currScope.addInstr(new GetConstInstr(v, s, name2));
            cv = v;
        }
        return cv;
    }

    public Operand buildConst(ConstNode node, IRScope s) {
        return this.loadConst(s, s, node.getName());
    }

    public Operand buildColon2(Colon2Node iVisited, IRScope s) {
        Node leftNode = iVisited.getLeftNode();
        String name2 = iVisited.getName();
        if (leftNode == null) {
            return this.loadConst(s, s, name2);
        }
        if (iVisited instanceof Colon2ConstNode) {
            Operand module = this.build(iVisited.getLeftNode(), s);
            if (module instanceof MetaObject) {
                return this.loadConst(((MetaObject)module).scope, s, name2);
            }
            Variable constVal = s.getNewTemporaryVariable();
            s.addInstr(new GetConstInstr(constVal, module, name2));
            return constVal;
        }
        if (iVisited instanceof Colon2MethodNode) {
            Colon2MethodNode c2mNode = (Colon2MethodNode)iVisited;
            List<Operand> args2 = this.setupCallArgs(null, s);
            Operand block = this.setupCallClosure(null, s);
            Variable callResult = s.getNewTemporaryVariable();
            CallInstr callInstr = new CallInstr(callResult, new MethAddr(c2mNode.getName()), null, args2.toArray(new Operand[args2.size()]), block);
            s.addInstr(callInstr);
            return callResult;
        }
        throw new NotCompilableException("Not compilable: " + iVisited);
    }

    public Operand buildColon3(Colon3Node node, IRScope s) {
        Variable cv = s.getNewTemporaryVariable();
        s.addInstr(new GetConstInstr(cv, this.getSelf(s), node.getName()));
        return cv;
    }

    public Operand buildGetDefinitionBase(Node node, IRScope m) {
        switch (node.getNodeType()) {
            case BACKREFNODE: 
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case CONSTNODE: 
            case DASGNNODE: 
            case DVARNODE: 
            case FALSENODE: 
            case FCALLNODE: 
            case GLOBALASGNNODE: 
            case GLOBALVARNODE: 
            case INSTVARNODE: 
            case LOCALASGNNODE: 
            case LOCALVARNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: 
            case SELFNODE: 
            case TRUENODE: 
            case VCALLNODE: 
            case YIELDNODE: {
                return this.buildGetDefinition(node, m);
            }
        }
        throw new NotCompilableException(node + " is not yet IR-compilable in buildGetDefinitionBase");
    }

    public Operand buildDefined(Node node, IRScope m) {
        return this.buildGetDefinitionBase(((DefinedNode)node).getExpressionNode(), m);
    }

    public Operand buildGetArgumentDefinition(Node node, IRScope m, String type2) {
        if (node == null) {
            return new StringLiteral(type2);
        }
        Label failLabel = m.getNewLabel();
        Label doneLabel = m.getNewLabel();
        Variable rv = m.getNewTemporaryVariable();
        if (node instanceof ArrayNode) {
            for (int i = 0; i < ((ArrayNode)node).size(); ++i) {
                Node iterNode = ((ArrayNode)node).get(i);
                Operand def = this.buildGetDefinition(iterNode, m);
                m.addInstr(new BEQInstr(def, Nil.NIL, failLabel));
            }
        } else {
            Operand def = this.buildGetDefinition(node, m);
            m.addInstr(new BEQInstr(def, Nil.NIL, failLabel));
        }
        m.addInstr(new CopyInstr(rv, new StringLiteral(type2)));
        m.addInstr(new JumpInstr(doneLabel));
        m.addInstr(new LABEL_Instr(failLabel));
        m.addInstr(new CopyInstr(rv, Nil.NIL));
        m.addInstr(new LABEL_Instr(doneLabel));
        return rv;
    }

    private Operand buildDefinitionCheck(IRScope s, Operand receiver2, String nameToCheck, String definitionCheckerMethod, String definedReturnValue) {
        Label undefLabel = s.getNewLabel();
        Label defLabel = s.getNewLabel();
        Variable tmpVar = s.getNewTemporaryVariable();
        StringLiteral mName = new StringLiteral(nameToCheck);
        JRubyImplCallInstr callInstr = new JRubyImplCallInstr(tmpVar, new MethAddr(definitionCheckerMethod), receiver2, new Operand[]{mName, BooleanLiteral.FALSE});
        s.addInstr(callInstr);
        s.addInstr(new BEQInstr(tmpVar, BooleanLiteral.FALSE, undefLabel));
        s.addInstr(new CopyInstr(tmpVar, new StringLiteral(definedReturnValue)));
        s.addInstr(new JumpInstr(defLabel));
        s.addInstr(new LABEL_Instr(undefLabel));
        s.addInstr(new CopyInstr(tmpVar, Nil.NIL));
        s.addInstr(new LABEL_Instr(defLabel));
        return tmpVar;
    }

    public Operand buildGetDefinition(Node node, IRScope s) {
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: {
                return new StringLiteral("assignment");
            }
            case DVARNODE: {
                return new StringLiteral("local-variable(in-block)");
            }
            case FALSENODE: {
                return new StringLiteral("false");
            }
            case TRUENODE: {
                return new StringLiteral("true");
            }
            case LOCALVARNODE: {
                return new StringLiteral("local-variable");
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return new StringLiteral("method");
            }
            case NILNODE: {
                return new StringLiteral("nil");
            }
            case SELFNODE: {
                return new StringLiteral("self");
            }
            case VCALLNODE: {
                Variable tmp = s.getNewTemporaryVariable();
                s.addInstr(new JRubyImplCallInstr(tmp, new MethAddr("getMetaClass"), this.getSelf(s), new Operand[0]));
                return this.buildDefinitionCheck(s, tmp, ((VCallNode)node).getName(), "isMethodBound", "method");
            }
            case CONSTNODE: {
                Operand receiver2 = null;
                return this.buildDefinitionCheck(s, receiver2, ((ConstNode)node).getName(), "getConstantDefined", "constant");
            }
            case GLOBALVARNODE: {
                Operand receiver3 = null;
                Variable tmp = s.getNewTemporaryVariable();
                s.addInstr(new CallInstr(tmp, new MethAddr("getGlobalVariables"), receiver3, new Operand[0], null));
                return this.buildDefinitionCheck(s, tmp, ((GlobalVarNode)node).getName(), "isDefined", "global-variable");
            }
            case INSTVARNODE: {
                Variable tmp = s.getNewTemporaryVariable();
                s.addInstr(new CallInstr(tmp, new MethAddr("getInstanceVariables"), this.getSelf(s), new Operand[0], null));
                return this.buildDefinitionCheck(s, tmp, ((InstVarNode)node).getName(), "fastHasinstanceVariable", "instance-variable");
            }
            case FCALLNODE: {
                Variable tmpVar = s.getNewTemporaryVariable();
                s.addInstr(new JRubyImplCallInstr(tmpVar, new MethAddr("getMetaClass"), this.getSelf(s), new Operand[0]));
                Label undefLabel = s.getNewLabel();
                Label defLabel = s.getNewLabel();
                StringLiteral mName = new StringLiteral(((FCallNode)node).getName());
                JRubyImplCallInstr callInstr = new JRubyImplCallInstr(tmpVar, new MethAddr("isMethodBound"), tmpVar, new Operand[]{mName, BooleanLiteral.FALSE});
                s.addInstr(callInstr);
                s.addInstr(new BEQInstr(tmpVar, BooleanLiteral.FALSE, undefLabel));
                s.addInstr(new CopyInstr(tmpVar, this.buildGetArgumentDefinition(((FCallNode)node).getArgsNode(), s, "method")));
                s.addInstr(new JumpInstr(defLabel));
                s.addInstr(new LABEL_Instr(undefLabel));
                s.addInstr(new CopyInstr(tmpVar, Nil.NIL));
                s.addInstr(new LABEL_Instr(defLabel));
                return tmpVar;
            }
        }
        throw new NotCompilableException(node + " is not yet IR-compilable in buildGetDefinition.");
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode, IRScope s) {
        int depth = dasgnNode.getDepth();
        LocalVariable arg2 = this.getScopeNDown(s, depth).getLocalVariable(dasgnNode.getName());
        s.addInstr(new CopyInstr(arg2, this.build(dasgnNode.getValueNode(), s)));
        return arg2;
    }

    private IRScope getScopeNDown(IRScope current2, int depth) {
        for (int i = 0; i < depth; ++i) {
            current2.getLexicalParent();
        }
        return current2;
    }

    private void defineNewMethod(MethodDefNode defNode, IRScope s, Operand container, boolean isInstanceMethod) {
        IRMethod method2 = new IRMethod(s, container, defNode.getName(), isInstanceMethod, defNode.getScope());
        this.receiveArgs(defNode.getArgsNode(), method2);
        if (defNode.getBodyNode() != null) {
            Operand rv;
            Node bodyNode = defNode.getBodyNode();
            Operand operand = rv = bodyNode instanceof RescueNode ? this.buildRescueInternal(bodyNode, method2) : this.build(bodyNode, method2);
            if (rv != null) {
                method2.addInstr(new ReturnInstr(rv));
            }
        } else {
            method2.addInstr(new ReturnInstr(Nil.NIL));
        }
        IRModule methodHolder = s.getNearestModule();
        methodHolder.addMethod(method2);
    }

    public Operand buildDefn(MethodDefNode node, IRScope s) {
        this.defineNewMethod(node, s, MetaObject.create(s), true);
        return null;
    }

    public Operand buildDefs(DefsNode node, IRScope s) {
        this.defineNewMethod(node, s, this.build(node.getReceiverNode(), s), false);
        return null;
    }

    public Operand receiveArgs(ArgsNode argsNode, IRScope s) {
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        s.addInstr(new ReceiveSelfInstruction(this.getSelf(s)));
        int argIndex = 0;
        ListNode preArgs = argsNode.getPre();
        int i = 0;
        while (i < required) {
            ArgumentNode a = (ArgumentNode)preArgs.get(i);
            if (a instanceof TypedArgumentNode) {
                TypedArgumentNode t = (TypedArgumentNode)a;
                s.addInstr(new DECLARE_LOCAL_TYPE_Instr(argIndex, this.buildType(t.getTypeNode())));
            }
            s.addInstr(new ReceiveArgumentInstruction(s.getLocalVariable(a.getName()), argIndex));
            ++i;
            ++argIndex;
        }
        if (argsNode.getBlock() != null) {
            s.addInstr(new ReceiveClosureInstr(s.getLocalVariable(argsNode.getBlock().getName())));
        }
        if (opt > 0 || rest2 > -1) {
            ListNode optArgs = argsNode.getOptArgs();
            int j = 0;
            while (j < opt) {
                Label l = s.getNewLabel();
                LocalAsgnNode n = (LocalAsgnNode)optArgs.get(j);
                s.addInstr(new ReceiveOptionalArgumentInstr(s.getLocalVariable(n.getName()), argIndex, l));
                this.build(n, s);
                s.addInstr(new LABEL_Instr(l));
                ++j;
                ++argIndex;
            }
            if (rest2 > -1) {
                s.addInstr(new ReceiveArgumentInstruction(s.getLocalVariable(argsNode.getRestArgNode().getName()), argIndex, true));
                ++argIndex;
            }
        }
        return null;
    }

    public String buildType(Node typeNode) {
        switch (typeNode.getNodeType()) {
            case CONSTNODE: {
                return ((ConstNode)typeNode).getName();
            }
            case SYMBOLNODE: {
                return ((SymbolNode)typeNode).getName();
            }
        }
        return "unknown_type";
    }

    public Operand buildDot(DotNode dotNode, IRScope s) {
        return new Range(this.build(dotNode.getBeginNode(), s), this.build(dotNode.getEndNode(), s), dotNode.isExclusive());
    }

    public Operand buildDRegexp(DRegexpNode dregexpNode, IRScope s) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : dregexpNode.childNodes()) {
            strPieces.add(this.build(n, s));
        }
        return new Regexp(new CompoundString(strPieces), dregexpNode.getOptions());
    }

    public Operand buildDStr(DStrNode dstrNode, IRScope s) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : dstrNode.childNodes()) {
            strPieces.add(this.build(n, s));
        }
        return new CompoundString(strPieces);
    }

    public Operand buildDSymbol(Node node, IRScope s) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : node.childNodes()) {
            strPieces.add(this.build(n, s));
        }
        return new DynamicSymbol(new CompoundString(strPieces));
    }

    public Operand buildDVar(DVarNode node, IRScope m) {
        return m.getLocalVariable(node.getName());
    }

    public Operand buildDXStr(DXStrNode dstrNode, IRScope m) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node nextNode : dstrNode.childNodes()) {
            strPieces.add(this.build(nextNode, m));
        }
        return new BacktickString(strPieces);
    }

    public Operand buildEnsureNode(Node node, IRScope m) {
        Nil ensureRetVal;
        Operand rv;
        EnsureBlockInfo ebi = new EnsureBlockInfo(m);
        this._ensureBlockStack.push(ebi);
        EnsureNode ensureNode = (EnsureNode)node;
        Node bodyNode = ensureNode.getBodyNode();
        Operand operand = rv = bodyNode instanceof RescueNode ? this.buildRescueInternal(bodyNode, m) : this.build(bodyNode, m);
        if (ebi.noFallThru) {
            m.addInstr(new LABEL_Instr(ebi.start));
        }
        this._ensureBlockStack.pop();
        Operand operand2 = ensureRetVal = ensureNode.getEnsureNode() == null ? Nil.NIL : this.build(ensureNode.getEnsureNode(), m);
        if (ensureRetVal == null) {
            rv = null;
        }
        if (ebi.noFallThru) {
            m.addInstr(new JUMP_INDIRECT_Instr(ebi.returnAddr));
            if (ebi.endLabelNeeded) {
                m.addInstr(new LABEL_Instr(ebi.end));
            }
        }
        return rv;
    }

    public Operand buildEvStr(EvStrNode node, IRScope s) {
        return this.build(node.getBody(), s);
    }

    public Operand buildFalse(Node node, IRScope s) {
        s.addInstr(new ThreadPollInstr());
        return BooleanLiteral.FALSE;
    }

    public Operand buildFCall(FCallNode fcallNode, IRScope s) {
        Node callArgsNode = fcallNode.getArgsNode();
        List<Operand> args2 = this.setupCallArgs(callArgsNode, s);
        Operand block = this.setupCallClosure(fcallNode.getIterNode(), s);
        Variable callResult = s.getNewTemporaryVariable();
        CallInstr callInstr = new CallInstr(callResult, new MethAddr(fcallNode.getName()), this.getSelf(s), args2.toArray(new Operand[args2.size()]), block);
        s.addInstr(callInstr);
        return callResult;
    }

    private Operand setupCallClosure(Node node, IRScope s) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build((IterNode)node, s);
            }
            case BLOCKPASSNODE: {
                return this.build(((BlockPassNode)node).getBodyNode(), s);
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public Operand buildFixnum(FixnumNode node, IRScope m) {
        return new Fixnum(node.getValue());
    }

    public Operand buildFloat(FloatNode node, IRScope m) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode forNode, IRExecutionScope m) {
        Variable ret = m.getNewTemporaryVariable();
        Operand receiver2 = this.build(forNode.getIterNode(), m);
        Operand forBlock = this.buildForIter(forNode, m);
        m.addInstr(new RubyInternalCallInstr(ret, MethAddr.FOR_EACH, receiver2, new Operand[0], forBlock));
        return ret;
    }

    public Operand buildForIter(ForNode forNode, IRExecutionScope s) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure((IRScope)s, forNode.getScope(), Arity.procArityOf(forNode.getVarNode()), forNode.getArgumentType());
        s.addClosure(closure);
        NodeType argsNodeId = null;
        if (forNode.getVarNode() != null && (argsNodeId = forNode.getVarNode().getNodeType()) != null) {
            this.buildBlockArgsAssignment(forNode.getVarNode(), closure, 0, false);
        }
        Operand operand = closureRetVal = forNode.getBodyNode() == null ? Nil.NIL : this.build(forNode.getBodyNode(), closure);
        if (closureRetVal != null) {
            closure.addInstr(new ClosureReturnInstr(closureRetVal));
        }
        return new ClosureMetaObject(closure);
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode globalAsgnNode, IRScope m) {
        Operand value2 = this.build(globalAsgnNode.getValueNode(), m);
        m.addInstr(new PutGlobalVarInstr(globalAsgnNode.getName(), value2));
        return value2;
    }

    public Operand buildGlobalVar(GlobalVarNode node, IRScope m) {
        Variable rv = m.getNewTemporaryVariable();
        m.addInstr(new GetGlobalVariableInstr(rv, node.getName()));
        return rv;
    }

    public Operand buildHash(HashNode hashNode, IRScope m) {
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            return new Hash(new ArrayList<KeyValuePair>());
        }
        boolean i = false;
        Operand key2 = null;
        Object value2 = null;
        ArrayList<KeyValuePair> args2 = new ArrayList<KeyValuePair>();
        for (Node nextNode : hashNode.getListNode().childNodes()) {
            Operand v = this.build(nextNode, m);
            if (key2 == null) {
                key2 = v;
                continue;
            }
            args2.add(new KeyValuePair(key2, v));
            key2 = null;
        }
        return new Hash(args2);
    }

    public Operand buildIf(IfNode ifNode, IRScope s) {
        Node actualCondition = this.skipOverNewlines(s, ifNode.getCondition());
        Variable result = s.getNewTemporaryVariable();
        Label falseLabel = s.getNewLabel();
        Label doneLabel = s.getNewLabel();
        Operand thenResult = null;
        s.addInstr(new BEQInstr(this.build(actualCondition, s), BooleanLiteral.FALSE, falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        if (ifNode.getThenBody() != null) {
            thenResult = this.build(ifNode.getThenBody(), s);
            if (thenResult != null) {
                Label tgt = doneLabel;
                if (thenResult instanceof BreakResult) {
                    BreakResult br = (BreakResult)thenResult;
                    thenResult = br._result;
                    tgt = br._jumpTarget;
                }
                s.addInstr(new CopyInstr(result, thenResult));
                s.addInstr(new JumpInstr(tgt));
            } else {
                thenNull = true;
            }
        } else {
            s.addInstr(new CopyInstr(result, Nil.NIL));
            s.addInstr(new JumpInstr(doneLabel));
        }
        s.addInstr(new LABEL_Instr(falseLabel));
        if (ifNode.getElseBody() != null) {
            Operand elseResult = this.build(ifNode.getElseBody(), s);
            if (elseResult != null) {
                s.addInstr(new CopyInstr(result, elseResult));
            } else {
                elseNull = true;
            }
        } else {
            s.addInstr(new CopyInstr(result, Nil.NIL));
        }
        if (thenNull && elseNull) {
            return null;
        }
        s.addInstr(new LABEL_Instr(doneLabel));
        return result;
    }

    public Operand buildInstAsgn(InstAsgnNode instAsgnNode, IRScope s) {
        Operand val = this.build(instAsgnNode.getValueNode(), s);
        s.addInstr(new PutFieldInstr(this.getSelf(s), instAsgnNode.getName(), val));
        return val;
    }

    public Operand buildInstVar(InstVarNode node, IRScope m) {
        Variable ret = m.getNewTemporaryVariable();
        m.addInstr(new GetFieldInstr(ret, this.getSelf(m), node.getName()));
        return ret;
    }

    public Operand buildIter(IterNode iterNode, IRExecutionScope s) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure((IRScope)s, iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()), iterNode.getArgumentType());
        s.addClosure(closure);
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        if (iterNode.getVarNode() != null && argsNodeId != null) {
            this.buildBlockArgsAssignment(iterNode.getVarNode(), closure, 0, false);
        }
        Operand operand = closureRetVal = iterNode.getBodyNode() == null ? Nil.NIL : this.build(iterNode.getBodyNode(), closure);
        if (closureRetVal != null) {
            closure.addInstr(new ClosureReturnInstr(closureRetVal));
        }
        return new ClosureMetaObject(closure);
    }

    public Operand buildLiteral(LiteralNode literalNode, IRScope s) {
        return new StringLiteral(literalNode.getName());
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode, IRScope s) {
        Operand value2 = this.build(localAsgnNode.getValueNode(), s);
        s.addInstr(new CopyInstr(s.getLocalVariable(localAsgnNode.getName()), value2));
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node, IRScope s) {
        return s.getLocalVariable(node.getName());
    }

    public Operand buildMatch(MatchNode matchNode, IRScope m) {
        Operand regexp2 = this.build(matchNode.getRegexpNode(), m);
        return this.generateJRubyUtilityCall(m, MethAddr.MATCH, regexp2, new Operand[0]);
    }

    public Operand buildMatch2(Match2Node matchNode, IRScope m) {
        Operand receiver2 = this.build(matchNode.getReceiverNode(), m);
        Operand value2 = this.build(matchNode.getValueNode(), m);
        return this.generateJRubyUtilityCall(m, MethAddr.MATCH2, receiver2, new Operand[]{value2});
    }

    public Operand buildMatch3(Match3Node matchNode, IRScope m) {
        Operand receiver2 = this.build(matchNode.getReceiverNode(), m);
        Operand value2 = this.build(matchNode.getValueNode(), m);
        return this.generateJRubyUtilityCall(m, MethAddr.MATCH3, receiver2, new Operand[]{value2});
    }

    public Operand buildModule(ModuleNode moduleNode, IRScope s) {
        Colon3Node cpathNode = moduleNode.getCPath();
        Operand container = null;
        if (cpathNode instanceof Colon2Node) {
            Node leftNode = ((Colon2Node)cpathNode).getLeftNode();
            if (leftNode != null) {
                container = this.build(leftNode, s);
            }
        } else if (cpathNode instanceof Colon3Node) {
            container = new ClassMetaObject(IRClass.getCoreClass("Object"));
        }
        String moduleName = moduleNode.getCPath().getName();
        IRModule m = new IRModule(s, container, moduleName, moduleNode.getScope());
        s.addModule(m);
        if (container != null) {
            s.addInstr(new PutConstInstr(container, moduleName, (Operand)new ModuleMetaObject(m)));
        }
        if (moduleNode.getBodyNode() != null) {
            this.build(moduleNode.getBodyNode(), m.getRootMethod());
        }
        return null;
    }

    public Operand buildMultipleAsgn(MultipleAsgnNode multipleAsgnNode, IRScope s) {
        Operand values = this.build(multipleAsgnNode.getValueNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new CopyInstr(ret, values));
        this.buildMultipleAsgnAssignment(multipleAsgnNode, s, ret);
        return ret;
    }

    public void buildMultipleAsgnAssignment(MultipleAsgnNode multipleAsgnNode, IRScope s, Operand values) {
        Node an;
        ListNode sourceArray = multipleAsgnNode.getHeadNode();
        int i = 0;
        if (sourceArray != null) {
            ListNode headNode = sourceArray;
            for (Node an2 : headNode.childNodes()) {
                if (values == null) {
                    this.buildBlockArgsAssignment(an2, s, i, false);
                } else {
                    this.buildAssignment(an2, s, values, i, false);
                }
                ++i;
            }
        }
        if ((an = multipleAsgnNode.getArgsNode()) == null) {
            if (sourceArray == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
        } else if (!(an instanceof StarNode)) {
            if (values != null) {
                this.buildAssignment(an, s, values, i, true);
            } else {
                this.buildBlockArgsAssignment(an, s, i, true);
            }
        }
    }

    public Operand buildNewline(NewlineNode node, IRScope s) {
        return this.build(this.skipOverNewlines(s, node), s);
    }

    public Operand buildNext(NextNode nextNode, IRExecutionScope s) {
        Nil rv = nextNode.getValueNode() == null ? Nil.NIL : this.build(nextNode.getValueNode(), s);
        s.addInstr(new ThreadPollInstr());
        s.addInstr(s instanceof IRClosure ? new ClosureReturnInstr(rv) : new JumpInstr(s.getCurrentLoop().iterEndLabel));
        return rv;
    }

    public Operand buildNthRef(NthRefNode nthRefNode, IRScope m) {
        return new NthRef(nthRefNode.getMatchNumber());
    }

    public Operand buildNil(Node node, IRScope m) {
        m.addInstr(new ThreadPollInstr());
        return Nil.NIL;
    }

    public Operand buildNot(NotNode node, IRScope m) {
        Variable ret = m.getNewTemporaryVariable();
        m.addInstr(new NotInstr(ret, this.build(node.getConditionNode(), m)));
        return ret;
    }

    public Operand buildOpAsgn(OpAsgnNode opAsgnNode, IRScope s) {
        if (opAsgnNode.getOperatorName().equals("||") || opAsgnNode.getOperatorName().equals("&&")) {
            throw new NotCompilableException("Unknown node encountered in builder: " + opAsgnNode);
        }
        Operand v1 = this.build(opAsgnNode.getReceiverNode(), s);
        Variable getResult = s.getNewTemporaryVariable();
        CallInstr callInstr = new CallInstr(getResult, new MethAddr(opAsgnNode.getVariableName()), v1, new Operand[0], null);
        s.addInstr(callInstr);
        Operand v2 = this.build(opAsgnNode.getValueNode(), s);
        Variable setValue2 = s.getNewTemporaryVariable();
        callInstr = new CallInstr(setValue2, new MethAddr(opAsgnNode.getOperatorName()), getResult, new Operand[]{v2}, null);
        s.addInstr(callInstr);
        Variable setResult = s.getNewTemporaryVariable();
        callInstr = new CallInstr(setResult, new MethAddr(opAsgnNode.getVariableNameAsgn()), v1, new Operand[]{setValue2}, null);
        s.addInstr(callInstr);
        return setResult;
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode andNode, IRScope s) {
        Label l = s.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), s);
        Variable f = s.getNewTemporaryVariable();
        s.addInstr(new IsTrueInstr(f, v1));
        s.addInstr(new BEQInstr(f, BooleanLiteral.FALSE, l));
        this.build(andNode.getSecondNode(), s);
        s.addInstr(new LABEL_Instr(l));
        s.addInstr(new ThreadPollInstr());
        return v1;
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode, IRScope s) {
        Operand v1;
        Label l1 = s.getNewLabel();
        Label l2 = null;
        Variable f = s.getNewTemporaryVariable();
        boolean needsDefnCheck = this.needsDefinitionCheck(orNode.getFirstNode());
        if (needsDefnCheck) {
            l2 = s.getNewLabel();
            v1 = this.buildGetDefinitionBase(orNode.getFirstNode(), s);
            s.addInstr(new BEQInstr(v1, Nil.NIL, l2));
        }
        v1 = this.build(orNode.getFirstNode(), s);
        s.addInstr(new IsTrueInstr(f, v1));
        s.addInstr(new BEQInstr(f, BooleanLiteral.TRUE, l1));
        if (needsDefnCheck) {
            s.addInstr(new LABEL_Instr(l2));
        }
        this.build(orNode.getSecondNode(), s);
        s.addInstr(new LABEL_Instr(l1));
        s.addInstr(new ThreadPollInstr());
        return v1;
    }

    private boolean needsDefinitionCheck(Node node) {
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case DVARNODE: 
            case FALSENODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case LOCALVARNODE: 
            case MATCH2NODE: 
            case MATCH3NODE: 
            case MULTIPLEASGNNODE: 
            case NILNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: 
            case SELFNODE: 
            case TRUENODE: {
                return false;
            }
        }
        return true;
    }

    public Operand buildOpElementAsgn(Node node, IRScope m) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        if (opElementAsgnNode.getOperatorName() == "||") {
            return this.buildOpElementAsgnWithOr(node, m);
        }
        if (opElementAsgnNode.getOperatorName() == "&&") {
            return this.buildOpElementAsgnWithAnd(node, m);
        }
        return this.buildOpElementAsgnWithMethod(node, m);
    }

    public Operand buildOpElementAsgnWithOr(Node node, IRScope s) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s);
        Label l = s.getNewLabel();
        Variable elt = s.getNewTemporaryVariable();
        Variable flag = s.getNewTemporaryVariable();
        List<Operand> args2 = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s);
        assert (args2.size() == 1);
        Operand index2 = args2.get(0);
        s.addInstr(new CallInstr(elt, new MethAddr("[]"), array, new Operand[]{index2}, null));
        s.addInstr(new IsTrueInstr(flag, (Operand)elt));
        s.addInstr(new BEQInstr(flag, BooleanLiteral.TRUE, l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s);
        s.addInstr(new CallInstr(elt, new MethAddr("[]="), array, new Operand[]{index2, value2}, null));
        s.addInstr(new CopyInstr(elt, value2));
        s.addInstr(new LABEL_Instr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithAnd(Node node, IRScope s) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s);
        Label l = s.getNewLabel();
        Variable elt = s.getNewTemporaryVariable();
        Variable flag = s.getNewTemporaryVariable();
        List<Operand> args2 = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s);
        assert (args2.size() == 1);
        Operand index2 = args2.get(0);
        s.addInstr(new CallInstr(elt, new MethAddr("[]"), array, new Operand[]{index2}, null));
        s.addInstr(new IsTrueInstr(flag, (Operand)elt));
        s.addInstr(new BEQInstr(flag, BooleanLiteral.FALSE, l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s);
        s.addInstr(new CallInstr(elt, new MethAddr("[]="), array, new Operand[]{index2, value2}, null));
        s.addInstr(new CopyInstr(elt, value2));
        s.addInstr(new LABEL_Instr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithMethod(Node node, IRScope s) {
        OpElementAsgnNode opElementAsgnNode = (OpElementAsgnNode)node;
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s);
        List<Operand> args2 = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s);
        assert (args2.size() == 1);
        Operand index2 = args2.get(0);
        Variable elt = s.getNewTemporaryVariable();
        s.addInstr(new CallInstr(elt, new MethAddr("[]"), array, new Operand[]{index2}, null));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s);
        String operation = opElementAsgnNode.getOperatorName();
        s.addInstr(new CallInstr(elt, new MethAddr(operation), elt, new Operand[]{value2}, null));
        Variable tmp = s.getNewTemporaryVariable();
        s.addInstr(new CallInstr(tmp, new MethAddr("[]="), array, new Operand[]{index2, elt}, null));
        return elt;
    }

    public Operand buildOr(OrNode orNode, IRScope m) {
        if (orNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(orNode.getFirstNode(), m);
            return BooleanLiteral.TRUE;
        }
        if (orNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(orNode.getFirstNode(), m);
            return this.build(orNode.getSecondNode(), m);
        }
        Variable ret = m.getNewTemporaryVariable();
        Label l = m.getNewLabel();
        Operand v1 = this.build(orNode.getFirstNode(), m);
        m.addInstr(new CopyInstr(ret, BooleanLiteral.TRUE));
        m.addInstr(new BEQInstr(v1, BooleanLiteral.TRUE, l));
        Operand v2 = this.build(orNode.getSecondNode(), m);
        m.addInstr(new CopyInstr(ret, v2));
        m.addInstr(new LABEL_Instr(l));
        return ret;
    }

    public Operand buildRedo(Node node, IRExecutionScope s) {
        s.addInstr(new JumpInstr(s instanceof IRClosure ? ((IRClosure)s).startLabel : s.getCurrentLoop().iterStartLabel));
        return Nil.NIL;
    }

    public Operand buildRegexp(RegexpNode reNode, IRScope m) {
        return new Regexp(new StringLiteral(reNode.getValue()), reNode.getOptions());
    }

    public Operand buildRescue(Node node, IRScope m) {
        return this.buildRescueInternal(node, m);
    }

    private Operand buildRescueInternal(Node node, IRScope m) {
        RescueNode rescueNode = (RescueNode)node;
        boolean noEnsure = this._ensureBlockStack.empty();
        Label rBeginLabel = m.getNewLabel();
        Label rEndLabel = noEnsure ? m.getNewLabel() : this._ensureBlockStack.peek().end;
        Label elseLabel = rescueNode.getElseNode() == null ? null : m.getNewLabel();
        ArrayList<Label> rescueBlockLabels = new ArrayList<Label>();
        m.addInstr(new LABEL_Instr(rBeginLabel));
        RESCUED_BODY_START_MARKER_Instr rbStartInstr = new RESCUED_BODY_START_MARKER_Instr(rBeginLabel, elseLabel, rEndLabel, rescueBlockLabels);
        m.addInstr(rbStartInstr);
        Operand tmp = Nil.NIL;
        Variable rv = m.getNewTemporaryVariable();
        if (rescueNode.getBodyNode() != null) {
            tmp = this.build(rescueNode.getBodyNode(), m);
        }
        if (elseLabel != null) {
            m.addInstr(new LABEL_Instr(elseLabel));
            tmp = this.build(rescueNode.getElseNode(), m);
        }
        if (tmp != null) {
            m.addInstr(new CopyInstr(rv, tmp));
            if (noEnsure) {
                m.addInstr(new JumpInstr(rEndLabel));
            } else {
                EnsureBlockInfo ebi = this._ensureBlockStack.peek();
                ebi.endLabelNeeded = true;
                ebi.noFallThru = true;
                m.addInstr(new SET_RETADDR_Instr(ebi.returnAddr, ebi.end));
                m.addInstr(new JumpInstr(ebi.start));
            }
        } else {
            rv = null;
        }
        RESCUED_BODY_END_MARKER_Instr rbEndInstr = new RESCUED_BODY_END_MARKER_Instr();
        m.addInstr(rbEndInstr);
        Label rbLabel = m.getNewLabel();
        rescueBlockLabels.add(rbLabel);
        m.addInstr(new LABEL_Instr(rbLabel));
        this.buildRescueBodyInternal(m, rescueNode.getRescueNode(), rv, rEndLabel, rescueBlockLabels);
        if (noEnsure) {
            m.addInstr(new LABEL_Instr(rEndLabel));
        }
        return rv;
    }

    private void buildRescueBodyInternal(IRScope m, Node node, Variable rv, Label endLabel, List<Label> rescueBlockLabels) {
        Node realBody;
        Operand x;
        RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        boolean haveEnsureBlocks = !this._ensureBlockStack.empty();
        Variable exc = m.getNewTemporaryVariable();
        m.addInstr(new RECV_EXCEPTION_Instr(exc));
        Operand excType = exceptionList == null ? null : this.build(exceptionList, m);
        Label uncaughtLabel = null;
        if (excType != null) {
            uncaughtLabel = m.getNewLabel();
            Variable eqqResult = m.getNewTemporaryVariable();
            m.addInstr(new EQQ_Instr(eqqResult, exc, excType));
            m.addInstr(new BEQInstr(eqqResult, BooleanLiteral.FALSE, uncaughtLabel));
        }
        if ((x = this.build(realBody = this.skipOverNewlines(m, rescueBodyNode.getBodyNode()), m)) != null) {
            m.addInstr(new CopyInstr(rv, x));
            if (haveEnsureBlocks) {
                EnsureBlockInfo ebi = this._ensureBlockStack.peek();
                ebi.endLabelNeeded = true;
                ebi.noFallThru = true;
                m.addInstr(new SET_RETADDR_Instr(ebi.returnAddr, ebi.end));
                m.addInstr(new JumpInstr(ebi.start));
            } else {
                m.addInstr(new JumpInstr(endLabel));
            }
        }
        if (uncaughtLabel != null) {
            rescueBlockLabels.add(uncaughtLabel);
            m.addInstr(new LABEL_Instr(uncaughtLabel));
            if (rescueBodyNode.getOptRescueNode() != null) {
                this.buildRescueBodyInternal(m, rescueBodyNode.getOptRescueNode(), rv, endLabel, rescueBlockLabels);
            } else {
                if (haveEnsureBlocks) {
                    EnsureBlockInfo.emitJumpChain(m, this._ensureBlockStack);
                }
                m.addInstr(new THROW_EXCEPTION_Instr(exc));
            }
        }
    }

    public Operand buildRetry(Node node, IRScope s) {
        s.addInstr(new ThreadPollInstr());
        if (this._rescueBlockLabelStack.empty()) {
            StringLiteral exc = new StringLiteral("retry found outside of rescue clause!");
            s.addInstr(new THROW_EXCEPTION_Instr(exc));
        } else {
            s.addInstr(new JumpInstr(this._rescueBlockLabelStack.peek()));
        }
        return Nil.NIL;
    }

    public Operand buildReturn(ReturnNode returnNode, IRScope m) {
        Nil retVal;
        Operand operand = retVal = returnNode.getValueNode() == null ? Nil.NIL : this.build(returnNode.getValueNode(), m);
        if (!this._ensureBlockStack.empty()) {
            EnsureBlockInfo.emitJumpChain(m, this._ensureBlockStack);
        }
        m.addInstr(new ReturnInstr(retVal));
        return null;
    }

    public IRScope buildRoot(RootNode rootNode) {
        String file2 = rootNode.getPosition().getFile();
        StaticScope staticScope = rootNode.getStaticScope();
        IRScript script = new IRScript("__file__", file2, rootNode.getStaticScope());
        IRClass rootClass = script.getRootClass();
        IRMethod rootMethod = rootClass.getRootMethod();
        rootMethod.addInstr(new FilenameInstr(file2));
        rootMethod.addInstr(new ReceiveSelfInstruction(this.getSelf(rootMethod)));
        this.build(rootNode.getBodyNode(), rootMethod);
        return script;
    }

    private Variable getSelf(IRScope s) {
        return ((IRExecutionScope)s).getSelf();
    }

    public Operand buildSelf(Node node, IRScope s) {
        return this.getSelf(s);
    }

    public Operand buildSplat(SplatNode splatNode, IRScope s) {
        return new Splat(this.build(splatNode.getValue(), s));
    }

    public Operand buildStr(StrNode strNode, IRScope s) {
        return new StringLiteral(strNode.getValue());
    }

    public Operand buildSuper(SuperNode superNode, IRScope s) {
        List<Operand> args2 = this.setupCallArgs(superNode.getArgsNode(), s);
        Operand block = this.setupCallClosure(superNode.getIterNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new RubyInternalCallInstr(ret, MethAddr.SUPER, this.getSelf(s), args2.toArray(new Operand[args2.size()]), block));
        return ret;
    }

    public Operand buildSValue(SValueNode node, IRScope s) {
        return new SValue(this.build(node.getValue(), s));
    }

    public Operand buildSymbol(SymbolNode node, IRScope s) {
        return new Symbol(node.getName());
    }

    public Operand buildToAry(ToAryNode node, IRScope s) {
        Operand array = this.build(node.getValue(), s);
        return this.generateJRubyUtilityCall(s, MethAddr.TO_ARY, array, new Operand[0]);
    }

    public Operand buildTrue(Node node, IRScope m) {
        m.addInstr(new ThreadPollInstr());
        return BooleanLiteral.TRUE;
    }

    public Operand buildUndef(Node node, IRScope m) {
        Operand methName = this.build(((UndefNode)node).getName(), m);
        return this.generateJRubyUtilityCall(m, MethAddr.UNDEF_METHOD, methName, new Operand[0]);
    }

    private Operand buildConditionalLoop(IRExecutionScope s, Node conditionNode, Node bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand v;
        if (isLoopHeadCondition && (isWhile && conditionNode.getNodeType().alwaysFalse() || !isWhile && conditionNode.getNodeType().alwaysTrue())) {
            this.build(conditionNode, s);
            return Nil.NIL;
        }
        IRLoop loop2 = new IRLoop(s);
        s.startLoop(loop2);
        s.addInstr(new LABEL_Instr(loop2.loopStartLabel));
        if (isLoopHeadCondition) {
            Operand cv = this.build(conditionNode, s);
            s.addInstr(new BEQInstr(cv, isWhile ? BooleanLiteral.FALSE : BooleanLiteral.TRUE, loop2.loopEndLabel));
        }
        s.addInstr(new LABEL_Instr(loop2.iterStartLabel));
        Variable whileResult = null;
        if (bodyNode != null && (v = this.build(bodyNode, s)) != null) {
            whileResult = s.getNewTemporaryVariable();
            s.addInstr(new CopyInstr(whileResult, v));
        }
        s.addInstr(new ThreadPollInstr());
        s.addInstr(new LABEL_Instr(loop2.iterEndLabel));
        if (isLoopHeadCondition) {
            s.addInstr(new JumpInstr(loop2.loopStartLabel));
        } else {
            Operand cv = this.build(conditionNode, s);
            s.addInstr(new BEQInstr(cv, isWhile ? BooleanLiteral.TRUE : BooleanLiteral.FALSE, loop2.iterStartLabel));
        }
        s.addInstr(new LABEL_Instr(loop2.loopEndLabel));
        s.endLoop(loop2);
        return whileResult;
    }

    public Operand buildUntil(UntilNode untilNode, IRExecutionScope s) {
        return this.buildConditionalLoop(s, untilNode.getConditionNode(), untilNode.getBodyNode(), false, untilNode.evaluateAtStart());
    }

    public Operand buildVAlias(Node node, IRScope m) {
        VAliasNode valiasNode = (VAliasNode)node;
        Operand[] args2 = new Operand[]{new StringLiteral(valiasNode.getOldName())};
        m.addInstr(new RubyInternalCallInstr(null, MethAddr.GVAR_ALIAS, new StringLiteral(valiasNode.getNewName()), args2));
        return Nil.NIL;
    }

    public Operand buildVCall(VCallNode node, IRScope s) {
        ArrayList<Variable> args2 = new ArrayList<Variable>();
        args2.add(this.getSelf(s));
        Variable callResult = s.getNewTemporaryVariable();
        CallInstr callInstr = new CallInstr(callResult, new MethAddr(node.getName()), this.getSelf(s), new Operand[0], null);
        s.addInstr(callInstr);
        return callResult;
    }

    public Operand buildWhile(WhileNode whileNode, IRExecutionScope s) {
        return this.buildConditionalLoop(s, whileNode.getConditionNode(), whileNode.getBodyNode(), true, whileNode.evaluateAtStart());
    }

    public Operand buildXStr(XStrNode node, IRScope m) {
        return new BacktickString(new StringLiteral(node.getValue()));
    }

    private List<Operand> setupYieldArgs(Node args2, IRScope s) {
        ArrayList<Operand> argsList = new ArrayList<Operand>();
        if (args2 != null) {
            args2 = this.skipOverNewlines(s, args2);
            this.buildArgs(argsList, args2, s);
        }
        return argsList;
    }

    public Operand buildYield(YieldNode node, IRScope s) {
        List<Operand> args2 = this.setupYieldArgs(node.getArgsNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new YieldInstr(ret, args2.toArray(new Operand[args2.size()])));
        return ret;
    }

    public Operand buildZArray(Node node, IRScope m) {
        return new Array();
    }

    public Operand buildZSuper(ZSuperNode zsuperNode, IRScope s) {
        Operand block = this.setupCallClosure(zsuperNode.getIterNode(), s);
        Variable ret = s.getNewTemporaryVariable();
        s.addInstr(new RubyInternalCallInstr(ret, MethAddr.ZSUPER, this.getSelf(s), ((IRMethod)s).getCallArgs(), block));
        return ret;
    }

    public void buildArgsCatArguments(List<Operand> args2, ArgsCatNode argsCatNode, IRScope s) {
        Operand v1 = this.build(argsCatNode.getFirstNode(), s);
        Operand v2 = this.build(argsCatNode.getSecondNode(), s);
        args2.add(new CompoundArray(v1, v2));
    }

    public void buildArgsPushArguments(List<Operand> args2, ArgsPushNode argsPushNode, IRScope m) {
        Array a = new Array(new Operand[]{this.build(argsPushNode.getFirstNode(), m), this.build(argsPushNode.getSecondNode(), m)});
        args2.add(a);
    }

    public void buildArrayArguments(List<Operand> args2, Node node, IRScope s) {
        args2.add(this.buildArray(node, s));
    }

    public void buildSplatArguments(List<Operand> args2, SplatNode node, IRScope s) {
        args2.add(this.buildSplat(node, s));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EnsureBlockInfo {
        Label start;
        Label end;
        Variable returnAddr;
        boolean noFallThru;
        boolean endLabelNeeded;

        public EnsureBlockInfo(IRScope m) {
            this.returnAddr = m.getNewTemporaryVariable();
            this.start = m.getNewLabel();
            this.end = m.getNewLabel();
            this.noFallThru = false;
            this.endLabelNeeded = false;
        }

        public static void emitJumpChain(IRScope m, Stack<EnsureBlockInfo> ebStack) {
            int n = ebStack.size();
            EnsureBlockInfo[] ebArray = ebStack.toArray(new EnsureBlockInfo[n]);
            for (int i = n - 1; i >= 0; --i) {
                Label retLabel = m.getNewLabel();
                m.addInstr(new SET_RETADDR_Instr(ebArray[i].returnAddr, retLabel));
                m.addInstr(new JumpInstr(ebArray[i].start));
                m.addInstr(new LABEL_Instr(retLabel));
                ebArray[i].noFallThru = true;
            }
        }
    }
}

