/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.KCode;
import org.jruby.util.Pack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JRubyModule(name={"NKF"})
public class RubyNKF {
    public static final NKFCharset AUTO = new NKFCharset(0, "x-JISAutoDetect");
    public static final NKFCharset JIS = new NKFCharset(1, "iso-2022-jp");
    public static final NKFCharset EUC = new NKFCharset(2, "EUC-JP");
    public static final NKFCharset SJIS = new NKFCharset(3, "Windows-31J");
    public static final NKFCharset BINARY = new NKFCharset(4, null);
    public static final NKFCharset NOCONV = new NKFCharset(4, null);
    public static final NKFCharset UNKNOWN = new NKFCharset(0, null);
    public static final NKFCharset ASCII = new NKFCharset(5, "iso-8859-1");
    public static final NKFCharset UTF8 = new NKFCharset(6, "UTF-8");
    public static final NKFCharset UTF16 = new NKFCharset(8, "UTF-16");
    public static final NKFCharset UTF32 = new NKFCharset(12, "UTF-32");
    public static final NKFCharset OTHER = new NKFCharset(16, null);
    public static final NKFCharset BASE64 = new NKFCharset(20, "base64");
    public static final NKFCharset QENCODE = new NKFCharset(21, "qencode");
    public static final NKFCharset MIME_DETECT = new NKFCharset(22, "MimeAutoDetect");
    private static final ByteList BEGIN_MIME_STRING = new ByteList(ByteList.plain("=?"));
    private static final ByteList END_MIME_STRING = new ByteList(ByteList.plain("?="));
    private static final ByteList PACK_BASE64 = new ByteList(ByteList.plain("m"));
    private static final ByteList PACK_QENCODE = new ByteList(ByteList.plain("M"));

    public static void createNKF(Ruby runtime2) {
        RubyModule nkfModule = runtime2.defineModule("NKF");
        nkfModule.defineConstant("AUTO", RubyFixnum.newFixnum(runtime2, AUTO.getValue()));
        nkfModule.defineConstant("JIS", RubyFixnum.newFixnum(runtime2, JIS.getValue()));
        nkfModule.defineConstant("EUC", RubyFixnum.newFixnum(runtime2, EUC.getValue()));
        nkfModule.defineConstant("SJIS", RubyFixnum.newFixnum(runtime2, SJIS.getValue()));
        nkfModule.defineConstant("BINARY", RubyFixnum.newFixnum(runtime2, BINARY.getValue()));
        nkfModule.defineConstant("NOCONV", RubyFixnum.newFixnum(runtime2, NOCONV.getValue()));
        nkfModule.defineConstant("UNKNOWN", RubyFixnum.newFixnum(runtime2, UNKNOWN.getValue()));
        nkfModule.defineConstant("ASCII", RubyFixnum.newFixnum(runtime2, ASCII.getValue()));
        nkfModule.defineConstant("UTF8", RubyFixnum.newFixnum(runtime2, UTF8.getValue()));
        nkfModule.defineConstant("UTF16", RubyFixnum.newFixnum(runtime2, UTF16.getValue()));
        nkfModule.defineConstant("UTF32", RubyFixnum.newFixnum(runtime2, UTF32.getValue()));
        nkfModule.defineConstant("OTHER", RubyFixnum.newFixnum(runtime2, OTHER.getValue()));
        RubyString version = runtime2.newString("2.0.7 (JRuby 2007-05-11)");
        RubyString nkfVersion = runtime2.newString("2.0.7");
        RubyString nkfDate = runtime2.newString("2007-05-11");
        ThreadContext context = runtime2.getCurrentContext();
        version.freeze(context);
        nkfVersion.freeze(context);
        nkfDate.freeze(context);
        nkfModule.defineAnnotatedMethods(RubyNKF.class);
    }

    @JRubyMethod(name={"guess"}, required=1, module=true)
    public static IRubyObject guess(ThreadContext context, IRubyObject recv2, IRubyObject s) {
        CharsetDecoder decoder;
        Ruby runtime2 = context.getRuntime();
        if (!s.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + s.getMetaClass() + " into String");
        }
        ByteList bytes2 = s.convertToString().getByteList();
        ByteBuffer buf = ByteBuffer.wrap(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        try {
            decoder = Charset.forName("x-JISAutoDetect").newDecoder();
        }
        catch (UnsupportedCharsetException e) {
            throw runtime2.newStandardError("charsets.jar is required to use NKF#guess. Please install JRE which supports m17n.");
        }
        try {
            decoder.decode(buf);
        }
        catch (CharacterCodingException e) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        if (!decoder.isCharsetDetected()) {
            return runtime2.newFixnum(UNKNOWN.getValue());
        }
        Charset charset = decoder.detectedCharset();
        String name2 = charset.name();
        if ("Shift_JIS".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("windows-31j".equals(name2)) {
            return runtime2.newFixnum(SJIS.getValue());
        }
        if ("EUC-JP".equals(name2)) {
            return runtime2.newFixnum(EUC.getValue());
        }
        if ("ISO-2022-JP".equals(name2)) {
            return runtime2.newFixnum(JIS.getValue());
        }
        return runtime2.newFixnum(UNKNOWN.getValue());
    }

    @JRubyMethod(name={"guess1"}, required=1, module=true)
    public static IRubyObject guess1(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"guess2"}, required=1, module=true)
    public static IRubyObject guess2(ThreadContext context, IRubyObject recv2, IRubyObject str) {
        return RubyNKF.guess(context, recv2, str);
    }

    @JRubyMethod(name={"nkf"}, required=2, module=true)
    public static IRubyObject nkf(ThreadContext context, IRubyObject recv2, IRubyObject opt, IRubyObject str) {
        Ruby runtime2 = context.getRuntime();
        if (!opt.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + opt.getMetaClass() + " into String");
        }
        if (!str.respondsTo("to_str")) {
            throw runtime2.newTypeError("can't convert " + str.getMetaClass() + " into String");
        }
        Map<String, NKFCharset> options2 = RubyNKF.parseOpt(opt.convertToString().toString());
        if (options2.get("input").getValue() == AUTO.getValue()) {
            KCode kcode2 = runtime2.getKCode();
            if (kcode2 == KCode.SJIS) {
                options2.put("input", SJIS);
            } else if (kcode2 == KCode.EUC) {
                options2.put("input", EUC);
            } else if (kcode2 == KCode.UTF8) {
                options2.put("input", UTF8);
            }
        }
        ByteList bstr = str.convertToString().getByteList();
        Converter converter = null;
        converter = Converter.isMimeText(bstr, options2) ? new MimeConverter(context, options2) : new DefaultConverter(context, options2);
        RubyString result = converter.convert(bstr);
        if (options2.get("mime-encode") == BASE64) {
            result = Converter.encodeMimeString(runtime2, result, RubyNKF.PACK_BASE64);
        } else if (options2.get("mime-encode") == QENCODE) {
            result = Converter.encodeMimeString(runtime2, result, RubyNKF.PACK_QENCODE);
        }
        return result;
    }

    private static int optionUTF(String s, int pos2) {
        int n = 8;
        int first2 = pos2 + 1;
        int second = pos2 + 2;
        if (first2 < s.length() && Character.isDigit(s.charAt(first2))) {
            n = Character.digit(s.charAt(first2), 10);
            if (second < s.length() && Character.isDigit(s.charAt(second))) {
                n *= 10;
                n += Character.digit(s.charAt(second), 10);
            }
        }
        return n;
    }

    private static Map<String, NKFCharset> parseOpt(String s) {
        HashMap<String, NKFCharset> options2 = new HashMap<String, NKFCharset>();
        options2.put("input", AUTO);
        options2.put("output", JIS);
        options2.put("mime-decode", MIME_DETECT);
        options2.put("mime-encode", NOCONV);
        block40: for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case 'b': {
                    continue block40;
                }
                case 'u': {
                    continue block40;
                }
                case 'j': {
                    options2.put("output", JIS);
                    continue block40;
                }
                case 's': {
                    options2.put("output", SJIS);
                    continue block40;
                }
                case 'e': {
                    options2.put("output", EUC);
                    continue block40;
                }
                case 'w': {
                    int n = RubyNKF.optionUTF(s, i);
                    if (n == 32) {
                        options2.put("output", UTF32);
                        continue block40;
                    }
                    if (n == 16) {
                        options2.put("output", UTF16);
                        continue block40;
                    }
                    options2.put("output", UTF8);
                    continue block40;
                }
                case 'J': {
                    options2.put("input", JIS);
                    continue block40;
                }
                case 'S': {
                    options2.put("input", SJIS);
                    continue block40;
                }
                case 'E': {
                    options2.put("input", EUC);
                    continue block40;
                }
                case 'W': {
                    int n = RubyNKF.optionUTF(s, i);
                    if (n == 32) {
                        options2.put("input", UTF32);
                        continue block40;
                    }
                    if (n == 16) {
                        options2.put("input", UTF16);
                        continue block40;
                    }
                    options2.put("input", UTF8);
                    continue block40;
                }
                case 't': {
                    continue block40;
                }
                case 'r': {
                    continue block40;
                }
                case 'h': {
                    continue block40;
                }
                case 'm': {
                    if (i + 1 >= s.length()) {
                        options2.put("mime-decode", MIME_DETECT);
                        continue block40;
                    }
                    switch (s.charAt(i + 1)) {
                        case 'B': {
                            options2.put("mime-decode", BASE64);
                            break;
                        }
                        case 'Q': {
                            options2.put("mime-decode", QENCODE);
                            break;
                        }
                        case 'N': {
                            break;
                        }
                        case '0': {
                            options2.put("mime-decode", NOCONV);
                        }
                    }
                    continue block40;
                }
                case 'M': {
                    if (i + 1 >= s.length()) {
                        options2.put("mime-encode", NOCONV);
                    }
                    switch (s.charAt(i + 1)) {
                        case 'B': {
                            options2.put("mime-encode", BASE64);
                            break;
                        }
                        case 'Q': {
                            options2.put("mime-encode", QENCODE);
                        }
                    }
                    continue block40;
                }
                case 'l': {
                    continue block40;
                }
                case 'f': {
                    continue block40;
                }
                case 'F': {
                    continue block40;
                }
                case 'Z': {
                    continue block40;
                }
                case 'X': {
                    continue block40;
                }
                case 'x': {
                    continue block40;
                }
                case 'B': {
                    continue block40;
                }
                case 'T': {
                    continue block40;
                }
                case 'd': {
                    continue block40;
                }
                case 'c': {
                    continue block40;
                }
                case 'I': {
                    continue block40;
                }
                case 'L': {
                    continue block40;
                }
                case '-': {
                    if (s.charAt(i + 1) != '-') continue block40;
                }
            }
        }
        return options2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MimeConverter
    extends Converter {
        public MimeConverter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            super(ctx, opt);
        }

        private String detectCharset(String charset) {
            if (charset.compareToIgnoreCase(UTF8.getCharset()) == 0) {
                return UTF8.getCharset();
            }
            if (charset.compareToIgnoreCase(JIS.getCharset()) == 0) {
                return JIS.getCharset();
            }
            if (charset.compareToIgnoreCase(EUC.getCharset()) == 0) {
                return EUC.getCharset();
            }
            return ASCII.getCharset();
        }

        private ByteList decodeMimeString(String str) {
            String[] mime = str.split("^=\\?|\\?|\\?=$");
            String charset = this.detectCharset(mime[1]);
            char encode2 = mime[2].charAt(0);
            ByteList body = new ByteList(mime[3].getBytes(), ASCIIEncoding.INSTANCE);
            RubyArray array = null;
            array = 'B' == encode2 || 'b' == encode2 ? Pack.unpack(this.context.getRuntime(), body, PACK_BASE64) : Pack.unpack(this.context.getRuntime(), body, PACK_QENCODE);
            RubyString s = (RubyString)array.entry(0);
            ByteList decodeStr = s.asString().getByteList();
            return this.convert_byte(decodeStr, charset, ((NKFCharset)this.options.get("output")).getCharset());
        }

        RubyString makeRubyString(ArrayList<ByteList> list2) {
            ByteList r = new ByteList();
            for (ByteList l : list2) {
                r.append(l);
            }
            return this.context.getRuntime().newString(r);
        }

        @Override
        RubyString convert(ByteList str) {
            String s = str.toString();
            String[] token = s.split("\\s");
            ArrayList<ByteList> raw_data = new ArrayList<ByteList>();
            for (int i = 0; i < token.length; ++i) {
                raw_data.add(this.decodeMimeString(token[i]));
            }
            return this.makeRubyString(raw_data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DefaultConverter
    extends Converter {
        public DefaultConverter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            super(ctx, opt);
        }

        @Override
        RubyString convert(ByteList str) {
            ByteList b = this.convert_byte(str, ((NKFCharset)this.options.get("input")).getCharset(), ((NKFCharset)this.options.get("output")).getCharset());
            return this.context.getRuntime().newString(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class Converter {
        protected ThreadContext context;
        protected Map<String, NKFCharset> options;

        public Converter(ThreadContext ctx, Map<String, NKFCharset> opt) {
            this.context = ctx;
            this.options = opt;
        }

        static boolean isMimeText(ByteList str, Map<String, NKFCharset> options2) {
            if (str.length() <= 6) {
                return false;
            }
            if (options2.get("mime-decode") == NOCONV) {
                return false;
            }
            if (str.indexOf(BEGIN_MIME_STRING) < 0) {
                return false;
            }
            return str.lastIndexOf(END_MIME_STRING) >= 0;
        }

        private static RubyString encodeMimeString(Ruby runtime2, RubyString str, ByteList format) {
            RubyArray array = RubyArray.newArray(runtime2, str);
            return Pack.pack(runtime2, array, format).chomp(runtime2.getCurrentContext());
        }

        abstract RubyString convert(ByteList var1);

        ByteList convert_byte(ByteList str, String encodeCharset, String decodeCharset) {
            CharsetEncoder encoder;
            CharsetDecoder decoder;
            try {
                decoder = Charset.forName(encodeCharset).newDecoder();
                encoder = Charset.forName(decodeCharset).newEncoder();
            }
            catch (UnsupportedCharsetException e) {
                throw this.context.getRuntime().newArgumentError("invalid charset");
            }
            ByteBuffer buf = ByteBuffer.wrap(str.getUnsafeBytes(), str.begin(), str.length());
            try {
                CharBuffer cbuf = decoder.decode(buf);
                encoder.onUnmappableCharacter(CodingErrorAction.IGNORE);
                buf = encoder.encode(cbuf);
            }
            catch (CharacterCodingException e) {
                throw this.context.getRuntime().newArgumentError("invalid encoding");
            }
            byte[] arr = buf.array();
            ByteList r = new ByteList(arr, 0, buf.limit());
            Encoding charset = EncodingDB.getEncodings().get(decodeCharset.getBytes()).getEncoding();
            r.setEncoding(charset);
            return r;
        }
    }

    public static class NKFCharset {
        private final int value;
        private final String charset;

        public NKFCharset(int v, String c) {
            this.value = v;
            this.charset = c;
        }

        public int getValue() {
            return this.value;
        }

        public String getCharset() {
            return this.charset;
        }
    }
}

