/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import com.martiansoftware.nailgun.NGContext;
import org.jruby.Main;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.executable.Script;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.util.ClassCache;
import org.jruby.util.SafePropertyAccessor;

public class NailMain {
    public static final ClassCache<Script> classCache = new ClassCache(NailMain.class.getClassLoader(), 4096);

    public static void nailMain(NGContext context) {
        NailMain main2 = new NailMain();
        int status2 = main2.run(context);
        if (status2 != 0) {
            context.exit(status2);
        }
        System.gc();
    }

    public int run(NGContext context) {
        context.assertLoopbackClient();
        RubyInstanceConfig config = new RubyInstanceConfig();
        Main main2 = new Main(config);
        try {
            config.processArguments(context.getArgs());
            config.setCurrentDirectory(context.getWorkingDirectory());
            config.setEnvironment(context.getEnv());
            config.setClassCache(classCache);
            return main2.run().getStatus();
        }
        catch (MainExitException mee) {
            if (!mee.isAborted()) {
                config.getOutput().println(mee.getMessage());
                if (mee.isUsageError()) {
                    main2.printUsage();
                }
            }
            return mee.getStatus();
        }
        catch (OutOfMemoryError oome) {
            System.gc();
            String memoryMax = SafePropertyAccessor.getProperty("jruby.memory.max");
            String message2 = "";
            if (memoryMax != null) {
                message2 = " of " + memoryMax;
            }
            config.getError().println("Error: Your application used more memory than the safety cap" + message2 + ".");
            config.getError().println("Specify -J-Xmx####m to increase it (#### = cap size in MB).");
            if (config.getVerbose().booleanValue()) {
                config.getError().println("Exception trace follows:");
                oome.printStackTrace();
            } else {
                config.getError().println("Specify -w for full OutOfMemoryError stack trace");
            }
            return 1;
        }
        catch (StackOverflowError soe) {
            System.gc();
            String stackMax = SafePropertyAccessor.getProperty("jruby.stack.max");
            String message3 = "";
            if (stackMax != null) {
                message3 = " of " + stackMax;
            }
            config.getError().println("Error: Your application used more stack memory than the safety cap" + message3 + ".");
            config.getError().println("Specify -J-Xss####k to increase it (#### = cap size in KB).");
            if (config.getVerbose().booleanValue()) {
                config.getError().println("Exception trace follows:");
                soe.printStackTrace();
            } else {
                config.getError().println("Specify -w for full StackOverflowError stack trace");
            }
            return 1;
        }
        catch (UnsupportedClassVersionError ucve) {
            config.getError().println("Error: Some library (perhaps JRuby) was built with a later JVM version.");
            config.getError().println("Please use libraries built with the version you intend to use or an earlier one.");
            if (config.getVerbose().booleanValue()) {
                config.getError().println("Exception trace follows:");
                ucve.printStackTrace();
            } else {
                config.getError().println("Specify -w for full UnsupportedClassVersionError stack trace");
            }
            return 1;
        }
        catch (ThreadKill kill2) {
            return 0;
        }
    }
}

