/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.jruby.runtime.profile.AbstractProfilePrinter;
import org.jruby.runtime.profile.IProfileData;
import org.jruby.runtime.profile.MethodData;
import org.jruby.runtime.profile.ProfileData;

public class FlatProfilePrinter
extends AbstractProfilePrinter {
    private static final int SERIAL_OFFSET = 0;
    private static final int SELFTIME_OFFSET = 1;
    private static final int COUNT_OFFSET = 2;
    private static final int AGGREGATETIME_OFFSET = 3;
    private ProfileData profileData;

    public FlatProfilePrinter(IProfileData iProfileData) {
        this.profileData = (ProfileData)iProfileData;
    }

    public void printProfile(PrintStream out) {
        this.profileData.getTopInvocation().setDuration(this.profileData.totalTime());
        out.printf("Total time: %s\n\n", this.nanoString(this.profileData.totalTime()));
        Map<Integer, MethodData> serialsToMethods = this.profileData.methodData();
        long[][] tuples = new long[serialsToMethods.size()][];
        int j = 0;
        for (Map.Entry<Integer, MethodData> entry : serialsToMethods.entrySet()) {
            MethodData method2 = entry.getValue();
            tuples[j] = new long[]{entry.getKey().intValue(), method2.selfTime(), method2.totalCalls(), method2.totalTime()};
            ++j;
        }
        Arrays.sort(tuples, new Comparator<long[]>(){

            @Override
            public int compare(long[] o1, long[] o2) {
                long o2Val = o2[3];
                long o1Val = o1[3];
                return o2Val > o1Val ? 1 : (o2Val < o1Val ? -1 : 0);
            }
        });
        out.println("     total        self    children       calls  method");
        out.println("----------------------------------------------------------------");
        int lines2 = 0;
        for (long[] tuple : tuples) {
            if (tuple[3] == 0L) break;
            int index2 = (int)tuple[0];
            if (index2 != 0) {
                ++lines2;
                String name2 = this.methodName(index2);
                this.pad(out, 10, this.nanoString(tuple[3]));
                out.print("  ");
                this.pad(out, 10, this.nanoString(tuple[1]));
                out.print("  ");
                this.pad(out, 10, this.nanoString(tuple[3] - tuple[1]));
                out.print("  ");
                this.pad(out, 10, Long.toString(tuple[2]));
                out.print("  ");
                out.println(name2);
            }
            if (lines2 == 50) break;
        }
    }
}

