/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.runtime.builtin.IRubyObject;

public class AbstractProfilePrinter {
    public void printProfile(PrintStream out) {
    }

    public void printProfile(RubyIO out) {
        this.printProfile(new PrintStream(out.getOutStream()));
    }

    protected void pad(PrintStream out, int size2, String body) {
        this.pad(out, size2, body, true);
    }

    protected void pad(PrintStream out, int size2, String body, boolean front) {
        int i;
        if (front) {
            for (i = 0; i < size2 - body.length(); ++i) {
                out.print(' ');
            }
        }
        out.print(body);
        if (!front) {
            for (i = 0; i < size2 - body.length(); ++i) {
                out.print(' ');
            }
        }
    }

    protected String nanoString(long nanoTime) {
        DecimalFormat formatter = new DecimalFormat("##0.00");
        return formatter.format((double)nanoTime / 1.0E9);
    }

    protected String methodName(int serial) {
        if (serial == 0) {
            return "(top)";
        }
        Ruby runtime2 = Ruby.getGlobalRuntime();
        String[] profiledNames = runtime2.profiledNames;
        DynamicMethod[] profiledMethods = runtime2.profiledMethods;
        String name2 = profiledNames[serial];
        DynamicMethod method2 = profiledMethods[serial];
        return this.moduleHashMethod(method2.getImplementationClass(), name2);
    }

    protected String moduleHashMethod(RubyModule module, String name2) {
        if (module instanceof MetaClass) {
            IRubyObject obj = ((MetaClass)module).getAttached();
            if (obj instanceof RubyModule) {
                module = (RubyModule)obj;
                return module.getName() + "." + name2;
            }
            if (obj instanceof RubyObject) {
                return ((RubyObject)obj).getType().getName() + "(singleton)#" + name2;
            }
            return "unknown#" + name2;
        }
        if (module.isSingleton()) {
            return ((RubyClass)module).getRealClass().getName() + "(singleton)#" + name2;
        }
        return module.getName() + "#" + name2;
    }
}

