/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyInstanceConfig;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.callsite.ArefCallSite;
import org.jruby.runtime.callsite.AsetCallSite;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.callsite.GeCallSite;
import org.jruby.runtime.callsite.GtCallSite;
import org.jruby.runtime.callsite.LeCallSite;
import org.jruby.runtime.callsite.LtCallSite;
import org.jruby.runtime.callsite.MinusCallSite;
import org.jruby.runtime.callsite.ModCallSite;
import org.jruby.runtime.callsite.MulCallSite;
import org.jruby.runtime.callsite.NormalCachingCallSite;
import org.jruby.runtime.callsite.PlusCallSite;
import org.jruby.runtime.callsite.RespondToCallSite;
import org.jruby.runtime.callsite.SuperCallSite;
import org.jruby.runtime.callsite.VariableCachingCallSite;

public class MethodIndex {
    public static final int NO_METHOD = 0;
    public static final int OP_EQUAL = 1;
    public static final int EQL = 2;
    public static final int HASH = 3;
    public static final int MAX_METHODS = 4;

    public static CallSite getCallSite(String name2) {
        if (name2.equals("respond_to?")) {
            return new RespondToCallSite();
        }
        if (RubyInstanceConfig.FASTOPS_COMPILE_ENABLED) {
            return MethodIndex.getFastOpsCallSite(name2);
        }
        return new NormalCachingCallSite(name2);
    }

    public static CallSite getFastOpsCallSite(String name2) {
        if (name2.equals("+")) {
            return new PlusCallSite();
        }
        if (name2.equals("-")) {
            return new MinusCallSite();
        }
        if (name2.equals("*")) {
            return new MulCallSite();
        }
        if (name2.equals("<")) {
            return new LtCallSite();
        }
        if (name2.equals("<=")) {
            return new LeCallSite();
        }
        if (name2.equals(">")) {
            return new GtCallSite();
        }
        if (name2.equals(">=")) {
            return new GeCallSite();
        }
        if (name2.equals("[]")) {
            return new ArefCallSite();
        }
        if (name2.equals("[]=")) {
            return new AsetCallSite();
        }
        if (name2.equals("%")) {
            return new ModCallSite();
        }
        return new NormalCachingCallSite(name2);
    }

    public static CallSite getFunctionalCallSite(String name2) {
        return new FunctionalCachingCallSite(name2);
    }

    public static CallSite getVariableCallSite(String name2) {
        return new VariableCachingCallSite(name2);
    }

    public static CallSite getSuperCallSite() {
        return new SuperCallSite();
    }
}

