/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import com.kenai.constantine.platform.IPProto;
import com.kenai.constantine.platform.Sock;
import com.kenai.constantine.platform.SocketLevel;
import com.kenai.constantine.platform.SocketOption;
import com.kenai.constantine.platform.TCP;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.Channel;
import java.nio.channels.DatagramChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.MulticastStateManager;
import org.jruby.ext.socket.RubySocket;
import org.jruby.ext.socket.Shutdownable;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ChannelStream;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.OpenFile;

@JRubyClass(name={"BasicSocket"}, parent="IO")
public class RubyBasicSocket
extends RubyIO {
    private static final ByteList FORMAT_SMALL_I = new ByteList(ByteList.plain("i"));
    protected MulticastStateManager multicastStateManager = null;
    private static ObjectAllocator BASICSOCKET_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyBasicSocket(runtime2, klass);
        }
    };
    private boolean doNotReverseLookup = false;

    static void createBasicSocket(Ruby runtime2) {
        RubyClass rb_cBasicSocket = runtime2.defineClass("BasicSocket", runtime2.getIO(), BASICSOCKET_ALLOCATOR);
        rb_cBasicSocket.defineAnnotatedMethods(RubyBasicSocket.class);
    }

    public RubyBasicSocket(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
        this.doNotReverseLookup = runtime2.is1_9();
    }

    protected void initSocket(Ruby runtime2, ChannelDescriptor descriptor) {
        this.openFile = new OpenFile();
        try {
            this.openFile.setMainStream(ChannelStream.fdopen(runtime2, descriptor, new ModeFlags(ModeFlags.RDONLY)));
            this.openFile.setPipeStream(ChannelStream.fdopen(runtime2, descriptor, new ModeFlags(ModeFlags.WRONLY)));
            this.openFile.getPipeStream().setSync(true);
        }
        catch (InvalidValueException ex) {
            throw runtime2.newErrnoEINVALError();
        }
        this.openFile.setMode(11);
    }

    public IRubyObject close_write(ThreadContext context) {
        if (context.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw context.getRuntime().newSecurityError("Insecure: can't close");
        }
        if (!this.openFile.isWritable()) {
            return context.getRuntime().getNil();
        }
        if (this.openFile.getPipeStream() == null && this.openFile.isReadable()) {
            throw context.getRuntime().newIOError("closing non-duplex IO for writing");
        }
        if (!this.openFile.isReadable()) {
            this.close();
        } else {
            this.shutdownInternal(context, 1);
        }
        return context.getRuntime().getNil();
    }

    public IRubyObject close_read(ThreadContext context) {
        Ruby runtime2 = context.getRuntime();
        if (runtime2.getSafeLevel() >= 4 && this.isTaint()) {
            throw runtime2.newSecurityError("Insecure: can't close");
        }
        if (!this.openFile.isOpen()) {
            throw context.getRuntime().newIOError("not opened for reading");
        }
        if (!this.openFile.isWritable()) {
            this.close();
        } else {
            this.shutdownInternal(context, 0);
        }
        return runtime2.getNil();
    }

    @JRubyMethod(name={"send"}, rest=true)
    public IRubyObject write_send(ThreadContext context, IRubyObject[] args2) {
        return this.syswrite(context, args2[0]);
    }

    @Deprecated
    public IRubyObject recv(IRubyObject[] args2) {
        return this.recv(this.getRuntime().getCurrentContext(), args2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(rest=true)
    public IRubyObject recv(ThreadContext context, IRubyObject[] args2) {
        OpenFile openFile = this.getOpenFileChecked();
        try {
            try {
                context.getThread().beforeBlockingCall();
                RubyString rubyString = RubyString.newString(context.getRuntime(), openFile.getMainStream().read(RubyNumeric.fix2int(args2[0])));
                Object var7_8 = null;
                context.getThread().afterBlockingCall();
                return rubyString;
            }
            catch (BadDescriptorException e) {
                throw context.getRuntime().newErrnoEBADFError();
            }
            catch (EOFException e) {
                IRubyObject iRubyObject = context.getRuntime().getNil();
                Object var7_9 = null;
                context.getThread().afterBlockingCall();
                return iRubyObject;
            }
            catch (IOException e) {
                if (!"Socket not open".equals(e.getMessage())) throw context.getRuntime().newSystemCallError(e.getMessage());
                throw context.getRuntime().newIOError(e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            context.getThread().afterBlockingCall();
            throw throwable;
        }
    }

    protected InetSocketAddress getLocalSocket(String caller2) {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)socketChannel).socket().getLocalSocketAddress();
        }
        if (socketChannel instanceof ServerSocketChannel) {
            return (InetSocketAddress)((ServerSocketChannel)socketChannel).socket().getLocalSocketAddress();
        }
        if (socketChannel instanceof DatagramChannel) {
            return (InetSocketAddress)((DatagramChannel)socketChannel).socket().getLocalSocketAddress();
        }
        return null;
    }

    protected InetSocketAddress getRemoteSocket() {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            return (InetSocketAddress)((SocketChannel)socketChannel).socket().getRemoteSocketAddress();
        }
        return null;
    }

    private Socket asSocket() {
        Channel socketChannel = this.getOpenChannel();
        if (!(socketChannel instanceof SocketChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((SocketChannel)socketChannel).socket();
    }

    private ServerSocket asServerSocket() {
        Channel socketChannel = this.getOpenChannel();
        if (!(socketChannel instanceof ServerSocketChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((ServerSocketChannel)socketChannel).socket();
    }

    private DatagramSocket asDatagramSocket() {
        Channel socketChannel = this.getOpenChannel();
        if (!(socketChannel instanceof DatagramChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        return ((DatagramChannel)socketChannel).socket();
    }

    private IRubyObject getBroadcast(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return this.trueFalse(runtime2, socketChannel instanceof DatagramChannel ? this.asDatagramSocket().getBroadcast() : false);
    }

    private void setBroadcast(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setBroadcast(this.asBoolean(val));
        }
    }

    private void setKeepAlive(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setKeepAlive(this.asBoolean(val));
        }
    }

    private void setTcpNoDelay(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setTcpNoDelay(this.asBoolean(val));
        }
    }

    private void joinMulticastGroup(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof DatagramChannel) {
            if (this.multicastStateManager == null) {
                this.multicastStateManager = new MulticastStateManager();
            }
            if (val instanceof RubyString) {
                byte[] ipaddr_buf = val.convertToString().getBytes();
                this.multicastStateManager.addMembership(ipaddr_buf);
            }
        }
    }

    private void setReuseAddr(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof ServerSocketChannel) {
            this.asServerSocket().setReuseAddress(this.asBoolean(val));
        } else if (socketChannel instanceof SocketChannel) {
            this.asSocket().setReuseAddress(this.asBoolean(val));
        } else if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setReuseAddress(this.asBoolean(val));
        }
    }

    private void setRcvBuf(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setReceiveBufferSize(this.asNumber(val));
        } else if (socketChannel instanceof ServerSocketChannel) {
            this.asServerSocket().setReceiveBufferSize(this.asNumber(val));
        } else if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setReceiveBufferSize(this.asNumber(val));
        }
    }

    private void setTimeout(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setSoTimeout(this.asNumber(val));
        } else if (socketChannel instanceof ServerSocketChannel) {
            this.asServerSocket().setSoTimeout(this.asNumber(val));
        } else if (socketChannel instanceof DatagramChannel) {
            this.asDatagramSocket().setSoTimeout(this.asNumber(val));
        }
    }

    private void setSndBuf(IRubyObject val) throws IOException {
        try {
            Channel socketChannel = this.getOpenChannel();
            if (socketChannel instanceof SocketChannel) {
                this.asSocket().setSendBufferSize(this.asNumber(val));
            } else if (socketChannel instanceof DatagramChannel) {
                this.asDatagramSocket().setSendBufferSize(this.asNumber(val));
            }
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newErrnoEINVALError(iae.getMessage());
        }
    }

    private void setLinger(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            if (val instanceof RubyBoolean && !val.isTrue()) {
                this.asSocket().setSoLinger(false, 0);
            } else {
                int num = this.asNumber(val);
                if (num == -1) {
                    this.asSocket().setSoLinger(false, 0);
                } else {
                    this.asSocket().setSoLinger(true, num);
                }
            }
        }
    }

    private void setOOBInline(IRubyObject val) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        if (socketChannel instanceof SocketChannel) {
            this.asSocket().setOOBInline(this.asBoolean(val));
        }
    }

    private int asNumber(IRubyObject val) {
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val);
        }
        if (val instanceof RubyBoolean) {
            return val.isTrue() ? 1 : 0;
        }
        return this.stringAsNumber(val);
    }

    private int stringAsNumber(IRubyObject val) {
        ByteList str = val.convertToString().getByteList();
        IRubyObject res = Pack.unpack(this.getRuntime(), str, FORMAT_SMALL_I).entry(0);
        if (res.isNil()) {
            throw this.getRuntime().newErrnoEINVALError();
        }
        return RubyNumeric.fix2int(res);
    }

    protected boolean asBoolean(IRubyObject val) {
        if (val instanceof RubyString) {
            return this.stringAsNumber(val) != 0;
        }
        if (val instanceof RubyNumeric) {
            return RubyNumeric.fix2int(val) != 0;
        }
        return val.isTrue();
    }

    private IRubyObject getKeepAlive(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return this.trueFalse(runtime2, socketChannel instanceof SocketChannel ? this.asSocket().getKeepAlive() : false);
    }

    private IRubyObject getLinger(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        int linger = 0;
        if (socketChannel instanceof SocketChannel && (linger = this.asSocket().getSoLinger()) < 0) {
            linger = 0;
        }
        return RubyBasicSocket.number(runtime2, linger);
    }

    private IRubyObject getOOBInline(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return this.trueFalse(runtime2, socketChannel instanceof SocketChannel ? this.asSocket().getOOBInline() : false);
    }

    private IRubyObject getRcvBuf(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return RubyBasicSocket.number(runtime2, socketChannel instanceof SocketChannel ? this.asSocket().getReceiveBufferSize() : (socketChannel instanceof ServerSocketChannel ? this.asServerSocket().getReceiveBufferSize() : this.asDatagramSocket().getReceiveBufferSize()));
    }

    private IRubyObject getSndBuf(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return RubyBasicSocket.number(runtime2, socketChannel instanceof SocketChannel ? this.asSocket().getSendBufferSize() : (socketChannel instanceof DatagramChannel ? this.asDatagramSocket().getSendBufferSize() : 0));
    }

    private IRubyObject getReuseAddr(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        boolean reuse = false;
        if (socketChannel instanceof ServerSocketChannel) {
            reuse = this.asServerSocket().getReuseAddress();
        } else if (socketChannel instanceof SocketChannel) {
            reuse = this.asSocket().getReuseAddress();
        } else if (socketChannel instanceof DatagramChannel) {
            reuse = this.asDatagramSocket().getReuseAddress();
        }
        return this.trueFalse(runtime2, reuse);
    }

    private IRubyObject getTimeout(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return RubyBasicSocket.number(runtime2, socketChannel instanceof SocketChannel ? this.asSocket().getSoTimeout() : (socketChannel instanceof ServerSocketChannel ? this.asServerSocket().getSoTimeout() : (socketChannel instanceof DatagramChannel ? this.asDatagramSocket().getSoTimeout() : 0)));
    }

    protected int getSoTypeDefault() {
        return 0;
    }

    private int getChannelSoType(Channel channel) {
        if (channel instanceof SocketChannel || channel instanceof ServerSocketChannel) {
            return Sock.SOCK_STREAM.value();
        }
        if (channel instanceof DatagramChannel) {
            return Sock.SOCK_DGRAM.value();
        }
        return this.getSoTypeDefault();
    }

    private IRubyObject getSoType(Ruby runtime2) throws IOException {
        Channel socketChannel = this.getOpenChannel();
        return RubyBasicSocket.number(runtime2, this.getChannelSoType(socketChannel));
    }

    private IRubyObject trueFalse(Ruby runtime2, boolean val) {
        return RubyBasicSocket.number(runtime2, val ? 1 : 0);
    }

    private static IRubyObject number(Ruby runtime2, int s) {
        RubyArray array = runtime2.newArray((IRubyObject)runtime2.newFixnum(s));
        return Pack.pack(runtime2, array, FORMAT_SMALL_I);
    }

    @Deprecated
    public IRubyObject getsockopt(IRubyObject lev, IRubyObject optname) {
        return this.getsockopt(this.getRuntime().getCurrentContext(), lev, optname);
    }

    @JRubyMethod
    public IRubyObject getsockopt(ThreadContext context, IRubyObject lev, IRubyObject optname) {
        int level2 = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        Ruby runtime2 = context.getRuntime();
        try {
            switch (SocketLevel.valueOf(level2)) {
                case SOL_IP: 
                case SOL_SOCKET: 
                case SOL_TCP: 
                case SOL_UDP: {
                    switch (SocketOption.valueOf(opt)) {
                        case SO_BROADCAST: {
                            return this.getBroadcast(runtime2);
                        }
                        case SO_KEEPALIVE: {
                            return this.getKeepAlive(runtime2);
                        }
                        case SO_LINGER: {
                            return this.getLinger(runtime2);
                        }
                        case SO_OOBINLINE: {
                            return this.getOOBInline(runtime2);
                        }
                        case SO_RCVBUF: {
                            return this.getRcvBuf(runtime2);
                        }
                        case SO_REUSEADDR: {
                            return this.getReuseAddr(runtime2);
                        }
                        case SO_SNDBUF: {
                            return this.getSndBuf(runtime2);
                        }
                        case SO_RCVTIMEO: 
                        case SO_SNDTIMEO: {
                            return this.getTimeout(runtime2);
                        }
                        case SO_TYPE: {
                            return this.getSoType(runtime2);
                        }
                        case SO_RCVLOWAT: {
                            return RubyBasicSocket.number(runtime2, 1);
                        }
                        case SO_SNDLOWAT: {
                            return RubyBasicSocket.number(runtime2, 2048);
                        }
                        case SO_DEBUG: 
                        case SO_ERROR: 
                        case SO_DONTROUTE: 
                        case SO_TIMESTAMP: {
                            return this.trueFalse(runtime2, false);
                        }
                    }
                    throw context.getRuntime().newErrnoENOPROTOOPTError();
                }
            }
            throw context.getRuntime().newErrnoENOPROTOOPTError();
        }
        catch (IOException e) {
            throw context.getRuntime().newErrnoENOPROTOOPTError();
        }
    }

    @Deprecated
    public IRubyObject setsockopt(IRubyObject lev, IRubyObject optname, IRubyObject val) {
        return this.setsockopt(this.getRuntime().getCurrentContext(), lev, optname, val);
    }

    @JRubyMethod
    public IRubyObject setsockopt(ThreadContext context, IRubyObject lev, IRubyObject optname, IRubyObject val) {
        int level2 = RubyNumeric.fix2int(lev);
        int opt = RubyNumeric.fix2int(optname);
        try {
            block1 : switch (SocketLevel.valueOf(level2)) {
                case SOL_IP: 
                case SOL_SOCKET: 
                case SOL_TCP: 
                case SOL_UDP: {
                    switch (SocketOption.valueOf(opt)) {
                        case SO_BROADCAST: {
                            this.setBroadcast(val);
                            break block1;
                        }
                        case SO_KEEPALIVE: {
                            this.setKeepAlive(val);
                            break block1;
                        }
                        case SO_LINGER: {
                            this.setLinger(val);
                            break block1;
                        }
                        case SO_OOBINLINE: {
                            this.setOOBInline(val);
                            break block1;
                        }
                        case SO_RCVBUF: {
                            this.setRcvBuf(val);
                            break block1;
                        }
                        case SO_REUSEADDR: {
                            this.setReuseAddr(val);
                            break block1;
                        }
                        case SO_SNDBUF: {
                            this.setSndBuf(val);
                            break block1;
                        }
                        case SO_RCVTIMEO: 
                        case SO_SNDTIMEO: {
                            this.setTimeout(val);
                            break block1;
                        }
                        case SO_TYPE: 
                        case SO_RCVLOWAT: 
                        case SO_SNDLOWAT: 
                        case SO_DEBUG: 
                        case SO_ERROR: 
                        case SO_DONTROUTE: 
                        case SO_TIMESTAMP: {
                            break block1;
                        }
                    }
                    if (IPProto.IPPROTO_TCP.value() == level2 && TCP.TCP_NODELAY.value() == opt) {
                        this.setTcpNoDelay(val);
                        break;
                    }
                    if (IPProto.IPPROTO_IP.value() == level2) {
                        if (12 == opt) {
                            this.joinMulticastGroup(val);
                        }
                        break;
                    }
                    throw context.getRuntime().newErrnoENOPROTOOPTError();
                }
                default: {
                    if (IPProto.IPPROTO_TCP.value() == level2 && TCP.TCP_NODELAY.value() == opt) {
                        this.setTcpNoDelay(val);
                        break;
                    }
                    if (IPProto.IPPROTO_IP.value() == level2) {
                        if (12 == opt) {
                            this.joinMulticastGroup(val);
                        }
                        break;
                    }
                    throw context.getRuntime().newErrnoENOPROTOOPTError();
                }
            }
        }
        catch (IOException e) {
            throw context.getRuntime().newErrnoENOPROTOOPTError();
        }
        return context.getRuntime().newFixnum(0);
    }

    @Deprecated
    public IRubyObject getsockname() {
        return this.getsockname(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"getsockname"})
    public IRubyObject getsockname(ThreadContext context) {
        return this.getSocknameCommon(context, "getsockname");
    }

    @JRubyMethod(name={"__getsockname"})
    public IRubyObject getsockname_u(ThreadContext context) {
        return this.getSocknameCommon(context, "__getsockname");
    }

    protected IRubyObject getSocknameCommon(ThreadContext context, String caller2) {
        InetSocketAddress sock = this.getLocalSocket(caller2);
        if (null == sock) {
            return RubySocket.pack_sockaddr_in(context, null, 0, "0.0.0.0");
        }
        return RubySocket.pack_sockaddr_in(context, null, sock.getPort(), sock.getAddress().getHostAddress());
    }

    @Deprecated
    public IRubyObject getpeername() {
        return this.getpeername(this.getRuntime().getCurrentContext());
    }

    @JRubyMethod(name={"getpeername", "__getpeername"})
    public IRubyObject getpeername(ThreadContext context) {
        InetSocketAddress sock = this.getRemoteSocket();
        if (null == sock) {
            throw context.getRuntime().newIOError("Not Supported");
        }
        return context.getRuntime().newString(((Object)sock).toString());
    }

    @JRubyMethod(optional=1)
    public IRubyObject shutdown(ThreadContext context, IRubyObject[] args2) {
        if (context.getRuntime().getSafeLevel() >= 4 && this.tainted_p(context).isFalse()) {
            throw context.getRuntime().newSecurityError("Insecure: can't shutdown socket");
        }
        int how = 2;
        if (args2.length > 0) {
            how = RubyNumeric.fix2int(args2[0]);
        }
        return this.shutdownInternal(context, how);
    }

    private IRubyObject shutdownInternal(ThreadContext context, int how) {
        switch (how) {
            case 0: {
                Channel socketChannel = this.getOpenChannel();
                try {
                    if (socketChannel instanceof SocketChannel || socketChannel instanceof DatagramChannel) {
                        this.asSocket().shutdownInput();
                    } else if (socketChannel instanceof Shutdownable) {
                        ((Shutdownable)((Object)socketChannel)).shutdownInput();
                    }
                }
                catch (IOException e) {
                    throw context.getRuntime().newIOError(e.getMessage());
                }
                if (this.openFile.getPipeStream() != null) {
                    this.openFile.setMainStream(this.openFile.getPipeStream());
                    this.openFile.setPipeStream(null);
                }
                this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFE);
                return RubyFixnum.zero(context.getRuntime());
            }
            case 1: {
                Channel socketChannel = this.getOpenChannel();
                try {
                    if (socketChannel instanceof SocketChannel || socketChannel instanceof DatagramChannel) {
                        this.asSocket().shutdownOutput();
                    } else if (socketChannel instanceof Shutdownable) {
                        ((Shutdownable)((Object)socketChannel)).shutdownOutput();
                    }
                }
                catch (IOException e) {
                    throw context.getRuntime().newIOError(e.getMessage());
                }
                this.openFile.setPipeStream(null);
                this.openFile.setMode(this.openFile.getMode() & 0xFFFFFFFD);
                return RubyFixnum.zero(context.getRuntime());
            }
            case 2: {
                this.shutdownInternal(context, 0);
                this.shutdownInternal(context, 1);
                return RubyFixnum.zero(context.getRuntime());
            }
        }
        throw context.getRuntime().newArgumentError("`how' should be either 0, 1, 2");
    }

    protected boolean doNotReverseLookup(ThreadContext context) {
        return context.getRuntime().isDoNotReverseLookupEnabled() || this.doNotReverseLookup;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public IRubyObject do_not_reverse_lookup19(ThreadContext context) {
        return context.getRuntime().newBoolean(this.doNotReverseLookup);
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, compat=CompatVersion.RUBY1_9)
    public IRubyObject set_do_not_reverse_lookup19(ThreadContext context, IRubyObject flag) {
        this.doNotReverseLookup = flag.isTrue();
        return this.do_not_reverse_lookup19(context);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject do_not_reverse_lookup(IRubyObject recv2) {
        return recv2.getRuntime().isDoNotReverseLookupEnabled() ? recv2.getRuntime().getTrue() : recv2.getRuntime().getFalse();
    }

    @JRubyMethod(name={"do_not_reverse_lookup="}, meta=true)
    public static IRubyObject set_do_not_reverse_lookup(IRubyObject recv2, IRubyObject flag) {
        recv2.getRuntime().setDoNotReverseLookupEnabled(flag.isTrue());
        return recv2.getRuntime().isDoNotReverseLookupEnabled() ? recv2.getRuntime().getTrue() : recv2.getRuntime().getFalse();
    }

    private Channel getOpenChannel() {
        return this.getOpenFileChecked().getMainStream().getDescriptor().getChannel();
    }
}

