/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.evaluator;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.exceptions.JumpException;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.Frame;
import org.jruby.runtime.InterpretedBlock;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ASTInterpreter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_METHOD(Ruby runtime2, ThreadContext context, ISourcePosition position, RubyModule implClass, Node node, String name2, IRubyObject self, Block block) {
        IRubyObject iRubyObject;
        block8: {
            try {
                String className = implClass != self.getMetaClass().getRealClass() ? implClass.getName() + "(" + self.getMetaClass().getName() + ")" : implClass.getName();
                context.pushBacktrace(className, name2, position);
                if (runtime2.hasEventHooks()) {
                    context.trace(RubyEvent.CALL, name2, implClass);
                }
                iRubyObject = node.interpret(runtime2, context, self, block);
                Object var11_10 = null;
                if (!runtime2.hasEventHooks()) break block8;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (runtime2.hasEventHooks()) {
                    try {
                        context.trace(RubyEvent.RETURN, name2, implClass);
                        Object var13_14 = null;
                        context.popBacktrace();
                    }
                    catch (Throwable throwable2) {
                        Object var13_15 = null;
                        context.popBacktrace();
                        throw throwable2;
                    }
                } else {
                    context.popBacktrace();
                }
                throw throwable;
            }
            try {
                context.trace(RubyEvent.RETURN, name2, implClass);
                Object var13_12 = null;
                context.popBacktrace();
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                context.popBacktrace();
                throw throwable;
            }
        }
        context.popBacktrace();
        return iRubyObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(Ruby runtime2, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        try {
            context.pushBacktrace(self.getMetaClass().getName(), name2, node.getPosition());
            IRubyObject iRubyObject = node.interpret(runtime2, context, self, block);
            Object var8_7 = null;
            context.popBacktrace();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            context.popBacktrace();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_EVAL(Ruby runtime2, ThreadContext context, String file2, int line, Node node, String name2, IRubyObject self, Block block) {
        try {
            context.pushBacktrace(self.getMetaClass().getName(), name2, file2, line);
            IRubyObject iRubyObject = node.interpret(runtime2, context, self, block);
            Object var10_9 = null;
            context.popBacktrace();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            context.popBacktrace();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_CLASS(Ruby runtime2, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        try {
            context.pushBacktrace(self.getMetaClass().getName(), name2, node.getPosition());
            IRubyObject iRubyObject = node.interpret(runtime2, context, self, block);
            Object var8_7 = null;
            context.popBacktrace();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            context.popBacktrace();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_BLOCK(Ruby runtime2, ThreadContext context, Node node, String name2, IRubyObject self, Block block) {
        try {
            context.pushBacktrace(self.getMetaClass().getName(), name2, node.getPosition());
            IRubyObject iRubyObject = node.interpret(runtime2, context, self, block);
            Object var8_7 = null;
            context.popBacktrace();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            context.popBacktrace();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject INTERPRET_ROOT(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block block) {
        try {
            context.pushBacktrace(self.getMetaClass().getName(), "(root)", node.getPosition());
            IRubyObject iRubyObject = node.interpret(runtime2, context, self, block);
            Object var7_6 = null;
            context.popBacktrace();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            context.popBacktrace();
            throw throwable;
        }
    }

    @Deprecated
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject src, Binding binding2) {
        return ASTInterpreter.evalWithBinding(context, binding2.getSelf(), src, binding2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalWithBinding(ThreadContext context, IRubyObject self, IRubyObject src, Binding binding2) {
        Ruby runtime2 = src.getRuntime();
        DynamicScope evalScope = binding2.getDynamicScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        Frame lastFrame = context.preEvalWithBinding(binding2);
        try {
            IRubyObject iRubyObject;
            try {
                RubyString source2 = src.convertToString();
                Node node = runtime2.parseEval(source2.getByteList(), binding2.getFile(), evalScope, binding2.getLine());
                iRubyObject = ASTInterpreter.INTERPRET_EVAL(runtime2, context, binding2.getFile(), binding2.getLine(), node, binding2.getMethod(), self, binding2.getFrame().getBlock());
                Object var11_13 = null;
            }
            catch (JumpException.BreakJump bj) {
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            catch (JumpException.RedoJump rj) {
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.REDO, (IRubyObject)rj.getValue(), "unexpected redo");
            }
            catch (StackOverflowError soe) {
                throw runtime2.newSystemStackError("stack level too deep", soe);
            }
            context.postEvalWithBinding(binding2, lastFrame);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            context.postEvalWithBinding(binding2, lastFrame);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IRubyObject evalSimple(ThreadContext context, IRubyObject self, RubyString src, String file2, int lineNumber) {
        assert (file2 != null);
        Ruby runtime2 = src.getRuntime();
        String savedFile = context.getFile();
        int savedLine = context.getLine();
        RubyString source2 = src.convertToString();
        DynamicScope evalScope = context.getCurrentScope().getEvalScope();
        evalScope.getStaticScope().determineModule();
        try {
            IRubyObject iRubyObject;
            try {
                Node node = runtime2.parseEval(source2.getByteList(), file2, evalScope, lineNumber);
                iRubyObject = ASTInterpreter.INTERPRET_EVAL(runtime2, context, file2, lineNumber, node, "(eval)", self, Block.NULL_BLOCK);
                Object var13_14 = null;
            }
            catch (JumpException.BreakJump bj) {
                throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, (IRubyObject)bj.getValue(), "unexpected break");
            }
            catch (StackOverflowError soe) {
                throw runtime2.newSystemStackError("stack level too deep", soe);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            context.setFile(savedFile);
            context.setLine(savedLine);
            throw throwable;
        }
    }

    public static void callTraceFunction(Ruby runtime2, ThreadContext context, RubyEvent event) {
        String name2 = context.getFrameName();
        RubyModule type2 = context.getFrameKlazz();
        runtime2.callEventHooks(context, event, context.getFile(), context.getLine(), name2, type2);
    }

    public static IRubyObject pollAndReturn(ThreadContext context, IRubyObject result) {
        context.pollThreadEvents();
        return result;
    }

    public static IRubyObject multipleAsgnArrayNode(Ruby runtime2, ThreadContext context, MultipleAsgnNode iVisited, ArrayNode node, IRubyObject self, Block aBlock) {
        IRubyObject[] array = new IRubyObject[node.size()];
        for (int i = 0; i < node.size(); ++i) {
            array[i] = node.get(i).interpret(runtime2, context, self, aBlock);
        }
        return AssignmentVisitor.multiAssign(runtime2, context, self, iVisited, RubyArray.newArrayNoCopyLight(runtime2, array), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject evalClassDefinitionBody(Ruby runtime2, ThreadContext context, StaticScope scope, Node bodyNode, RubyModule type2, IRubyObject self, Block block) {
        Object v2;
        block11: {
            Object v1;
            IRubyObject iRubyObject;
            context.preClassEval(scope, type2);
            try {
                if (runtime2.hasEventHooks()) {
                    ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.CLASS);
                }
                if (bodyNode != null) break block11;
                iRubyObject = runtime2.getNil();
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object v0;
                Object var9_11 = null;
                try {
                    if (runtime2.hasEventHooks()) {
                        ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
                    }
                    v0 = null;
                }
                catch (Throwable throwable2) {
                    v0 = null;
                }
                Object var11_17 = v0;
                context.postClassEval();
                throw throwable;
            }
            try {
                if (runtime2.hasEventHooks()) {
                    ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
                }
                v1 = null;
            }
            catch (Throwable throwable) {
                v1 = null;
            }
            Object var11_15 = v1;
            context.postClassEval();
            return iRubyObject;
        }
        IRubyObject iRubyObject = ASTInterpreter.INTERPRET_CLASS(runtime2, context, bodyNode, type2.getBaseName() == null ? "(class)" : "(class " + type2.getBaseName() + ")", type2, block);
        Object var9_10 = null;
        try {
            if (runtime2.hasEventHooks()) {
                ASTInterpreter.callTraceFunction(runtime2, context, RubyEvent.END);
            }
            v2 = null;
        }
        catch (Throwable throwable) {
            v2 = null;
        }
        Object var11_16 = v2;
        context.postClassEval();
        return iRubyObject;
    }

    public static String getArgumentDefinition(Ruby runtime2, ThreadContext context, Node node, String type2, IRubyObject self, Block block) {
        if (node == null) {
            return type2;
        }
        if (node instanceof ArrayNode) {
            ArrayNode list2 = (ArrayNode)node;
            int size2 = list2.size();
            for (int i = 0; i < size2; ++i) {
                if (list2.get(i).definition(runtime2, context, self, block) != null) continue;
                return null;
            }
        } else if (node.definition(runtime2, context, self, block) == null) {
            return null;
        }
        return type2;
    }

    public static Block getBlock(Ruby runtime2, ThreadContext context, IRubyObject self, Block currentBlock, Node blockNode) {
        if (blockNode == null) {
            return Block.NULL_BLOCK;
        }
        if (blockNode instanceof IterNode) {
            return ASTInterpreter.getIterNodeBlock(blockNode, context, self);
        }
        if (blockNode instanceof BlockPassNode) {
            return ASTInterpreter.getBlockPassBlock(blockNode, runtime2, context, self, currentBlock);
        }
        assert (false) : "Trying to get block from something which cannot deliver";
        return null;
    }

    private static Block getBlockPassBlock(Node blockNode, Ruby runtime2, ThreadContext context, IRubyObject self, Block currentBlock) {
        Node bodyNode = ((BlockPassNode)blockNode).getBodyNode();
        IRubyObject proc2 = bodyNode == null ? runtime2.getNil() : bodyNode.interpret(runtime2, context, self, currentBlock);
        return RuntimeHelpers.getBlockFromBlockPassBody(proc2, currentBlock);
    }

    private static Block getIterNodeBlock(Node blockNode, ThreadContext context, IRubyObject self) {
        IterNode iterNode = (IterNode)blockNode;
        StaticScope scope = iterNode.getScope();
        scope.determineModule();
        return InterpretedBlock.newInterpretedClosure(context, iterNode.getBlockBody(), self);
    }

    public static RubyModule getClassVariableBase(ThreadContext context, Ruby runtime2) {
        StaticScope scope = context.getCurrentScope().getStaticScope();
        RubyModule rubyClass = scope.getModule();
        while (rubyClass.isSingleton() || rubyClass == runtime2.getDummy()) {
            if (scope == null) {
                return null;
            }
            scope = scope.getPreviousCRefScope();
            rubyClass = scope.getModule();
            if (scope.getPreviousCRefScope() != null) continue;
            runtime2.getWarnings().warn(IRubyWarnings.ID.CVAR_FROM_TOPLEVEL_SINGLETON_METHOD, "class variable access from toplevel singleton method", new Object[0]);
        }
        return rubyClass;
    }

    public static IRubyObject[] setupArgs(Ruby runtime2, ThreadContext context, Node node, IRubyObject self, Block aBlock) {
        if (node == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (node instanceof ArrayNode) {
            ArrayNode argsArrayNode = (ArrayNode)node;
            String savedFile = context.getFile();
            int savedLine = context.getLine();
            int size2 = argsArrayNode.size();
            IRubyObject[] argsArray = new IRubyObject[size2];
            for (int i = 0; i < size2; ++i) {
                argsArray[i] = argsArrayNode.get(i).interpret(runtime2, context, self, aBlock);
            }
            context.setFile(savedFile);
            context.setLine(savedLine);
            return argsArray;
        }
        return ArgsUtil.convertToJavaArray(node.interpret(runtime2, context, self, aBlock));
    }
}

