/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.internal.AbstractLocalContextProvider;
import org.jruby.embed.internal.BiVariableMap;
import org.jruby.embed.internal.LocalContext;

public class ConcurrentLocalContextProvider
extends AbstractLocalContextProvider {
    private ThreadLocal<LocalContext> contextHolder = new ThreadLocal<LocalContext>(){

        @Override
        public LocalContext initialValue() {
            return ConcurrentLocalContextProvider.this.getInstance();
        }
    };

    public ConcurrentLocalContextProvider(LocalVariableBehavior behavior, boolean lazy) {
        this.config = Ruby.isGlobalRuntimeReady() ? Ruby.getGlobalRuntime().getInstanceConfig() : new RubyInstanceConfig();
        this.behavior = behavior;
        this.lazy = lazy;
    }

    public Ruby getRuntime() {
        if (!Ruby.isGlobalRuntimeReady()) {
            return Ruby.newInstance(this.config);
        }
        return Ruby.getGlobalRuntime();
    }

    public RubyInstanceConfig getRubyInstanceConfig() {
        return this.config;
    }

    public BiVariableMap getVarMap() {
        return this.contextHolder.get().getVarMap(this.getRuntime());
    }

    public Map getAttributeMap() {
        return this.contextHolder.get().getAttributeMap();
    }

    public boolean isRuntimeInitialized() {
        return Ruby.isGlobalRuntimeReady();
    }
}

